/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.dd.trace.common.sampling.DeterministicSampler;
import ddtrot.dd.trace.common.sampling.PrioritySampler;
import ddtrot.dd.trace.common.sampling.RateByServiceTraceSampler;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.common.sampling.SamplingRule;
import ddtrot.dd.trace.common.sampling.TraceSamplingRules;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.util.SimpleRateLimiter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBasedTraceSampler<T extends CoreSpan<T>>
implements Sampler,
PrioritySampler {
    private static final Logger log = LoggerFactory.getLogger(RuleBasedTraceSampler.class);
    private final List<SamplingRule> samplingRules;
    private final PrioritySampler fallbackSampler;
    private final SimpleRateLimiter rateLimiter;
    private final long rateLimit;
    public static final String SAMPLING_RULE_RATE = "_dd.rule_psr";
    public static final String SAMPLING_LIMIT_RATE = "_dd.limit_psr";

    public RuleBasedTraceSampler(List<SamplingRule> samplingRules, int rateLimit, PrioritySampler fallbackSampler) {
        this.samplingRules = samplingRules;
        this.fallbackSampler = fallbackSampler;
        this.rateLimiter = new SimpleRateLimiter(rateLimit);
        this.rateLimit = rateLimit;
    }

    public static RuleBasedTraceSampler build(TraceSamplingRules traceSamplingRules, Double defaultRate, int rateLimit) {
        return RuleBasedTraceSampler.build(null, null, traceSamplingRules, defaultRate, rateLimit);
    }

    public static RuleBasedTraceSampler build(@Deprecated Map<String, String> serviceRules, @Deprecated Map<String, String> operationRules, TraceSamplingRules traceSamplingRules, Double defaultRate, int rateLimit) {
        ArrayList<SamplingRule> samplingRules = new ArrayList<SamplingRule>();
        if (traceSamplingRules != null && !traceSamplingRules.isEmpty()) {
            if (!serviceRules.isEmpty() || !operationRules.isEmpty()) {
                log.warn("Both {} and/or {} as well as {} are defined. Only {} will be used for rule-based sampling", new Object[]{"trace.sampling.service.rules", "trace.sampling.operation.rules", "trace.sampling.rules", "trace.sampling.rules"});
            }
            for (TraceSamplingRules.Rule rule : traceSamplingRules.getRules()) {
                SamplingRule.TraceSamplingRule samplingRule = new SamplingRule.TraceSamplingRule(rule.getService(), rule.getName(), rule.getResource(), new DeterministicSampler.TraceSampler(rule.getSampleRate()));
                samplingRules.add(samplingRule);
            }
        } else {
            SamplingRule.PatternMatchSamplingRule samplingRule;
            if (serviceRules != null) {
                for (Map.Entry<String, String> entry : serviceRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble(entry.getValue());
                        samplingRule = new SamplingRule.ServiceSamplingRule(entry.getKey(), new DeterministicSampler.TraceSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for service: {}", entry, (Object)e);
                    }
                }
            }
            if (operationRules != null) {
                for (Map.Entry<String, String> entry : operationRules.entrySet()) {
                    try {
                        double rateForEntry = Double.parseDouble(entry.getValue());
                        samplingRule = new SamplingRule.OperationSamplingRule(entry.getKey(), new DeterministicSampler.TraceSampler(rateForEntry));
                        samplingRules.add(samplingRule);
                    }
                    catch (NumberFormatException e) {
                        log.error("Unable to parse rate for operation: {}", entry, (Object)e);
                    }
                }
            }
        }
        if (defaultRate != null) {
            SamplingRule.AlwaysMatchesSamplingRule samplingRule = new SamplingRule.AlwaysMatchesSamplingRule(new DeterministicSampler.TraceSampler(defaultRate));
            samplingRules.add(samplingRule);
        }
        return new RuleBasedTraceSampler(samplingRules, rateLimit, new RateByServiceTraceSampler());
    }

    @Override
    public <T extends CoreSpan<T>> boolean sample(T span) {
        return true;
    }

    @Override
    public <T extends CoreSpan<T>> void setSamplingPriority(T span) {
        SamplingRule matchedRule = null;
        for (SamplingRule samplingRule : this.samplingRules) {
            if (!samplingRule.matches(span)) continue;
            matchedRule = samplingRule;
            break;
        }
        if (matchedRule == null) {
            this.fallbackSampler.setSamplingPriority(span);
        } else if (matchedRule.sample(span)) {
            if (this.rateLimiter.tryAcquire()) {
                span.setSamplingPriority(2, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
            } else {
                span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
            }
            span.setMetric((CharSequence)SAMPLING_LIMIT_RATE, this.rateLimit);
        } else {
            span.setSamplingPriority(-1, SAMPLING_RULE_RATE, matchedRule.getSampler().getSampleRate(), 3);
        }
    }
}

