/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import ddtrot.com.squareup.moshi.FromJson;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.ToJson;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.SpanLinkAttributes;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDSpanLink
extends SpanLink {
    private static final Logger LOGGER = LoggerFactory.getLogger(DDSpanLink.class);
    private static final int TAG_MAX_LENGTH = 25000;
    private static JsonAdapter<AgentSpanLink> encoder;

    protected DDSpanLink(DDTraceId traceId, long spanId, byte traceFlags, String traceState, AgentSpanLink.Attributes attributes) {
        super(traceId, spanId, traceFlags, traceState, attributes);
    }

    public static SpanLink from(ExtractedContext context) {
        return DDSpanLink.from(context, SpanLinkAttributes.EMPTY);
    }

    public static SpanLink from(ExtractedContext context, AgentSpanLink.Attributes attributes) {
        byte traceFlags = context.getSamplingPriority() > 0 ? (byte)1 : 0;
        String traceState = context.getPropagationTags() == null ? "" : context.getPropagationTags().headerValue(PropagationTags.HeaderType.W3C);
        return new DDSpanLink(context.getTraceId(), context.getSpanId(), traceFlags, traceState, attributes);
    }

    public static String toTag(List<AgentSpanLink> links) {
        int index;
        if (links == null || links.isEmpty()) {
            return null;
        }
        StringBuilder builder = new StringBuilder("[");
        for (index = 0; index < links.size(); ++index) {
            int arrayCharsNeeded;
            String linkAsJson = DDSpanLink.getEncoder().toJson(links.get(index));
            int n = arrayCharsNeeded = index == 0 ? 1 : 2;
            if (linkAsJson.length() + builder.length() + arrayCharsNeeded >= 25000) break;
            if (index > 0) {
                builder.append(',');
            }
            builder.append(linkAsJson);
        }
        while (index < links.size()) {
            LOGGER.debug("Span tag full. Dropping span links {}", (Object)links.get(index));
            ++index;
        }
        return builder.append(']').toString();
    }

    private static JsonAdapter<AgentSpanLink> getEncoder() {
        if (encoder == null) {
            Moshi moshi = new Moshi.Builder().add(new SpanLinkAdapter()).build();
            encoder = moshi.adapter(AgentSpanLink.class);
        }
        return encoder;
    }

    private static class SpanLinkJson {
        String traceId;
        String spanId;
        Byte traceFlags;
        String traceState;
        Map<String, String> attributes;

        private SpanLinkJson() {
        }
    }

    private static class SpanLinkAdapter {
        private SpanLinkAdapter() {
        }

        @ToJson
        SpanLinkJson toSpanLinkJson(AgentSpanLink link) {
            SpanLinkJson json = new SpanLinkJson();
            json.traceId = link.traceId().toHexString();
            json.spanId = DDSpanId.toHexString((long)link.spanId());
            json.traceFlags = link.traceFlags() == 0 ? null : Byte.valueOf(link.traceFlags());
            String string = json.traceState = link.traceState().isEmpty() ? null : link.traceState();
            if (!link.attributes().isEmpty()) {
                json.attributes = link.attributes().asMap();
            }
            return json;
        }

        @FromJson
        AgentSpanLink fromSpanLinkJson(SpanLinkJson json) {
            return new DDSpanLink(DDTraceId.fromHex((String)json.traceId), DDSpanId.fromHex((String)json.spanId), json.traceFlags, json.traceState, SpanLinkAttributes.fromMap(json.attributes));
        }
    }
}

