/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.flare;

import datadog.trace.api.Config;
import datadog.trace.api.DynamicConfig;
import ddtrot.com.squareup.moshi.Json;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.remoteconfig.ConfigurationChangesListener;
import ddtrot.dd.remoteconfig.ConfigurationPoller;
import ddtrot.dd.remoteconfig.Product;
import ddtrot.dd.remoteconfig.state.ParsedConfigKey;
import ddtrot.dd.remoteconfig.state.ProductListener;
import ddtrot.dd.trace.core.flare.TracerFlareService;
import ddtrot.okio.Okio;
import java.io.ByteArrayInputStream;
import java.io.IOException;

public final class TracerFlarePoller {
    private static final String FLARE_LOG_LEVEL_PREFIX = "flare-log-level.";
    private final DynamicConfig dynamicConfig;
    private Runnable stopPreparer;
    private Runnable stopSubmitter;
    private TracerFlareService tracerFlareService;

    public TracerFlarePoller(DynamicConfig dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public void start(Config config, SharedCommunicationObjects sco) {
        this.stopPreparer = new Preparer().register(config, sco);
        this.stopSubmitter = new Submitter().register(config, sco);
        this.tracerFlareService = new TracerFlareService(this.dynamicConfig, sco.okHttpClient, sco.agentUrl);
    }

    public void stop() {
        if (null != this.stopPreparer) {
            this.stopPreparer.run();
        }
        if (null != this.stopSubmitter) {
            this.stopSubmitter.run();
        }
    }

    void prepareTracerFlare(String logLevel) {
        this.tracerFlareService.prepareTracerFlare(logLevel);
    }

    void cancelTracerFlare() {
        this.tracerFlareService.cancelTracerFlare();
    }

    void submitTracerFlare(AgentTaskArgs args) {
        this.tracerFlareService.sendFlare(args.caseId, args.userHandle, args.hostname);
    }

    static final class AgentTaskArgs {
        @Json(name="case_id")
        public String caseId;
        @Json(name="user_handle")
        public String userHandle;
        @Json(name="hostname")
        public String hostname;

        AgentTaskArgs() {
        }
    }

    static final class AgentTask {
        @Json(name="task_type")
        public String taskType;
        @Json(name="args")
        public AgentTaskArgs args;

        AgentTask() {
        }
    }

    static final class AgentConfig {
        @Json(name="log_level")
        public String logLevel;

        AgentConfig() {
        }
    }

    static final class AgentConfigLayer {
        @Json(name="name")
        public String name;
        @Json(name="config")
        public AgentConfig config;

        AgentConfigLayer() {
        }
    }

    final class Submitter
    implements ProductListener {
        private final JsonAdapter<AgentTask> AGENT_TASK_ADAPTER;

        Submitter() {
            Moshi MOSHI = new Moshi.Builder().build();
            this.AGENT_TASK_ADAPTER = MOSHI.adapter(AgentTask.class);
        }

        public Runnable register(Config config, SharedCommunicationObjects sco) {
            ConfigurationPoller poller = sco.configurationPoller(config);
            if (null != poller) {
                poller.addListener(Product.AGENT_TASK, (ProductListener)this);
                return () -> ((ConfigurationPoller)poller).stop();
            }
            return null;
        }

        public void accept(ParsedConfigKey configKey, byte[] content, ConfigurationChangesListener.PollingRateHinter hinter) throws IOException {
            AgentTask agentTask = this.AGENT_TASK_ADAPTER.fromJson(Okio.buffer(Okio.source(new ByteArrayInputStream(content))));
            if (null != agentTask && null != agentTask.args && "tracer_flare".equals(agentTask.taskType)) {
                TracerFlarePoller.this.submitTracerFlare(agentTask.args);
            }
        }

        public void remove(ParsedConfigKey configKey, ConfigurationChangesListener.PollingRateHinter hinter) {
        }

        public void commit(ConfigurationChangesListener.PollingRateHinter hinter) {
        }
    }

    final class Preparer
    implements ProductListener {
        private final JsonAdapter<AgentConfigLayer> AGENT_CONFIG_LAYER_ADAPTER;

        Preparer() {
            Moshi MOSHI = new Moshi.Builder().build();
            this.AGENT_CONFIG_LAYER_ADAPTER = MOSHI.adapter(AgentConfigLayer.class);
        }

        public Runnable register(Config config, SharedCommunicationObjects sco) {
            ConfigurationPoller poller = sco.configurationPoller(config);
            if (null != poller) {
                poller.addListener(Product.AGENT_CONFIG, (ProductListener)this);
                return () -> ((ConfigurationPoller)poller).stop();
            }
            return null;
        }

        public void accept(ParsedConfigKey configKey, byte[] content, ConfigurationChangesListener.PollingRateHinter hinter) throws IOException {
            if (configKey.getConfigId().startsWith(TracerFlarePoller.FLARE_LOG_LEVEL_PREFIX)) {
                AgentConfigLayer agentConfigLayer = this.AGENT_CONFIG_LAYER_ADAPTER.fromJson(Okio.buffer(Okio.source(new ByteArrayInputStream(content))));
                if (null != agentConfigLayer && null != agentConfigLayer.config && null != agentConfigLayer.config.logLevel) {
                    TracerFlarePoller.this.prepareTracerFlare(agentConfigLayer.config.logLevel);
                } else {
                    TracerFlarePoller.this.cancelTracerFlare();
                }
            }
        }

        public void remove(ParsedConfigKey configKey, ConfigurationChangesListener.PollingRateHinter hinter) {
            if (configKey.getConfigId().startsWith(TracerFlarePoller.FLARE_LOG_LEVEL_PREFIX)) {
                TracerFlarePoller.this.cancelTracerFlare();
            }
        }

        public void commit(ConfigurationChangesListener.PollingRateHinter hinter) {
        }
    }
}

