/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.flare;

import datadog.trace.api.DynamicConfig;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.MediaType;
import ddtrot.okhttp3.MultipartBody;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.RequestBody;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TracerFlareService {
    private static final Logger log = LoggerFactory.getLogger(TracerFlareService.class);
    private static final String FLARE_ENDPOINT = "tracer_flare/v1";
    private static final MediaType OCTET_STREAM = MediaType.get("application/octet-stream");
    private final AgentTaskScheduler scheduler = new AgentTaskScheduler(AgentThreadFactory.AgentThread.TRACER_FLARE);
    private final DynamicConfig dynamicConfig;
    private final OkHttpClient okHttpClient;
    private final HttpUrl flareUrl;
    private AtomicBoolean preparingTracerFlare = new AtomicBoolean();

    TracerFlareService(DynamicConfig dynamicConfig, OkHttpClient okHttpClient, HttpUrl agentUrl) {
        this.dynamicConfig = dynamicConfig;
        this.okHttpClient = okHttpClient;
        this.flareUrl = agentUrl.newBuilder().addPathSegments(FLARE_ENDPOINT).build();
    }

    public void prepareTracerFlare(String logLevel) {
        if (this.preparingTracerFlare.compareAndSet(false, true)) {
            log.debug("Preparing tracer flare, logLevel={}", (Object)logLevel);
        }
    }

    public void sendFlare(String caseId, String email, String hostname) {
        log.debug("Sending tracer flare");
        this.scheduler.execute(() -> this.doSendFlare(caseId, email, hostname));
    }

    public void cancelTracerFlare() {
        if (this.preparingTracerFlare.compareAndSet(true, false)) {
            log.debug("Canceling tracer flare");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendFlare(String caseId, String email, String hostname) {
        RequestBody report = RequestBody.create(OCTET_STREAM, TracerFlareService.placeholderZip());
        MultipartBody form = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("source", "tracer_java").addFormDataPart("case_id", caseId).addFormDataPart("email", email).addFormDataPart("hostname", hostname).addFormDataPart("flare_file", "java-flare.zip", report).build();
        Request flareRequest = OkHttpUtils.prepareRequest(this.flareUrl, Collections.emptyMap()).post(form).build();
        try (Response response = this.okHttpClient.newCall(flareRequest).execute();){
            if (response.code() == 404) {
                log.debug("Tracer flare endpoint is disabled, ignoring request");
            } else if (!response.isSuccessful()) {
                log.warn("Tracer flare failed with: {} {}", (Object)response.code(), (Object)response.message());
            } else {
                log.debug("Tracer flare sent successfully");
            }
        }
        catch (IOException e) {
            log.warn("Tracer flare failed with exception: {}", (Object)e.toString());
        }
        finally {
            this.preparingTracerFlare.set(false);
        }
    }

    /*
     * Exception decompiling
     */
    private static byte[] placeholderZip() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

