/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.TracePropagationStyle;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.datastreams.DataStreamContextInjector;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import java.util.LinkedHashMap;
import java.util.Map;

public class CorePropagation
implements AgentPropagation {
    private final HttpCodec.Injector injector;
    private final Map<TracePropagationStyle, HttpCodec.Injector> injectors;
    private final DataStreamContextInjector dataStreamContextInjector;
    private final HttpCodec.Extractor extractor;

    public CorePropagation(HttpCodec.Extractor extractor, HttpCodec.Injector defaultInjector, Map<TracePropagationStyle, HttpCodec.Injector> injectors, DataStreamContextInjector dataStreamContextInjector) {
        this.extractor = extractor;
        this.injector = defaultInjector;
        this.injectors = injectors;
        this.dataStreamContextInjector = dataStreamContextInjector;
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(span.context(), carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        this.inject(context, carrier, setter, null);
    }

    @Override
    public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        this.inject(span.context(), carrier, setter, style);
    }

    private <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        if (!(context instanceof DDSpanContext)) {
            return;
        }
        DDSpanContext ddSpanContext = (DDSpanContext)context;
        ddSpanContext.getTrace().setSamplingPriorityIfNecessary();
        if (null == style) {
            this.injector.inject(ddSpanContext, carrier, setter);
        } else {
            this.injectors.get(style).inject(ddSpanContext, carrier, setter);
        }
    }

    @Override
    public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        this.dataStreamContextInjector.injectPathwayContext(span, carrier, setter, sortedTags);
    }

    @Override
    public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags, long defaultTimestamp, long payloadSizeBytes) {
        this.dataStreamContextInjector.injectPathwayContext(span, carrier, setter, sortedTags, defaultTimestamp, payloadSizeBytes);
    }

    @Override
    public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
        return this.extractor.extract(carrier, getter);
    }
}

