/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import ddtrot.dd.trace.core.util.GlobPattern;
import ddtrot.dd.trace.core.util.Matcher;
import java.util.regex.Pattern;

public final class Matchers {
    private Matchers() {
    }

    public static final Matcher compileGlob(String glob) {
        if (glob == null || glob.equals("*")) {
            return null;
        }
        if (Matchers.isExact(glob)) {
            return new ExactMatcher(glob);
        }
        Pattern pattern = GlobPattern.globToRegexPattern(glob);
        return pattern == null ? null : new PatternMatcher(pattern);
    }

    public static boolean matches(Matcher matcher, String str) {
        return matcher == null || matcher.matches(str);
    }

    public static boolean matches(Matcher matcher, CharSequence charSeq) {
        return matcher == null || matcher.matches(charSeq);
    }

    static boolean isExact(String glob) {
        return glob.indexOf(42) == -1 && glob.indexOf(63) == -1;
    }

    static final class PatternMatcher
    implements Matcher {
        private final Pattern pattern;

        PatternMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(CharSequence charSeq) {
            return this.pattern.matcher(charSeq).matches();
        }

        @Override
        public boolean matches(String str) {
            return this.pattern.matcher(str).matches();
        }
    }

    static final class ExactMatcher
    implements Matcher {
        private final String exact;

        ExactMatcher(String exact) {
            this.exact = exact;
        }

        @Override
        public boolean matches(String str) {
            return this.exact.equals(str);
        }

        @Override
        public boolean matches(CharSequence charSeq) {
            return this.exact.contentEquals(charSeq);
        }
    }
}

