/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util;

public class FNV64Hash {
    private static final long FNV_INIT = -3750763034362895579L;
    private static final long FNV_PRIME = 1099511628211L;

    public static long generateHash(String data, Version version) {
        return FNV64Hash.generateHash(data.getBytes(), version);
    }

    public static long generateHash(byte[] data, Version version) {
        return FNV64Hash.generateHash(data, 0, data.length, version);
    }

    public static long generateHash(byte[] data, int start, int length, Version version) {
        if (version == Version.v1) {
            return FNV64Hash.generateFNV1Hash(data, start, length);
        }
        return FNV64Hash.generateFNV1AHash(data, start, length);
    }

    private static long generateFNV1Hash(byte[] data, int start, int length) {
        long hash = -3750763034362895579L;
        for (int i = start; i < start + length; ++i) {
            hash *= 1099511628211L;
            hash ^= 0xFFL & (long)data[i];
        }
        return hash;
    }

    private static long generateFNV1AHash(byte[] data, int start, int length) {
        long hash = -3750763034362895579L;
        for (int i = start; i < start + length; ++i) {
            hash ^= 0xFFL & (long)data[i];
            hash *= 1099511628211L;
        }
        return hash;
    }

    public static enum Version {
        v1,
        v1A;

    }
}

