/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.util.stacktrace;

import ddtrot.dd.trace.util.stacktrace.AbstractStackWalker;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Predicate;

public abstract class StackUtils {
    public static <E extends Throwable> E update(E exception, Function<StackTraceElement[], StackTraceElement[]> filter) {
        StackTraceElement[] stack = exception.getStackTrace();
        exception.setStackTrace(filter.apply(stack));
        return exception;
    }

    public static <E extends Throwable> E filter(E exception, Predicate<StackTraceElement> filter) {
        return StackUtils.update(exception, stack -> (StackTraceElement[])Arrays.stream(stack).filter(filter).toArray(StackTraceElement[]::new));
    }

    public static <E extends Throwable> E filterFirst(E exception, Predicate<StackTraceElement> filter) {
        return StackUtils.filter(exception, new OneTimePredicate<StackTraceElement>(filter));
    }

    public static <E extends Throwable> E filterDatadog(E exception) {
        return StackUtils.filter(exception, AbstractStackWalker::isNotDatadogTraceStackElement);
    }

    public static <E extends Throwable> E filterFirstDatadog(E exception) {
        return StackUtils.filterFirst(exception, AbstractStackWalker::isNotDatadogTraceStackElement);
    }

    public static <E extends Throwable> E filterUntil(E exception, Predicate<StackTraceElement> trace) {
        return StackUtils.update(exception, stack -> {
            StackTraceElement[] source = exception.getStackTrace();
            for (int i = 0; i < source.length; ++i) {
                if (!trace.test(source[i])) continue;
                StackTraceElement[] result = new StackTraceElement[source.length - i - 1];
                System.arraycopy(source, i + 1, result, 0, result.length);
                return result;
            }
            return source;
        });
    }

    public static <E extends Throwable> E filterPackagesIn(E exception, String[] packages) {
        return StackUtils.filter(exception, ste -> {
            String clazz = ste.getClassName();
            for (String p : packages) {
                if (!clazz.startsWith(p)) continue;
                return true;
            }
            return false;
        });
    }

    private static class OneTimePredicate<T>
    implements Predicate<T> {
        private final Predicate<T> delegate;
        private boolean filtered;

        private OneTimePredicate(Predicate<T> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean test(T item) {
            if (this.filtered) {
                return true;
            }
            boolean test = this.delegate.test(item);
            if (!test) {
                this.filtered = true;
            }
            return test;
        }
    }
}

