/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming.v0;

import ddtrot.dd.trace.api.naming.NamingSchema;
import javax.annotation.Nonnull;

public class CacheNamingV0
implements NamingSchema.ForCache {
    private final boolean allowInferredServices;

    public CacheNamingV0(boolean allowInferredServices) {
        this.allowInferredServices = allowInferredServices;
    }

    @Override
    @Nonnull
    public String operation(@Nonnull String cacheSystem) {
        String postfix;
        switch (cacheSystem) {
            case "ignite": {
                postfix = ".cache";
                break;
            }
            case "hazelcast": {
                postfix = ".invoke";
                break;
            }
            default: {
                postfix = ".query";
            }
        }
        return cacheSystem + postfix;
    }

    @Override
    public String service(@Nonnull String cacheSystem) {
        if (!this.allowInferredServices) {
            return null;
        }
        if ("hazelcast".equals(cacheSystem)) {
            return "hazelcast-sdk";
        }
        return cacheSystem;
    }
}

