/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.DDSpanId;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.DynamicConfig;
import datadog.trace.api.IdGenerationStrategy;
import datadog.trace.api.InstrumenterConfig;
import datadog.trace.api.StatsDClient;
import datadog.trace.api.TracePropagationStyle;
import datadog.trace.api.experimental.DataStreamsCheckpointer;
import datadog.trace.api.interceptor.MutableSpan;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.api.internal.TraceSegment;
import datadog.trace.api.profiling.Timer;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.ExternalAgentLauncher;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.communication.monitor.DDAgentStatsDClientManager;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.communication.monitor.Recording;
import ddtrot.dd.trace.api.EndpointCheckpointer;
import ddtrot.dd.trace.api.EndpointCheckpointerHolder;
import ddtrot.dd.trace.api.EndpointTracker;
import ddtrot.dd.trace.api.gateway.CallbackProvider;
import ddtrot.dd.trace.api.gateway.InstrumentationGateway;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.gateway.SubscriptionService;
import ddtrot.dd.trace.api.naming.SpanNaming;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.api.time.SystemTimeSource;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentDataStreamsMonitoring;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentHistogram;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScopeManager;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpanLink;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ProfilingContextIntegration;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeState;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.civisibility.interceptor.CiVisibilityApmProtocolInterceptor;
import ddtrot.dd.trace.civisibility.interceptor.CiVisibilityTraceInterceptor;
import ddtrot.dd.trace.common.GitMetadataTraceInterceptor;
import ddtrot.dd.trace.common.metrics.MetricsAggregator;
import ddtrot.dd.trace.common.metrics.MetricsAggregatorFactory;
import ddtrot.dd.trace.common.sampling.Sampler;
import ddtrot.dd.trace.common.sampling.SingleSpanSampler;
import ddtrot.dd.trace.common.sampling.SpanSamplingRules;
import ddtrot.dd.trace.common.sampling.TraceSamplingRules;
import ddtrot.dd.trace.common.writer.DDAgentWriter;
import ddtrot.dd.trace.common.writer.Writer;
import ddtrot.dd.trace.common.writer.WriterFactory;
import ddtrot.dd.trace.common.writer.ddintake.DDIntakeTraceInterceptor;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.core.PendingTrace;
import ddtrot.dd.trace.core.PendingTraceBuffer;
import ddtrot.dd.trace.core.StatusLogger;
import ddtrot.dd.trace.core.TracingConfigPoller;
import ddtrot.dd.trace.core.datastreams.DataStreamContextInjector;
import ddtrot.dd.trace.core.datastreams.DataStreamsMonitoring;
import ddtrot.dd.trace.core.datastreams.DefaultDataStreamsMonitoring;
import ddtrot.dd.trace.core.flare.TracerFlarePoller;
import ddtrot.dd.trace.core.histogram.Histograms;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.dd.trace.core.monitor.MonitoringImpl;
import ddtrot.dd.trace.core.monitor.TracerHealthMetrics;
import ddtrot.dd.trace.core.propagation.CorePropagation;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import ddtrot.dd.trace.core.scopemanager.ContinuableScopeManager;
import ddtrot.dd.trace.core.taginterceptor.RuleFlags;
import ddtrot.dd.trace.core.taginterceptor.TagInterceptor;
import ddtrot.dd.trace.lambda.LambdaHandler;
import ddtrot.dd.trace.relocate.api.RatelimitedLogger;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.dd.trace.util.CollectionUtils;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoreTracer
implements AgentTracer.TracerAPI {
    private static final Logger log = LoggerFactory.getLogger(CoreTracer.class);
    public static final BigInteger TRACE_ID_MAX = BigInteger.valueOf(2L).pow(64).subtract(BigInteger.ONE);
    private static final String LANG_STATSD_TAG = "lang";
    private static final String LANG_VERSION_STATSD_TAG = "lang_version";
    private static final String LANG_INTERPRETER_STATSD_TAG = "lang_interpreter";
    private static final String LANG_INTERPRETER_VENDOR_STATSD_TAG = "lang_interpreter_vendor";
    private static final String TRACER_VERSION_STATSD_TAG = "tracer_version";
    private final long startTimeNano;
    private final long startNanoTicks;
    private final long clockSyncPeriod;
    private final boolean allowInferredServices;
    private volatile long lastSyncTicks;
    private volatile long counterDrift;
    private final TracerFlarePoller tracerFlarePoller;
    private final TracingConfigPoller tracingConfigPoller;
    private final PendingTraceBuffer pendingTraceBuffer;
    final String serviceName;
    final Writer writer;
    final Sampler initialSampler;
    final AgentScopeManager scopeManager;
    final MetricsAggregator metricsAggregator;
    final Config initialConfig;
    private final DynamicConfig<ConfigSnapshot> dynamicConfig;
    private final Map<String, ?> localRootSpanTags;
    private final Map<String, ?> defaultSpanTags;
    private final int partialFlushMinSpans;
    private final StatsDClient statsDClient;
    private final Monitoring monitoring;
    private final Monitoring performanceMonitoring;
    private final HealthMetrics healthMetrics;
    private final Recording traceWriteTimer;
    private final IdGenerationStrategy idGenerationStrategy;
    private final PendingTrace.Factory pendingTraceFactory;
    private final EndpointCheckpointerHolder endpointCheckpointer;
    private final DataStreamsMonitoring dataStreamsMonitoring;
    private final ExternalAgentLauncher externalAgentLauncher;
    private final boolean disableSamplingMechanismValidation;
    private final TimeSource timeSource;
    private final ProfilingContextIntegration profilingContextIntegration;
    private boolean injectBaggageAsTags;
    private Timer timer = Timer.NoOp.INSTANCE;
    private final Thread shutdownCallback;
    private final TagInterceptor tagInterceptor;
    private final SortedSet<TraceInterceptor> interceptors = new ConcurrentSkipListSet<TraceInterceptor>(Comparator.comparingInt(TraceInterceptor::priority));
    private final CorePropagation propagation;
    private final boolean logs128bTraceIdEnabled;
    private final InstrumentationGateway instrumentationGateway;
    private final CallbackProvider callbackProviderAppSec;
    private final CallbackProvider callbackProviderIast;
    private final CallbackProvider universalCallbackProvider;
    private final PropagationTags.Factory propagationTagsFactory;
    private final RatelimitedLogger rlLog = new RatelimitedLogger(log, 1, TimeUnit.MINUTES);

    public static CoreTracerBuilder builder() {
        return new CoreTracerBuilder();
    }

    @Override
    public ConfigSnapshot captureTraceConfig() {
        return this.dynamicConfig.captureTraceConfig();
    }

    @Override
    public AgentHistogram newHistogram(double relativeAccuracy, int maxNumBins) {
        return Histograms.newHistogram(relativeAccuracy, maxNumBins);
    }

    PropagationTags.Factory getPropagationTagsFactory() {
        return this.propagationTagsFactory;
    }

    @Override
    public void onRootSpanFinished(AgentSpan root, EndpointTracker tracker) {
        this.endpointCheckpointer.onRootSpanFinished(root, tracker);
    }

    @Override
    public EndpointTracker onRootSpanStarted(AgentSpan root) {
        return this.endpointCheckpointer.onRootSpanStarted(root);
    }

    @Override
    public ScopeState newScopeState() {
        return this.scopeManager.newScopeState();
    }

    private CoreTracer(Config config, String serviceName, SharedCommunicationObjects sharedCommunicationObjects, Writer writer, IdGenerationStrategy idGenerationStrategy, Sampler sampler, SingleSpanSampler singleSpanSampler, HttpCodec.Injector injector, HttpCodec.Extractor extractor, AgentScopeManager scopeManager, Map<String, ?> localRootSpanTags, Map<String, ?> defaultSpanTags, Map<String, String> serviceNameMappings, Map<String, String> taggedHeaders, Map<String, String> baggageMapping, int partialFlushMinSpans, StatsDClient statsDClient, TagInterceptor tagInterceptor, boolean strictTraceWrites, InstrumentationGateway instrumentationGateway, TimeSource timeSource, DataStreamsMonitoring dataStreamsMonitoring, ProfilingContextIntegration profilingContextIntegration, boolean pollForTracerFlareRequests, boolean pollForTracingConfiguration, boolean injectBaggageAsTags) {
        assert (localRootSpanTags != null);
        assert (defaultSpanTags != null);
        assert (serviceNameMappings != null);
        assert (taggedHeaders != null);
        assert (baggageMapping != null);
        this.timeSource = timeSource == null ? SystemTimeSource.INSTANCE : timeSource;
        this.startTimeNano = this.timeSource.getCurrentTimeNanos();
        this.startNanoTicks = this.timeSource.getNanoTicks();
        this.clockSyncPeriod = Math.max(1000000L, TimeUnit.SECONDS.toNanos(config.getClockSyncPeriod()));
        this.lastSyncTicks = this.startNanoTicks;
        this.endpointCheckpointer = EndpointCheckpointerHolder.create();
        this.serviceName = serviceName;
        this.initialConfig = config;
        this.initialSampler = sampler;
        TraceSamplingRules traceSamplingRules = config.getTraceSamplingRules() == null ? TraceSamplingRules.EMPTY : TraceSamplingRules.deserialize(config.getTraceSamplingRules());
        String spanSamplingRulesJson = config.getSpanSamplingRules();
        String spanSamplingRulesFile = config.getSpanSamplingRulesFile();
        SpanSamplingRules spanSamplingRules = SpanSamplingRules.EMPTY;
        if (spanSamplingRulesJson != null) {
            spanSamplingRules = SpanSamplingRules.deserialize(spanSamplingRulesJson);
        } else if (spanSamplingRulesFile != null) {
            spanSamplingRules = SpanSamplingRules.deserializeFile(spanSamplingRulesFile);
        }
        this.dynamicConfig = DynamicConfig.create((x$0, x$1) -> new ConfigSnapshot((DynamicConfig.Builder)x$0, (ConfigSnapshot)x$1)).setDebugEnabled(config.isDebugEnabled()).setTriageEnabled(config.isTriageEnabled()).setRuntimeMetricsEnabled(config.isRuntimeMetricsEnabled()).setLogsInjectionEnabled(config.isLogsInjectionEnabled()).setDataStreamsEnabled(config.isDataStreamsEnabled()).setServiceMapping(serviceNameMappings).setHeaderTags(taggedHeaders).setBaggageMapping(baggageMapping).setTraceSampleRate(config.getTraceSampleRate()).setSpanSamplingRules(spanSamplingRules.getRules()).setTraceSamplingRules(traceSamplingRules.getRules()).apply();
        this.logs128bTraceIdEnabled = InstrumenterConfig.get().isLogs128bTraceIdEnabled();
        this.defaultSpanTags = defaultSpanTags;
        this.partialFlushMinSpans = partialFlushMinSpans;
        IdGenerationStrategy idGenerationStrategy2 = this.idGenerationStrategy = null == idGenerationStrategy ? Config.get().getIdGenerationStrategy() : idGenerationStrategy;
        this.statsDClient = statsDClient != null ? statsDClient : (writer == null || writer instanceof DDAgentWriter ? CoreTracer.createStatsDClient(config) : StatsDClient.NO_OP);
        this.monitoring = config.isHealthMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.healthMetrics = config.isHealthMetricsEnabled() ? new TracerHealthMetrics(this.statsDClient) : HealthMetrics.NO_OP;
        this.healthMetrics.start();
        this.performanceMonitoring = config.isPerfMetricsEnabled() ? new MonitoringImpl(this.statsDClient, 10L, TimeUnit.SECONDS) : Monitoring.DISABLED;
        this.traceWriteTimer = this.performanceMonitoring.newThreadLocalTimer("trace.write");
        this.scopeManager = scopeManager == null ? new ContinuableScopeManager(config.getScopeDepthLimit(), config.isScopeStrictMode(), config.isScopeInheritAsyncPropagation(), profilingContextIntegration, this.healthMetrics) : scopeManager;
        this.externalAgentLauncher = new ExternalAgentLauncher(config);
        this.disableSamplingMechanismValidation = config.isSamplingMechanismValidationDisabled();
        if (sharedCommunicationObjects == null) {
            sharedCommunicationObjects = new SharedCommunicationObjects();
        }
        sharedCommunicationObjects.monitoring = this.monitoring;
        sharedCommunicationObjects.createRemaining(config);
        this.tracerFlarePoller = new TracerFlarePoller(this.dynamicConfig);
        if (pollForTracerFlareRequests) {
            this.tracerFlarePoller.start(config, sharedCommunicationObjects);
        }
        this.tracingConfigPoller = new TracingConfigPoller(this.dynamicConfig);
        if (pollForTracingConfiguration) {
            this.tracingConfigPoller.start(config, sharedCommunicationObjects);
        }
        this.writer = writer == null ? WriterFactory.createWriter(config, sharedCommunicationObjects, sampler, singleSpanSampler, this.statsDClient) : writer;
        this.pendingTraceBuffer = strictTraceWrites ? PendingTraceBuffer.discarding() : PendingTraceBuffer.delaying(this.timeSource, config, sharedCommunicationObjects, this.healthMetrics);
        this.pendingTraceFactory = new PendingTrace.Factory(this, this.pendingTraceBuffer, this.timeSource, strictTraceWrites, this.healthMetrics);
        this.pendingTraceBuffer.start();
        this.writer.start();
        this.metricsAggregator = MetricsAggregatorFactory.createMetricsAggregator(config, sharedCommunicationObjects);
        AgentTaskScheduler.INSTANCE.scheduleWithJitter(MetricsAggregator::start, this.metricsAggregator, 1L, TimeUnit.SECONDS);
        this.dataStreamsMonitoring = dataStreamsMonitoring == null ? new DefaultDataStreamsMonitoring(config, sharedCommunicationObjects, this.timeSource, this::captureTraceConfig) : dataStreamsMonitoring;
        this.dataStreamsMonitoring.start();
        HttpCodec.Extractor builtExtractor = extractor == null ? HttpCodec.createExtractor(config, this::captureTraceConfig) : extractor;
        builtExtractor = this.dataStreamsMonitoring.extractor(builtExtractor);
        Map<TracePropagationStyle, HttpCodec.Injector> injectors = HttpCodec.allInjectorsFor(config, CoreTracer.invertMap(baggageMapping));
        DataStreamContextInjector dataStreamContextInjector = this.dataStreamsMonitoring.injector();
        this.propagation = new CorePropagation(builtExtractor, injector, injectors, dataStreamContextInjector);
        TagInterceptor tagInterceptor2 = this.tagInterceptor = null == tagInterceptor ? new TagInterceptor(new RuleFlags(config)) : tagInterceptor;
        if (config.isCiVisibilityEnabled()) {
            if (config.isCiVisibilityTraceSanitationEnabled()) {
                this.addTraceInterceptor((TraceInterceptor)CiVisibilityTraceInterceptor.INSTANCE);
            }
            if (config.isCiVisibilityAgentlessEnabled()) {
                this.addTraceInterceptor((TraceInterceptor)DDIntakeTraceInterceptor.INSTANCE);
            } else {
                DDAgentFeaturesDiscovery featuresDiscovery = sharedCommunicationObjects.featuresDiscovery(config);
                if (!featuresDiscovery.supportsEvpProxy()) {
                    this.addTraceInterceptor((TraceInterceptor)CiVisibilityApmProtocolInterceptor.INSTANCE);
                }
            }
        }
        if (config.isTraceGitMetadataEnabled()) {
            this.addTraceInterceptor(GitMetadataTraceInterceptor.INSTANCE);
        }
        this.instrumentationGateway = instrumentationGateway;
        this.callbackProviderAppSec = instrumentationGateway.getCallbackProvider(RequestContextSlot.APPSEC);
        this.callbackProviderIast = instrumentationGateway.getCallbackProvider(RequestContextSlot.IAST);
        this.universalCallbackProvider = instrumentationGateway.getUniversalCallbackProvider();
        this.shutdownCallback = new ShutdownHook(this);
        try {
            Runtime.getRuntime().addShutdownHook(this.shutdownCallback);
        }
        catch (IllegalStateException featuresDiscovery) {
            // empty catch block
        }
        this.registerClassLoader(ClassLoader.getSystemClassLoader());
        StatusLogger.logStatus(config);
        this.propagationTagsFactory = PropagationTags.factory(config);
        this.profilingContextIntegration = profilingContextIntegration;
        this.injectBaggageAsTags = injectBaggageAsTags;
        this.allowInferredServices = SpanNaming.instance().namingSchema().allowInferredServices();
        if (profilingContextIntegration != ProfilingContextIntegration.NoOp.INSTANCE) {
            HashMap tmp = new HashMap(localRootSpanTags);
            tmp.put("_dd.profiling.ctx", profilingContextIntegration.name());
            this.localRootSpanTags = CollectionUtils.tryMakeImmutableMap(tmp);
        } else {
            this.localRootSpanTags = localRootSpanTags;
        }
    }

    public void rebuildTraceConfig(Config config) {
        this.dynamicConfig.initial().setDebugEnabled(config.isDebugEnabled()).setTriageEnabled(config.isTriageEnabled()).setRuntimeMetricsEnabled(config.isRuntimeMetricsEnabled()).setLogsInjectionEnabled(config.isLogsInjectionEnabled()).setDataStreamsEnabled(config.isDataStreamsEnabled()).setServiceMapping(config.getServiceMapping()).setHeaderTags(config.getRequestHeaderTags()).setBaggageMapping(config.getBaggageMapping()).setTraceSampleRate(config.getTraceSampleRate()).apply();
    }

    protected void finalize() {
        if (null != this.shutdownCallback) {
            try {
                this.shutdownCallback.run();
                Runtime.getRuntime().removeShutdownHook(this.shutdownCallback);
            }
            catch (IllegalStateException illegalStateException) {
            }
            catch (Exception e) {
                log.error("Error while finalizing DDTracer.", (Throwable)e);
            }
        }
    }

    public PendingTrace createTrace(DDTraceId id) {
        return this.pendingTraceFactory.create(id);
    }

    PendingTrace createTrace(DDTraceId id, ConfigSnapshot traceConfig) {
        return this.pendingTraceFactory.create(id, traceConfig);
    }

    private void registerClassLoader(ClassLoader classLoader) {
        try {
            for (TraceInterceptor interceptor : ServiceLoader.load(TraceInterceptor.class, classLoader)) {
                this.addTraceInterceptor(interceptor);
            }
        }
        catch (ServiceConfigurationError e) {
            log.warn("Problem loading TraceInterceptor for classLoader: {}", (Object)classLoader, (Object)e);
        }
    }

    long getTimeWithNanoTicks(long nanoTicks) {
        long computedNanoTime = this.startTimeNano + Math.max(0L, nanoTicks - this.startNanoTicks);
        if (nanoTicks - this.lastSyncTicks >= this.clockSyncPeriod) {
            long drift = computedNanoTime - this.timeSource.getCurrentTimeNanos();
            if (Math.abs(drift + this.counterDrift) >= 1000000L) {
                this.counterDrift = -TimeUnit.MILLISECONDS.toNanos(TimeUnit.NANOSECONDS.toMillis(drift));
            }
            this.lastSyncTicks = nanoTicks;
        }
        return computedNanoTime + this.counterDrift;
    }

    @Override
    public CoreSpanBuilder buildSpan(String instrumentationName, CharSequence operationName) {
        return new CoreSpanBuilder(instrumentationName, operationName, this);
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName) {
        return this.buildSpan(instrumentationName, spanName).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, long startTimeMicros) {
        return this.buildSpan(instrumentationName, spanName).withStartTimestamp(startTimeMicros).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent) {
        return this.buildSpan(instrumentationName, spanName).ignoreActiveSpan().asChildOf(parent).start();
    }

    @Override
    public AgentSpan startSpan(String instrumentationName, CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
        return this.buildSpan(instrumentationName, spanName).ignoreActiveSpan().asChildOf(parent).withStartTimestamp(startTimeMicros).start();
    }

    public AgentScope activateSpan(AgentSpan span) {
        return this.scopeManager.activate(span, ScopeSource.INSTRUMENTATION, true);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
        return this.scopeManager.activate(span, source);
    }

    @Override
    public AgentScope activateSpan(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
        return this.scopeManager.activate(span, source, isAsyncPropagating);
    }

    @Override
    public AgentScope.Continuation captureSpan(AgentSpan span) {
        return this.scopeManager.captureSpan(span);
    }

    @Override
    public void closePrevious(boolean finishSpan) {
        this.scopeManager.closePrevious(finishSpan);
    }

    @Override
    public AgentScope activateNext(AgentSpan span) {
        return this.scopeManager.activateNext(span);
    }

    public TagInterceptor getTagInterceptor() {
        return this.tagInterceptor;
    }

    public int getPartialFlushMinSpans() {
        return this.partialFlushMinSpans;
    }

    @Override
    public AgentSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    @Override
    public AgentScope activeScope() {
        return this.scopeManager.active();
    }

    @Override
    public AgentPropagation propagate() {
        return this.propagation;
    }

    @Override
    public AgentSpan noopSpan() {
        return AgentTracer.NoopAgentSpan.INSTANCE;
    }

    @Override
    public AgentSpan.Context notifyExtensionStart(Object event) {
        return LambdaHandler.notifyStartInvocation(event, this.propagationTagsFactory);
    }

    @Override
    public void notifyExtensionEnd(AgentSpan span, Object result, boolean isError) {
        LambdaHandler.notifyEndInvocation(span, result, isError);
    }

    @Override
    public AgentDataStreamsMonitoring getDataStreamsMonitoring() {
        return this.dataStreamsMonitoring;
    }

    @Override
    public Timer getTimer() {
        return this.timer;
    }

    void write(List<DDSpan> trace) {
        boolean published;
        List<DDSpan> writtenTrace = this.interceptCompleteTrace(trace);
        if (writtenTrace.isEmpty()) {
            return;
        }
        boolean forceKeep = this.metricsAggregator.publish(writtenTrace);
        PendingTrace pendingTrace = writtenTrace.get(0).context().getTrace();
        pendingTrace.setSamplingPriorityIfNecessary();
        DDSpan rootSpan = pendingTrace.getRootSpan();
        DDSpan spanToSample = rootSpan == null ? writtenTrace.get(0) : rootSpan;
        spanToSample.forceKeep(forceKeep);
        boolean bl = published = forceKeep || pendingTrace.sample(spanToSample);
        if (published) {
            this.writer.write(writtenTrace);
        } else {
            this.writer.incrementDropCounts(writtenTrace.size());
        }
        if (null != rootSpan) {
            this.onRootSpanFinished(rootSpan, rootSpan.getEndpointTracker());
            RequestContext requestContext = rootSpan.getRequestContext();
            if (requestContext != null) {
                try {
                    requestContext.close();
                }
                catch (IOException e) {
                    log.warn("Error closing request context data", (Throwable)e);
                }
            }
        }
    }

    private List<DDSpan> interceptCompleteTrace(List<DDSpan> trace) {
        if (!this.interceptors.isEmpty() && !trace.isEmpty()) {
            Collection<DDSpan> interceptedTrace = new ArrayList<DDSpan>(trace);
            for (TraceInterceptor traceInterceptor : this.interceptors) {
                try {
                    interceptedTrace = traceInterceptor.onTraceComplete(interceptedTrace);
                }
                catch (Exception e) {
                    String interceptorName = traceInterceptor.getClass().getName();
                    this.rlLog.warn("Exception in TraceInterceptor {}", interceptorName, e);
                }
            }
            trace = new ArrayList<DDSpan>(interceptedTrace.size());
            for (MutableSpan mutableSpan : interceptedTrace) {
                if (!(mutableSpan instanceof DDSpan)) continue;
                trace.add((DDSpan)mutableSpan);
            }
        }
        return trace;
    }

    public String getTraceId() {
        return this.getTraceId(this.activeSpan());
    }

    public String getSpanId() {
        return this.getSpanId(this.activeSpan());
    }

    @Override
    public String getTraceId(AgentSpan span) {
        if (span != null && span.getTraceId() != null) {
            DDTraceId traceId = span.getTraceId();
            if (this.logs128bTraceIdEnabled && traceId.toHighOrderLong() != 0L) {
                return traceId.toHexString();
            }
            return traceId.toString();
        }
        return "0";
    }

    @Override
    public String getSpanId(AgentSpan span) {
        if (span != null) {
            return DDSpanId.toString((long)span.getSpanId());
        }
        return "0";
    }

    public boolean addTraceInterceptor(TraceInterceptor interceptor) {
        if (this.interceptors.add(interceptor)) {
            return true;
        }
        Comparator<TraceInterceptor> interceptorComparator = this.interceptors.comparator();
        if (interceptorComparator != null) {
            TraceInterceptor anotherInterceptor = this.interceptors.stream().filter(i -> interceptorComparator.compare((TraceInterceptor)i, interceptor) == 0).findFirst().orElse(null);
            log.warn("Interceptor {} will NOT be registered with the tracer, as already registered interceptor {} is considered its duplicate", (Object)interceptor, (Object)anotherInterceptor);
        }
        return false;
    }

    public DataStreamsCheckpointer getDataStreamsCheckpointer() {
        return this.dataStreamsMonitoring;
    }

    @Override
    public void addScopeListener(ScopeListener listener) {
        if (this.scopeManager instanceof ContinuableScopeManager) {
            ((ContinuableScopeManager)this.scopeManager).addScopeListener(listener);
        }
    }

    @Override
    public void registerCheckpointer(EndpointCheckpointer implementation) {
        this.endpointCheckpointer.register(implementation);
    }

    @Override
    public void registerTimer(Timer timer) {
        this.timer = timer;
    }

    @Override
    public SubscriptionService getSubscriptionService(RequestContextSlot slot) {
        return (SubscriptionService)((Object)this.instrumentationGateway.getCallbackProvider(slot));
    }

    @Override
    public CallbackProvider getCallbackProvider(RequestContextSlot slot) {
        if (slot == RequestContextSlot.APPSEC) {
            return this.callbackProviderAppSec;
        }
        if (slot == RequestContextSlot.IAST) {
            return this.callbackProviderIast;
        }
        return CallbackProvider.CallbackProviderNoop.INSTANCE;
    }

    @Override
    public CallbackProvider getUniversalCallbackProvider() {
        return this.universalCallbackProvider;
    }

    @Override
    public void close() {
        this.tracingConfigPoller.stop();
        this.pendingTraceBuffer.close();
        this.writer.close();
        this.statsDClient.close();
        this.metricsAggregator.close();
        this.dataStreamsMonitoring.close();
        this.externalAgentLauncher.close();
        this.tracerFlarePoller.stop();
    }

    public void addScopeListener(final Runnable afterScopeActivatedCallback, final Runnable afterScopeClosedCallback) {
        this.addScopeListener(new ScopeListener(){

            @Override
            public void afterScopeActivated() {
                afterScopeActivatedCallback.run();
            }

            @Override
            public void afterScopeClosed() {
                afterScopeClosedCallback.run();
            }
        });
    }

    public void flush() {
        this.pendingTraceBuffer.flush();
        this.writer.flush();
    }

    public void flushMetrics() {
        try {
            this.metricsAggregator.forceReport().get(2500L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.debug("Failed to wait for metrics flush.", (Throwable)e);
        }
    }

    @Override
    public ProfilingContextIntegration getProfilingContext() {
        return this.profilingContextIntegration;
    }

    public TraceSegment getTraceSegment() {
        AgentSpan activeSpan = this.activeSpan();
        if (activeSpan == null) {
            return null;
        }
        AgentSpan.Context ctx = activeSpan.context();
        if (ctx instanceof DDSpanContext) {
            return ((DDSpanContext)ctx).getTraceSegment();
        }
        return null;
    }

    private static StatsDClient createStatsDClient(Config config) {
        Integer port;
        if (!config.isHealthMetricsEnabled()) {
            return StatsDClient.NO_OP;
        }
        String host = config.getHealthMetricsStatsdHost();
        if (host == null) {
            host = config.getJmxFetchStatsdHost();
        }
        if ((port = config.getHealthMetricsStatsdPort()) == null) {
            port = config.getJmxFetchStatsdPort();
        }
        return DDAgentStatsDClientManager.statsDClientManager().statsDClient(host, port, config.getDogStatsDNamedPipe(), "datadog:tracer".replace(':', '.'), CoreTracer.generateConstantTags(config));
    }

    private static String[] generateConstantTags(Config config) {
        String env;
        ArrayList<String> constantTags = new ArrayList<String>();
        constantTags.add(CoreTracer.statsdTag(LANG_STATSD_TAG, "java"));
        constantTags.add(CoreTracer.statsdTag(LANG_VERSION_STATSD_TAG, DDTraceCoreInfo.JAVA_VERSION));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_NAME));
        constantTags.add(CoreTracer.statsdTag(LANG_INTERPRETER_VENDOR_STATSD_TAG, DDTraceCoreInfo.JAVA_VM_VENDOR));
        constantTags.add(CoreTracer.statsdTag(TRACER_VERSION_STATSD_TAG, DDTraceCoreInfo.VERSION));
        constantTags.add(CoreTracer.statsdTag("service", config.getServiceName()));
        Map<String, String> mergedSpanTags = config.getMergedSpanTags();
        String version = mergedSpanTags.get("version");
        if (version != null && !version.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("version", version));
        }
        if ((env = mergedSpanTags.get("env")) != null && !env.isEmpty()) {
            constantTags.add(CoreTracer.statsdTag("env", env));
        }
        return constantTags.toArray(new String[0]);
    }

    Recording writeTimer() {
        return this.traceWriteTimer.start();
    }

    private static String statsdTag(String tagPrefix, String tagValue) {
        return tagPrefix + ":" + tagValue;
    }

    private static <K, V> Map<V, K> invertMap(Map<K, V> map) {
        HashMap<V, K> inverted = new HashMap<V, K>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            inverted.put(entry.getValue(), entry.getKey());
        }
        return Collections.unmodifiableMap(inverted);
    }

    protected class ConfigSnapshot
    extends DynamicConfig.Snapshot {
        final Sampler sampler;

        protected ConfigSnapshot(DynamicConfig.Builder builder, ConfigSnapshot oldSnapshot) {
            super(builder, oldSnapshot);
            this.sampler = null == oldSnapshot ? CoreTracer.this.initialSampler : (Objects.equals(this.getTraceSampleRate(), oldSnapshot.getTraceSampleRate()) ? oldSnapshot.sampler : Sampler.Builder.forConfig(CoreTracer.this.initialConfig, this));
        }
    }

    private static class ShutdownHook
    extends Thread {
        private final WeakReference<CoreTracer> reference;

        private ShutdownHook(CoreTracer tracer) {
            super(AgentThreadFactory.AGENT_THREAD_GROUP, "dd-tracer-shutdown-hook");
            this.reference = new WeakReference<CoreTracer>(tracer);
        }

        @Override
        public void run() {
            CoreTracer tracer = (CoreTracer)this.reference.get();
            if (tracer != null) {
                tracer.close();
            }
        }
    }

    public class CoreSpanBuilder
    implements AgentTracer.SpanBuilder {
        private final String instrumentationName;
        private final CharSequence operationName;
        private final CoreTracer tracer;
        private Map<String, Object> tags;
        private long timestampMicro;
        private AgentSpan.Context parent;
        private String serviceName;
        private String resourceName;
        private boolean errorFlag;
        private CharSequence spanType;
        private boolean ignoreScope = false;
        private Object builderRequestContextDataAppSec;
        private Object builderRequestContextDataIast;
        private Object builderCiVisibilityContextData;
        private List<AgentSpanLink> links;

        CoreSpanBuilder(String instrumentationName, CharSequence operationName, CoreTracer tracer) {
            this.instrumentationName = instrumentationName;
            this.operationName = operationName;
            this.tracer = tracer;
        }

        @Override
        public CoreSpanBuilder ignoreActiveSpan() {
            this.ignoreScope = true;
            return this;
        }

        private DDSpan buildSpan() {
            this.addTerminatedContextAsLinks();
            DDSpan span = DDSpan.create(this.instrumentationName, this.timestampMicro, this.buildSpanContext(), this.links);
            if (span.isLocalRootSpan()) {
                EndpointTracker tracker = this.tracer.onRootSpanStarted(span);
                span.setEndpointTracker(tracker);
            }
            return span;
        }

        private void addTerminatedContextAsLinks() {
            List<AgentSpanLink> terminatedContextLinks;
            if (this.parent instanceof TagContext && !(terminatedContextLinks = ((TagContext)this.parent).getTerminatedContextLinks()).isEmpty()) {
                if (this.links == null) {
                    this.links = new ArrayList<AgentSpanLink>();
                }
                this.links.addAll(terminatedContextLinks);
            }
        }

        @Override
        public AgentSpan start() {
            return this.buildSpan();
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Number number) {
            return this.withTag(tag, (Object)number);
        }

        @Override
        public CoreSpanBuilder withTag(String tag, String string) {
            return this.withTag(tag, (Object)(string == null || string.isEmpty() ? null : string));
        }

        @Override
        public CoreSpanBuilder withTag(String tag, boolean bool) {
            return this.withTag(tag, (Object)bool);
        }

        @Override
        public CoreSpanBuilder withStartTimestamp(long timestampMicroseconds) {
            this.timestampMicro = timestampMicroseconds;
            return this;
        }

        @Override
        public CoreSpanBuilder withServiceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withResourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        @Override
        public CoreSpanBuilder withErrorFlag() {
            this.errorFlag = true;
            return this;
        }

        @Override
        public CoreSpanBuilder withSpanType(CharSequence spanType) {
            this.spanType = spanType;
            return this;
        }

        @Override
        public CoreSpanBuilder asChildOf(AgentSpan.Context spanContext) {
            this.parent = spanContext;
            return this;
        }

        public CoreSpanBuilder asChildOf(AgentSpan agentSpan) {
            this.parent = agentSpan.context();
            return this;
        }

        @Override
        public CoreSpanBuilder withTag(String tag, Object value) {
            if (tag == null) {
                return this;
            }
            Map<String, Object> tagMap = this.tags;
            if (tagMap == null) {
                this.tags = tagMap = new LinkedHashMap<String, Object>();
            }
            if (value == null) {
                tagMap.remove(tag);
            } else {
                tagMap.put(tag, value);
            }
            return this;
        }

        @Override
        public <T> AgentTracer.SpanBuilder withRequestContextData(RequestContextSlot slot, T data) {
            switch (slot) {
                case APPSEC: {
                    this.builderRequestContextDataAppSec = data;
                    break;
                }
                case CI_VISIBILITY: {
                    this.builderCiVisibilityContextData = data;
                    break;
                }
                case IAST: {
                    this.builderRequestContextDataIast = data;
                }
            }
            return this;
        }

        @Override
        public AgentTracer.SpanBuilder withLink(AgentSpanLink link) {
            if (link != null) {
                if (this.links == null) {
                    this.links = new ArrayList<AgentSpanLink>();
                }
                this.links.add(link);
            }
            return this;
        }

        private DDSpanContext buildSpanContext() {
            PathwayContext pathwayContext;
            PropagationTags propagationTags;
            Object ciVisibilityContextData;
            Object requestContextDataIast;
            Object requestContextDataAppSec;
            Map rootSpanTags;
            Map<String, String> coreTags;
            CharSequence origin;
            int samplingPriority;
            PendingTrace parentTrace;
            Map<String, String> baggage;
            long parentSpanId;
            DDTraceId traceId;
            AgentSpan activeSpan;
            long spanId = CoreTracer.this.idGenerationStrategy.generateSpanId();
            AgentSpan.Context parentContext = this.parent;
            if (parentContext == null && !this.ignoreScope && (activeSpan = CoreTracer.this.scopeManager.activeSpan()) != null) {
                parentContext = activeSpan.context();
            }
            String parentServiceName = null;
            if (parentContext instanceof DDSpanContext) {
                RequestContext requestContext;
                DDSpanContext ddsc = (DDSpanContext)parentContext;
                traceId = ddsc.getTraceId();
                parentSpanId = ddsc.getSpanId();
                baggage = ddsc.getBaggageItems();
                parentTrace = ddsc.getTrace();
                samplingPriority = -128;
                origin = null;
                coreTags = null;
                rootSpanTags = null;
                parentServiceName = ddsc.getServiceName();
                if (this.serviceName == null) {
                    this.serviceName = parentServiceName;
                }
                if ((requestContext = ((DDSpanContext)parentContext).getRequestContext()) != null) {
                    requestContextDataAppSec = requestContext.getData(RequestContextSlot.APPSEC);
                    requestContextDataIast = requestContext.getData(RequestContextSlot.IAST);
                    ciVisibilityContextData = requestContext.getData(RequestContextSlot.CI_VISIBILITY);
                } else {
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                    ciVisibilityContextData = null;
                }
                propagationTags = CoreTracer.this.propagationTagsFactory.empty();
            } else {
                ConfigSnapshot traceConfig;
                long endToEndStartTime;
                if (parentContext instanceof ExtractedContext) {
                    ExtractedContext extractedContext = (ExtractedContext)parentContext;
                    traceId = extractedContext.getTraceId();
                    parentSpanId = extractedContext.getSpanId();
                    samplingPriority = extractedContext.getSamplingPriority();
                    endToEndStartTime = extractedContext.getEndToEndStartTime();
                    propagationTags = extractedContext.getPropagationTags();
                } else if (parentContext != null) {
                    traceId = parentContext.getTraceId() == DDTraceId.ZERO ? CoreTracer.this.idGenerationStrategy.generateTraceId() : parentContext.getTraceId();
                    parentSpanId = parentContext.getSpanId();
                    samplingPriority = parentContext.getSamplingPriority();
                    endToEndStartTime = 0L;
                    propagationTags = CoreTracer.this.propagationTagsFactory.empty();
                } else {
                    traceId = CoreTracer.this.idGenerationStrategy.generateTraceId();
                    parentSpanId = 0L;
                    samplingPriority = -128;
                    endToEndStartTime = 0L;
                    propagationTags = CoreTracer.this.propagationTagsFactory.empty();
                }
                if (parentContext instanceof TagContext) {
                    TagContext tc = (TagContext)parentContext;
                    traceConfig = (ConfigSnapshot)tc.getTraceConfig();
                    coreTags = tc.getTags();
                    origin = tc.getOrigin();
                    baggage = tc.getBaggage();
                    requestContextDataAppSec = tc.getRequestContextDataAppSec();
                    requestContextDataIast = tc.getRequestContextDataIast();
                    ciVisibilityContextData = tc.getCiVisibilityContextData();
                } else {
                    traceConfig = null;
                    coreTags = null;
                    origin = null;
                    baggage = null;
                    requestContextDataAppSec = null;
                    requestContextDataIast = null;
                    ciVisibilityContextData = null;
                }
                rootSpanTags = CoreTracer.this.localRootSpanTags;
                parentTrace = CoreTracer.this.createTrace(traceId, traceConfig);
                if (endToEndStartTime > 0L) {
                    parentTrace.beginEndToEnd(endToEndStartTime);
                }
            }
            PathwayContext pathwayContext2 = pathwayContext = parentContext != null && parentContext.getPathwayContext() != null && parentContext.getPathwayContext().isStarted() ? parentContext.getPathwayContext() : CoreTracer.this.dataStreamsMonitoring.newPathwayContext();
            if (!CoreTracer.this.allowInferredServices) {
                DDSpan rootSpan = parentTrace.getRootSpan();
                String string = this.serviceName = rootSpan != null ? rootSpan.getServiceName() : null;
            }
            if (this.serviceName == null) {
                this.serviceName = CoreTracer.this.serviceName;
            }
            CharSequence operationName = this.operationName != null ? this.operationName : this.resourceName;
            int tagsSize = (null == this.tags ? 0 : this.tags.size()) + CoreTracer.this.defaultSpanTags.size() + (null == coreTags ? 0 : coreTags.size()) + (null == rootSpanTags ? 0 : rootSpanTags.size());
            if (this.builderRequestContextDataAppSec != null) {
                requestContextDataAppSec = this.builderRequestContextDataAppSec;
            }
            if (this.builderCiVisibilityContextData != null) {
                ciVisibilityContextData = this.builderCiVisibilityContextData;
            }
            if (this.builderRequestContextDataIast != null) {
                requestContextDataIast = this.builderRequestContextDataIast;
            }
            DDSpanContext context = new DDSpanContext(traceId, spanId, parentSpanId, parentServiceName, this.serviceName, operationName, this.resourceName, samplingPriority, origin, baggage, this.errorFlag, this.spanType, tagsSize, parentTrace, requestContextDataAppSec, requestContextDataIast, ciVisibilityContextData, pathwayContext, CoreTracer.this.disableSamplingMechanismValidation, propagationTags, CoreTracer.this.profilingContextIntegration, CoreTracer.this.injectBaggageAsTags);
            context.setAllTags(CoreTracer.this.defaultSpanTags);
            context.setAllTags(this.tags);
            context.setAllTags(coreTags);
            context.setAllTags(rootSpanTags);
            return context;
        }
    }

    public static class CoreTracerBuilder {
        private Config config;
        private String serviceName;
        private SharedCommunicationObjects sharedCommunicationObjects;
        private Writer writer;
        private IdGenerationStrategy idGenerationStrategy;
        private Sampler sampler;
        private SingleSpanSampler singleSpanSampler;
        private HttpCodec.Injector injector;
        private HttpCodec.Extractor extractor;
        private AgentScopeManager scopeManager;
        private Map<String, ?> localRootSpanTags;
        private Map<String, ?> defaultSpanTags;
        private Map<String, String> serviceNameMappings;
        private Map<String, String> taggedHeaders;
        private Map<String, String> baggageMapping;
        private int partialFlushMinSpans;
        private StatsDClient statsDClient;
        private TagInterceptor tagInterceptor;
        private boolean strictTraceWrites;
        private InstrumentationGateway instrumentationGateway;
        private TimeSource timeSource;
        private DataStreamsMonitoring dataStreamsMonitoring;
        private ProfilingContextIntegration profilingContextIntegration = ProfilingContextIntegration.NoOp.INSTANCE;
        private boolean pollForTracerFlareRequests;
        private boolean pollForTracingConfiguration;
        private boolean injectBaggageAsTags;

        public CoreTracerBuilder serviceName(String serviceName) {
            this.serviceName = serviceName;
            return this;
        }

        public CoreTracerBuilder sharedCommunicationObjects(SharedCommunicationObjects sharedCommunicationObjects) {
            this.sharedCommunicationObjects = sharedCommunicationObjects;
            return this;
        }

        public CoreTracerBuilder writer(Writer writer) {
            this.writer = writer;
            return this;
        }

        public CoreTracerBuilder idGenerationStrategy(IdGenerationStrategy idGenerationStrategy) {
            this.idGenerationStrategy = idGenerationStrategy;
            return this;
        }

        public CoreTracerBuilder sampler(Sampler sampler) {
            this.sampler = sampler;
            return this;
        }

        public CoreTracerBuilder singleSpanSampler(SingleSpanSampler singleSpanSampler) {
            this.singleSpanSampler = singleSpanSampler;
            return this;
        }

        public CoreTracerBuilder injector(HttpCodec.Injector injector) {
            this.injector = injector;
            return this;
        }

        public CoreTracerBuilder extractor(HttpCodec.Extractor extractor) {
            this.extractor = extractor;
            return this;
        }

        public CoreTracerBuilder scopeManager(AgentScopeManager scopeManager) {
            this.scopeManager = scopeManager;
            return this;
        }

        public CoreTracerBuilder localRootSpanTags(Map<String, ?> localRootSpanTags) {
            this.localRootSpanTags = CollectionUtils.tryMakeImmutableMap(localRootSpanTags);
            return this;
        }

        public CoreTracerBuilder defaultSpanTags(Map<String, ?> defaultSpanTags) {
            this.defaultSpanTags = CollectionUtils.tryMakeImmutableMap(defaultSpanTags);
            return this;
        }

        public CoreTracerBuilder serviceNameMappings(Map<String, String> serviceNameMappings) {
            this.serviceNameMappings = CollectionUtils.tryMakeImmutableMap(serviceNameMappings);
            return this;
        }

        public CoreTracerBuilder taggedHeaders(Map<String, String> taggedHeaders) {
            this.taggedHeaders = CollectionUtils.tryMakeImmutableMap(taggedHeaders);
            return this;
        }

        public CoreTracerBuilder baggageMapping(Map<String, String> baggageMapping) {
            this.baggageMapping = CollectionUtils.tryMakeImmutableMap(baggageMapping);
            return this;
        }

        public CoreTracerBuilder partialFlushMinSpans(int partialFlushMinSpans) {
            this.partialFlushMinSpans = partialFlushMinSpans;
            return this;
        }

        public CoreTracerBuilder statsDClient(StatsDClient statsDClient) {
            this.statsDClient = statsDClient;
            return this;
        }

        public CoreTracerBuilder tagInterceptor(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder statsDClient(TagInterceptor tagInterceptor) {
            this.tagInterceptor = tagInterceptor;
            return this;
        }

        public CoreTracerBuilder strictTraceWrites(boolean strictTraceWrites) {
            this.strictTraceWrites = strictTraceWrites;
            return this;
        }

        public CoreTracerBuilder instrumentationGateway(InstrumentationGateway instrumentationGateway) {
            this.instrumentationGateway = instrumentationGateway;
            return this;
        }

        public CoreTracerBuilder timeSource(TimeSource timeSource) {
            this.timeSource = timeSource;
            return this;
        }

        public CoreTracerBuilder dataStreamsMonitoring(DataStreamsMonitoring dataStreamsMonitoring) {
            this.dataStreamsMonitoring = dataStreamsMonitoring;
            return this;
        }

        public CoreTracerBuilder profilingContextIntegration(ProfilingContextIntegration profilingContextIntegration) {
            this.profilingContextIntegration = profilingContextIntegration;
            return this;
        }

        public CoreTracerBuilder pollForTracerFlareRequests() {
            this.pollForTracerFlareRequests = true;
            return this;
        }

        public CoreTracerBuilder pollForTracingConfiguration() {
            this.pollForTracingConfiguration = true;
            return this;
        }

        public CoreTracerBuilder injectBaggageAsTags(boolean injectBaggageAsTags) {
            this.injectBaggageAsTags = injectBaggageAsTags;
            return this;
        }

        public CoreTracerBuilder() {
            this.config(Config.get());
        }

        public CoreTracerBuilder withProperties(Properties properties) {
            return this.config(Config.get(properties));
        }

        public CoreTracerBuilder config(Config config) {
            this.config = config;
            this.serviceName(config.getServiceName());
            this.sampler(Sampler.Builder.forConfig(config, null));
            this.singleSpanSampler(SingleSpanSampler.Builder.forConfig(config));
            this.instrumentationGateway(new InstrumentationGateway());
            this.injector(HttpCodec.createInjector(config, config.getTracePropagationStylesToInject(), CoreTracer.invertMap(config.getBaggageMapping())));
            this.localRootSpanTags(config.getLocalRootSpanTags());
            this.defaultSpanTags(config.getMergedSpanTags());
            this.serviceNameMappings(config.getServiceMapping());
            this.taggedHeaders(config.getRequestHeaderTags());
            this.baggageMapping(config.getBaggageMapping());
            this.partialFlushMinSpans(config.getPartialFlushMinSpans());
            this.strictTraceWrites(config.isTraceStrictWritesEnabled());
            this.injectBaggageAsTags(config.isInjectBaggageAsTagsEnabled());
            return this;
        }

        public CoreTracer build() {
            return new CoreTracer(this.config, this.serviceName, this.sharedCommunicationObjects, this.writer, this.idGenerationStrategy, this.sampler, this.singleSpanSampler, this.injector, this.extractor, this.scopeManager, this.localRootSpanTags, this.defaultSpanTags, this.serviceNameMappings, this.taggedHeaders, this.baggageMapping, this.partialFlushMinSpans, this.statsDClient, this.tagInterceptor, this.strictTraceWrites, this.instrumentationGateway, this.timeSource, this.dataStreamsMonitoring, this.profilingContextIntegration, this.pollForTracerFlareRequests, this.pollForTracingConfiguration, this.injectBaggageAsTags);
        }
    }
}

