/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import datadog.trace.api.sampling.SamplingRule;
import ddtrot.com.squareup.moshi.FromJson;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TraceSamplingRules {
    public static final TraceSamplingRules EMPTY = new TraceSamplingRules(Collections.emptyList());
    private static final Logger log = LoggerFactory.getLogger(TraceSamplingRules.class);
    private static final Moshi MOSHI = new Moshi.Builder().add(new RuleAdapter()).build();
    private static final ParameterizedType LIST_OF_RULES = Types.newParameterizedType(List.class, new Type[]{Rule.class});
    private static final JsonAdapter<List<Rule>> LIST_OF_RULES_ADAPTER = MOSHI.adapter(LIST_OF_RULES);
    private final List<Rule> rules;

    public TraceSamplingRules(List<Rule> rules) {
        this.rules = Collections.unmodifiableList(rules);
    }

    public static TraceSamplingRules deserialize(String json) {
        TraceSamplingRules result = EMPTY;
        try {
            result = TraceSamplingRules.filterOutNullRules(LIST_OF_RULES_ADAPTER.fromJson(json));
        }
        catch (Throwable ex) {
            log.error("Couldn't parse Trace Sampling Rules from JSON: {}", (Object)json, (Object)ex);
        }
        return result;
    }

    private static TraceSamplingRules filterOutNullRules(List<Rule> rules) {
        if (rules == null || rules.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Rule> notNullRules = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule == null) continue;
            notNullRules.add(rule);
        }
        if (notNullRules.isEmpty()) {
            return EMPTY;
        }
        return new TraceSamplingRules(notNullRules);
    }

    public List<Rule> getRules() {
        return this.rules;
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    static /* synthetic */ Moshi access$200() {
        return MOSHI;
    }

    private static final class RuleAdapter {
        private RuleAdapter() {
        }

        @FromJson
        Rule fromJson(JsonRule jsonRule) {
            return Rule.create(jsonRule);
        }
    }

    private static final class JsonRule {
        private static final JsonAdapter<JsonRule> jsonAdapter = TraceSamplingRules.access$200().adapter(JsonRule.class);
        String service;
        String name;
        String resource;
        Map<String, String> tags;
        String target_span;
        String sample_rate;

        private JsonRule() {
        }

        public String toString() {
            return jsonAdapter.toJson(this);
        }
    }

    public static final class Rule
    implements SamplingRule.TraceSamplingRule {
        private final String service;
        private final String name;
        private final String resource;
        private final Map<String, String> tags;
        private final double sampleRate;

        private Rule(String service, String name, String resource, Map<String, String> tags, double sampleRate) {
            this.service = service;
            this.name = name;
            this.resource = resource;
            this.tags = tags;
            this.sampleRate = sampleRate;
        }

        public static Rule create(JsonRule jsonRule) {
            String service = SamplingRule.normalizeGlob(jsonRule.service);
            String name = SamplingRule.normalizeGlob(jsonRule.name);
            String resource = SamplingRule.normalizeGlob(jsonRule.resource);
            Map<String, String> tags = jsonRule.tags;
            if (tags == null) {
                tags = Collections.emptyMap();
            }
            double sampleRate = 1.0;
            if (jsonRule.sample_rate != null) {
                try {
                    sampleRate = Double.parseDouble(jsonRule.sample_rate);
                }
                catch (NumberFormatException ex) {
                    Rule.logRuleError(jsonRule, "sample_rate must be a number between 0.0 and 1.0");
                    return null;
                }
                if (sampleRate < 0.0 || sampleRate > 1.0) {
                    Rule.logRuleError(jsonRule, "sample_rate must be between 0.0 and 1.0");
                    return null;
                }
            }
            return new Rule(service, name, resource, tags, sampleRate);
        }

        private static void logRuleError(JsonRule rule, String error) {
            log.error("Skipping invalid Trace Sampling Rule: {} - {}", (Object)rule, (Object)error);
        }

        @Override
        public String getService() {
            return this.service;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getResource() {
            return this.resource;
        }

        @Override
        public Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public double getSampleRate() {
            return this.sampleRate;
        }
    }
}

