/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import ddtrot.com.timgroup.statsd.ClientChannel;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.DatagramChannel;

class DatagramClientChannel
implements ClientChannel {
    protected final DatagramChannel delegate;
    private final SocketAddress address;

    DatagramClientChannel(SocketAddress address) throws IOException {
        this(DatagramChannel.open(), address);
    }

    DatagramClientChannel(DatagramChannel delegate, SocketAddress address) {
        this.delegate = delegate;
        this.address = address;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        return this.delegate.send(src, this.address);
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public String getTransportType() {
        return "udp";
    }

    public String toString() {
        return "[" + this.getTransportType() + "] " + this.address;
    }
}

