/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast.telemetry;

import datadog.trace.api.Config;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.iast.telemetry.IastMetric;
import ddtrot.dd.trace.api.iast.telemetry.Verbosity;
import ddtrot.dd.trace.api.telemetry.MetricCollector;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.atomic.AtomicLongArray;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IastMetricCollector
implements MetricCollector<IastMetricData> {
    private static final Logger LOGGER = LoggerFactory.getLogger(IastMetricCollector.class);
    private static final String NAMESPACE = "iast";
    private static final Verbosity VERBOSITY = Config.get().getIastTelemetryVerbosity();
    private static final IastMetricCollector INSTANCE = VERBOSITY != Verbosity.OFF ? new IastMetricCollector() : new NoOpInstance();
    private final BlockingQueue<IastMetricData> rawMetricsQueue;
    private final AtomicLongArray counters;

    public static IastMetricCollector get() {
        return INSTANCE;
    }

    private static IastMetricCollector get(@Nullable Object ctx) {
        IastMetricCollector collector;
        if (VERBOSITY == Verbosity.OFF) {
            return INSTANCE;
        }
        if (ctx == null) {
            ctx = IastMetricCollector.activeRequestContext();
        }
        if (ctx instanceof RequestContext) {
            ctx = ((RequestContext)ctx).getData(RequestContextSlot.IAST);
        }
        if (ctx instanceof HasMetricCollector && (collector = ((HasMetricCollector)ctx).getMetricCollector()) != null) {
            return collector;
        }
        return INSTANCE;
    }

    public IastMetricCollector() {
        this(new ArrayBlockingQueue<IastMetricData>(1024), new AtomicLongArray(IastMetric.count()));
    }

    protected IastMetricCollector(BlockingQueue<IastMetricData> rawMetricsQueue, AtomicLongArray counters) {
        this.rawMetricsQueue = rawMetricsQueue;
        this.counters = counters;
    }

    public static void add(@Nonnull IastMetric metric, int value) {
        IastMetricCollector.add(metric, value, null);
    }

    public static void add(@Nonnull IastMetric metric, int value, @Nullable Object ctx) {
        IastMetricCollector.add(metric, (byte)-1, value, ctx);
    }

    public static void add(@Nonnull IastMetric metric, byte tagValue, int value) {
        IastMetricCollector.add(metric, tagValue, value, null);
    }

    public static void add(@Nonnull IastMetric metric, byte tagValue, int value, @Nullable Object ctx) {
        try {
            IastMetricCollector instance = metric.getScope() == IastMetric.Scope.REQUEST ? IastMetricCollector.get(ctx) : INSTANCE;
            instance.addMetric(metric, tagValue, value);
        }
        catch (Throwable e) {
            LOGGER.warn("Failed to add metric {} with tag {}", new Object[]{metric, tagValue, e});
        }
    }

    public void addMetric(IastMetric metric, byte tagValue, int value) {
        IastMetric.Tag tag = metric.getTag();
        if (tag != null && tag.isWrapped(tagValue)) {
            for (byte unwrapped : metric.getTag().unwrap(tagValue)) {
                this.increment(metric.getIndex(unwrapped), value);
            }
        } else {
            this.increment(metric.getIndex(tagValue), value);
        }
    }

    private void increment(int index, int value) {
        if (index >= 0) {
            this.counters.getAndAdd(index, value);
        }
    }

    public void merge(Collection<IastMetricData> metrics) {
        for (IastMetricData data : metrics) {
            IastMetric metric = data.metric;
            byte tagValue = data.tagValue;
            long value = data.value.longValue();
            this.counters.getAndAdd(metric.getIndex(tagValue), value);
        }
    }

    @Override
    public void prepareMetrics() {
        for (IastMetric metric : IastMetric.values()) {
            if (metric.getTag() == null) {
                this.prepareMetric(metric, (byte)-1);
                continue;
            }
            for (byte tagValue : metric.getTag().getValues()) {
                this.prepareMetric(metric, tagValue);
            }
        }
    }

    private void prepareMetric(IastMetric metric, byte tagValue) {
        int index = metric.getIndex(tagValue);
        long value = this.counters.getAndSet(index, 0L);
        if (value > 0L) {
            this.rawMetricsQueue.offer(new IastMetricData(metric, tagValue, value));
        }
    }

    @Override
    public Collection<IastMetricData> drain() {
        LinkedList<IastMetricData> list;
        int drained;
        if (!this.rawMetricsQueue.isEmpty() && (drained = this.rawMetricsQueue.drainTo(list = new LinkedList<IastMetricData>())) > 0) {
            return list;
        }
        return Collections.emptyList();
    }

    private static RequestContext activeRequestContext() {
        AgentSpan span = AgentTracer.activeSpan();
        return span == null ? null : span.getRequestContext();
    }

    public static interface HasMetricCollector {
        public IastMetricCollector getMetricCollector();
    }

    private static class NoOpInstance
    extends IastMetricCollector {
        public NoOpInstance() {
            super(null, null);
        }

        @Override
        public void addMetric(IastMetric metric, byte tagValue, int value) {
        }

        @Override
        public void merge(Collection<IastMetricData> metrics) {
        }

        @Override
        public void prepareMetrics() {
        }

        @Override
        public Collection<IastMetricData> drain() {
            return Collections.emptyList();
        }
    }

    public static class IastMetricData
    extends MetricCollector.Metric {
        private final IastMetric metric;
        private final byte tagValue;

        public IastMetricData(IastMetric metric, byte tagValue, long value) {
            super(IastMetricCollector.NAMESPACE, metric.isCommon(), metric.getName(), "count", (Number)value, IastMetricData.computeTag(metric, tagValue));
            this.metric = metric;
            this.tagValue = tagValue;
        }

        public IastMetric getMetric() {
            return this.metric;
        }

        public byte getTagValue() {
            return this.tagValue;
        }

        public String getSpanTag() {
            if (this.metric.getTag() == null) {
                return this.metric.getName();
            }
            String tag = this.metric.getTag().toString(this.tagValue);
            String spanTag = tag.toLowerCase(Locale.ROOT).replace('.', '_');
            return this.metric.getName() + "." + spanTag;
        }

        public static String computeTag(IastMetric metric, byte tagValue) {
            if (metric.getTag() == null) {
                return null;
            }
            return metric.getTag().getName() + ":" + metric.getTag().toString(tagValue);
        }
    }
}

