/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.cache;

import ddtrot.dd.trace.api.cache.DDCache;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;

final class CHMCache<K, V>
implements DDCache<K, V> {
    private final ConcurrentHashMap<K, V> chm;

    public CHMCache(int initialCapacity) {
        this.chm = new ConcurrentHashMap(initialCapacity);
    }

    @Override
    public V computeIfAbsent(K key, Function<K, ? extends V> producer) {
        V winner;
        if (null == key) {
            return null;
        }
        V value = this.chm.get(key);
        if (null == value && null != (winner = this.chm.putIfAbsent(key, value = producer.apply(key)))) {
            value = winner;
        }
        return value;
    }

    @Override
    public void clear() {
        this.chm.clear();
    }

    @Override
    public void visit(BiConsumer<K, V> consumer) {
        for (Map.Entry<K, V> e : this.chm.entrySet()) {
            consumer.accept(e.getKey(), e.getValue());
        }
    }
}

