/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.naming.v1;

import ddtrot.dd.trace.api.naming.NamingSchema;
import ddtrot.dd.trace.api.naming.SpanNaming;
import ddtrot.dd.trace.util.Strings;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CloudNamingV1
implements NamingSchema.ForCloud {
    @Override
    @Nonnull
    public String operationForRequest(@Nonnull String provider, @Nonnull String cloudService, @Nonnull String qualifiedOperation) {
        switch (qualifiedOperation) {
            case "SQS.SendMessage": 
            case "SQS.SendMessageBatch": 
            case "Sqs.SendMessage": 
            case "Sqs.SendMessageBatch": {
                return SpanNaming.instance().namingSchema().messaging().outboundOperation("sqs");
            }
            case "Sqs.ReceiveMessage": 
            case "SQS.ReceiveMessage": {
                return SpanNaming.instance().namingSchema().messaging().inboundOperation("sqs");
            }
            case "Sns.Publish": 
            case "SNS.Publish": {
                return SpanNaming.instance().namingSchema().messaging().outboundOperation("sns");
            }
        }
        String lowercaseService = cloudService.toLowerCase(Locale.ROOT);
        return Strings.join((CharSequence)".", provider, lowercaseService, "request");
    }

    @Override
    public String serviceForRequest(@Nonnull String provider, @Nullable String cloudService) {
        return null;
    }

    @Override
    @Nonnull
    public String operationForFaas(@Nonnull String provider) {
        return "aws.lambda.invoke";
    }
}

