/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.util.GlobPattern;
import ddtrot.dd.trace.core.util.Matcher;
import ddtrot.dd.trace.core.util.Matchers;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TagsMatcher {
    private final Map<String, Matcher> matchers;

    public static TagsMatcher create(Map<String, String> tags) {
        Map<String, Matcher> matchers = tags.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            String tagValue = (String)entry.getValue();
            if (Matchers.isExact(tagValue)) {
                return new Matchers.ExactMatcher(tagValue);
            }
            Pattern pattern = GlobPattern.globToRegexPattern(tagValue);
            return new Matchers.PatternMatcher(pattern);
        }));
        return new TagsMatcher(matchers);
    }

    public TagsMatcher(Map<String, Matcher> matchers) {
        this.matchers = matchers;
    }

    public <T extends CoreSpan<T>> boolean matches(T span) {
        return this.matchers.entrySet().stream().allMatch(entry -> {
            String tagValue = (String)span.getTag((CharSequence)entry.getKey());
            return tagValue != null && ((Matcher)entry.getValue()).matches(tagValue);
        });
    }
}

