/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.debugger;

import datadog.trace.api.Config;
import ddtrot.dd.trace.bootstrap.debugger.CapturedContext;
import ddtrot.dd.trace.bootstrap.debugger.DebuggerSpan;
import ddtrot.dd.trace.bootstrap.debugger.MethodLocation;
import ddtrot.dd.trace.bootstrap.debugger.ProbeImplementation;
import ddtrot.dd.trace.bootstrap.debugger.util.TimeoutChecker;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DebuggerContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(DebuggerContext.class);
    private static final ThreadLocal<Boolean> IN_PROBE = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static volatile ProbeResolver probeResolver;
    private static volatile ClassFilter classFilter;
    private static volatile MetricForwarder metricForwarder;
    private static volatile Tracer tracer;
    private static volatile ValueSerializer valueSerializer;
    private static volatile ExceptionDebugger exceptionDebugger;

    public static void initProbeResolver(ProbeResolver probeResolver) {
        DebuggerContext.probeResolver = probeResolver;
    }

    public static void initMetricForwarder(MetricForwarder metricForwarder) {
        DebuggerContext.metricForwarder = metricForwarder;
    }

    public static void initTracer(Tracer tracer) {
        DebuggerContext.tracer = tracer;
    }

    public static void initClassFilter(ClassFilter classFilter) {
        DebuggerContext.classFilter = classFilter;
    }

    public static void initValueSerializer(ValueSerializer valueSerializer) {
        DebuggerContext.valueSerializer = valueSerializer;
    }

    public static void initExceptionDebugger(ExceptionDebugger exceptionDebugger) {
        DebuggerContext.exceptionDebugger = exceptionDebugger;
    }

    public static ProbeImplementation resolveProbe(String id) {
        ProbeResolver resolver = probeResolver;
        if (resolver == null) {
            return null;
        }
        return resolver.resolve(id);
    }

    public static boolean isDenied(String fullyQualifiedClassName) {
        ClassFilter filter = classFilter;
        if (filter == null) {
            LOGGER.warn("no class filter => all classes are denied");
            return true;
        }
        return filter.isDenied(fullyQualifiedClassName);
    }

    public static void metric(String probeId, MetricKind kind, String name, long value, String[] tags) {
        try {
            MetricForwarder forwarder = metricForwarder;
            if (forwarder == null) {
                return;
            }
            switch (kind) {
                case COUNT: {
                    forwarder.count(probeId, name, value, tags);
                    break;
                }
                case GAUGE: {
                    forwarder.gauge(probeId, name, value, tags);
                    break;
                }
                case HISTOGRAM: {
                    forwarder.histogram(probeId, name, value, tags);
                    break;
                }
                case DISTRIBUTION: {
                    forwarder.distribution(probeId, name, value, tags);
                }
                default: {
                    throw new IllegalArgumentException("Unsupported metric kind: " + (Object)((Object)kind));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in metric method: ", (Throwable)ex);
        }
    }

    public static void metric(String probeId, MetricKind kind, String name, double value, String[] tags) {
        try {
            MetricForwarder forwarder = metricForwarder;
            if (forwarder == null) {
                return;
            }
            switch (kind) {
                case GAUGE: {
                    forwarder.gauge(probeId, name, value, tags);
                    break;
                }
                case HISTOGRAM: {
                    forwarder.histogram(probeId, name, value, tags);
                    break;
                }
                case DISTRIBUTION: {
                    forwarder.distribution(probeId, name, value, tags);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported metric kind: " + (Object)((Object)kind));
                }
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in metric method: ", (Throwable)ex);
        }
    }

    public static String serializeValue(CapturedContext.CapturedValue value) {
        ValueSerializer serializer = valueSerializer;
        if (serializer == null) {
            LOGGER.warn("Cannot serialize value, no serializer set");
            return null;
        }
        return serializer.serializeValue(value);
    }

    public static DebuggerSpan createSpan(String probeId, String operationName, String[] tags) {
        try {
            Tracer localTracer = tracer;
            if (localTracer == null) {
                return DebuggerSpan.NOOP_SPAN;
            }
            return localTracer.createSpan(probeId, operationName, tags);
        }
        catch (Exception ex) {
            LOGGER.debug("Error in createSpan: ", (Throwable)ex);
            return DebuggerSpan.NOOP_SPAN;
        }
    }

    public static boolean isReadyToCapture(Class<?> callingClass, String ... encodedProbeIds) {
        try {
            return DebuggerContext.checkAndSetInProbe();
        }
        catch (Exception ex) {
            LOGGER.debug("Error in isReadyToCapture: ", (Throwable)ex);
            return false;
        }
    }

    public static void disableInProbe() {
        IN_PROBE.set(Boolean.FALSE);
    }

    public static boolean isInProbe() {
        return IN_PROBE.get();
    }

    public static boolean checkAndSetInProbe() {
        if (IN_PROBE.get().booleanValue()) {
            LOGGER.debug("Instrumentation is reentered, skip it.");
            return false;
        }
        IN_PROBE.set(Boolean.TRUE);
        return true;
    }

    public static void evalContext(CapturedContext context, Class<?> callingClass, long startTimestamp, MethodLocation methodLocation, String ... encodedProbeIds) {
        try {
            boolean needFreeze = false;
            for (String encodedProbeId : encodedProbeIds) {
                ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(encodedProbeId);
                if (probeImplementation == null) continue;
                CapturedContext.Status status = context.evaluate(encodedProbeId, probeImplementation, callingClass.getTypeName(), startTimestamp, methodLocation);
                needFreeze |= status.shouldFreezeContext();
            }
            if (needFreeze) {
                Duration timeout = Duration.of(Config.get().getDebuggerCaptureTimeout(), ChronoUnit.MILLIS);
                context.freeze(new TimeoutChecker(timeout));
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContext: ", (Throwable)ex);
        }
    }

    public static void evalContextAndCommit(CapturedContext context, Class<?> callingClass, int line, String ... encodedProbeIds) {
        try {
            ArrayList<ProbeImplementation> probeImplementations = new ArrayList<ProbeImplementation>();
            for (String encodedProbeId : encodedProbeIds) {
                ProbeImplementation probeImplementation = DebuggerContext.resolveProbe(encodedProbeId);
                if (probeImplementation == null) continue;
                context.evaluate(encodedProbeId, probeImplementation, callingClass.getTypeName(), -1L, MethodLocation.DEFAULT);
                probeImplementations.add(probeImplementation);
            }
            for (ProbeImplementation probeImplementation : probeImplementations) {
                probeImplementation.commit(context, line);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in evalContextAndCommit: ", (Throwable)ex);
        }
    }

    public static void commit(CapturedContext entryContext, CapturedContext exitContext, List<CapturedContext.CapturedThrowable> caughtExceptions, String ... encodedProbeIds) {
        try {
            if (entryContext == CapturedContext.EMPTY_CONTEXT && exitContext == CapturedContext.EMPTY_CONTEXT) {
                return;
            }
            for (String encodedProbeId : encodedProbeIds) {
                ProbeImplementation probeImplementation;
                CapturedContext.Status entryStatus = entryContext.getStatus(encodedProbeId);
                CapturedContext.Status exitStatus = exitContext.getStatus(encodedProbeId);
                if (entryStatus.probeImplementation != ProbeImplementation.UNKNOWN && (entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.ENTRY || entryStatus.probeImplementation.getEvaluateAt() == MethodLocation.DEFAULT)) {
                    probeImplementation = entryStatus.probeImplementation;
                } else if (exitStatus.probeImplementation.getEvaluateAt() == MethodLocation.EXIT) {
                    probeImplementation = exitStatus.probeImplementation;
                } else {
                    throw new IllegalStateException("no probe details");
                }
                probeImplementation.commit(entryContext, exitContext, caughtExceptions);
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Error in commit: ", (Throwable)ex);
        }
    }

    public static void handleException(Throwable t) {
        ExceptionDebugger exDebugger = exceptionDebugger;
        if (exDebugger == null) {
            return;
        }
        exDebugger.handleException(t);
    }

    public static interface ExceptionDebugger {
        public void handleException(Throwable var1);
    }

    public static interface ValueSerializer {
        public String serializeValue(CapturedContext.CapturedValue var1);
    }

    public static interface Tracer {
        public DebuggerSpan createSpan(String var1, String var2, String[] var3);
    }

    public static interface MetricForwarder {
        public void count(String var1, String var2, long var3, String[] var5);

        public void gauge(String var1, String var2, long var3, String[] var5);

        public void gauge(String var1, String var2, double var3, String[] var5);

        public void histogram(String var1, String var2, long var3, String[] var5);

        public void histogram(String var1, String var2, double var3, String[] var5);

        public void distribution(String var1, String var2, long var3, String[] var5);

        public void distribution(String var1, String var2, double var3, String[] var5);
    }

    public static enum MetricKind {
        COUNT,
        GAUGE,
        HISTOGRAM,
        DISTRIBUTION;

    }

    public static interface ClassFilter {
        public boolean isDenied(String var1);
    }

    public static interface ProbeResolver {
        public ProbeImplementation resolve(String var1);
    }

    public static enum SkipCause {
        RATE,
        CONDITION;

    }
}

