/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.util;

import ddtrot.dd.trace.core.util.BaseMatcher;
import ddtrot.dd.trace.core.util.GlobPattern;
import ddtrot.dd.trace.core.util.Matcher;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.regex.Pattern;

public final class Matchers {
    public static final Matcher ANY = new AnyMatcher();

    private Matchers() {
    }

    public static Matcher compileGlob(String glob) {
        if (glob == null || Matchers.isAny(glob)) {
            return ANY;
        }
        if (Matchers.isExact(glob)) {
            return new ExactMatcher(glob);
        }
        Pattern pattern = GlobPattern.globToRegexPattern(glob);
        return new PatternMatcher(pattern);
    }

    public static boolean matches(Matcher matcher, String str) {
        return matcher == null || matcher.matches(str);
    }

    public static boolean matches(Matcher matcher, CharSequence charSeq) {
        return matcher == null || matcher.matches(charSeq);
    }

    static final boolean isAny(String glob) {
        if ("*".equals(glob)) {
            return true;
        }
        if (glob.length() == 0) {
            return false;
        }
        for (int i = 0; i < glob.length(); ++i) {
            if (glob.charAt(i) == '*') continue;
            return false;
        }
        return true;
    }

    static boolean isExact(String glob) {
        return glob.indexOf(42) == -1 && glob.indexOf(63) == -1;
    }

    static final class PatternMatcher
    extends BaseMatcher {
        private final Pattern pattern;

        PatternMatcher(Pattern pattern) {
            this.pattern = pattern;
        }

        @Override
        public boolean matches(CharSequence charSeq) {
            return this.pattern.matcher(charSeq).matches();
        }

        @Override
        public boolean matches(String str) {
            return this.pattern.matcher(str).matches();
        }
    }

    static final class ExactMatcher
    extends BaseMatcher {
        private final String exact;

        ExactMatcher(String exact) {
            this.exact = exact;
        }

        @Override
        public boolean matches(String str) {
            return this.exact.equals(str);
        }

        @Override
        public boolean matches(CharSequence charSeq) {
            return this.exact.contentEquals(charSeq);
        }
    }

    static final class AnyMatcher
    implements Matcher {
        AnyMatcher() {
        }

        @Override
        public boolean matches(CharSequence charSeq) {
            return true;
        }

        @Override
        public boolean matches(String str) {
            return true;
        }

        @Override
        public boolean matches(Object value) {
            return true;
        }

        @Override
        public boolean matches(boolean value) {
            return true;
        }

        @Override
        public boolean matches(byte value) {
            return true;
        }

        @Override
        public boolean matches(short value) {
            return true;
        }

        @Override
        public boolean matches(int value) {
            return true;
        }

        @Override
        public boolean matches(long value) {
            return true;
        }

        @Override
        public boolean matches(BigInteger value) {
            return true;
        }

        @Override
        public boolean matches(double value) {
            return true;
        }

        @Override
        public boolean matches(float value) {
            return true;
        }

        @Override
        public boolean matches(BigDecimal value) {
            return true;
        }
    }
}

