/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.EndpointCheckpointer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EndpointCheckpointerHolder
implements EndpointCheckpointer {
    private static final Logger log = LoggerFactory.getLogger(EndpointCheckpointerHolder.class);
    private static final AtomicReferenceFieldUpdater<EndpointCheckpointerHolder, EndpointCheckpointer> ROOT_SPAN_CHECKPOINTER = AtomicReferenceFieldUpdater.newUpdater(EndpointCheckpointerHolder.class, EndpointCheckpointer.class, "endpointCheckpointer");
    private volatile EndpointCheckpointer endpointCheckpointer;

    public static EndpointCheckpointerHolder create() {
        return new EndpointCheckpointerHolder(NoOpCheckpointer.NO_OP);
    }

    public EndpointCheckpointerHolder(EndpointCheckpointer endpointCheckpointer) {
        this.endpointCheckpointer = endpointCheckpointer;
    }

    public void register(EndpointCheckpointer endpointCheckpointer) {
        if (!ROOT_SPAN_CHECKPOINTER.compareAndSet(this, NoOpCheckpointer.NO_OP, endpointCheckpointer)) {
            log.debug("failed to register root span checkpointer {} - {} already registered", endpointCheckpointer.getClass(), this.endpointCheckpointer.getClass());
        } else {
            log.debug("Registered root span checkpointer implementation: {}", (Object)endpointCheckpointer);
        }
    }

    @Override
    public void onRootSpanFinished(AgentSpan rootSpan, boolean published) {
        this.endpointCheckpointer.onRootSpanFinished(rootSpan, published);
    }

    @Override
    public void onRootSpanStarted(AgentSpan root) {
        this.endpointCheckpointer.onRootSpanStarted(root);
    }

    private static final class NoOpCheckpointer
    implements EndpointCheckpointer {
        static final NoOpCheckpointer NO_OP = new NoOpCheckpointer();

        private NoOpCheckpointer() {
        }

        @Override
        public void onRootSpanFinished(AgentSpan rootSpan, boolean published) {
        }

        @Override
        public void onRootSpanStarted(AgentSpan rootSpan) {
        }
    }
}

