/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci.git;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GitConfig {
    private final Pattern section = Pattern.compile("\\s*\\[([^]]*)\\]\\s*");
    private final Pattern keyValue = Pattern.compile("\\s*([^=]*)=(.*)");
    private final Map<String, Map<String, String>> entries = new HashMap<String, Map<String, String>>();

    public GitConfig(String path) {
        this.load(path);
    }

    private void load(String path) {
        if (path == null || path.isEmpty()) {
            return;
        }
        try (BufferedReader br = new BufferedReader(new FileReader(path));){
            String line;
            String section = null;
            while ((line = br.readLine()) != null) {
                Matcher m = this.section.matcher(line);
                if (m.matches()) {
                    section = m.group(1).trim();
                    continue;
                }
                if (section == null) continue;
                Map<String, String> kv = this.entries.get(section);
                if (kv == null) {
                    kv = new HashMap<String, String>();
                    this.entries.put(section, kv);
                }
                if (!(m = this.keyValue.matcher(line)).matches()) continue;
                String key = m.group(1).trim();
                String value = m.group(2).trim();
                kv.put(key, value);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String getString(String section, String key) {
        Map<String, String> kv = this.entries.get(section);
        if (kv == null) {
            return null;
        }
        return kv.get(key);
    }
}

