/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.sampling;

import ddtrot.com.squareup.moshi.FromJson;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.JsonReader;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.com.squareup.moshi.Types;
import ddtrot.okio.Okio;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpanSamplingRules {
    private static final Logger log = LoggerFactory.getLogger(SpanSamplingRules.class);
    private static final Moshi MOSHI = new Moshi.Builder().add(new RuleAdapter()).build();
    private static final ParameterizedType LIST_OF_RULES = Types.newParameterizedType(List.class, new Type[]{Rule.class});
    private static final JsonAdapter<List<Rule>> LIST_OF_RULES_ADAPTER = MOSHI.adapter(LIST_OF_RULES);
    private final List<Rule> rules;

    public static SpanSamplingRules deserialize(String json) {
        try {
            List<Rule> rules = LIST_OF_RULES_ADAPTER.fromJson(json);
            return SpanSamplingRules.filterOutNullRules(rules);
        }
        catch (Throwable ex) {
            log.error("Couldn't parse Span Sampling Rules from JSON", ex);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static SpanSamplingRules deserializeFile(String jsonFile) {
        try (JsonReader reader = JsonReader.of(Okio.buffer(Okio.source(new File(jsonFile))));){
            List<Rule> rules = LIST_OF_RULES_ADAPTER.fromJson(reader);
            SpanSamplingRules spanSamplingRules = SpanSamplingRules.filterOutNullRules(rules);
            return spanSamplingRules;
        }
        catch (FileNotFoundException e) {
            log.warn("Span sampling rules file {} doesn't exit", (Object)jsonFile);
            return null;
        }
        catch (IOException e) {
            log.error("Couldn't read Span sampling rules file {}. Failed with {}", (Object)jsonFile, (Object)e);
            return null;
        }
        catch (Throwable ex) {
            log.error("Couldn't parse Span Sampling Rules from JSON file {}. Failed with {}", (Object)jsonFile, (Object)ex);
        }
        return null;
    }

    private static SpanSamplingRules filterOutNullRules(List<Rule> rules) {
        if (rules == null) {
            return null;
        }
        ArrayList<Rule> notNullRules = new ArrayList<Rule>(rules.size());
        for (Rule rule : rules) {
            if (rule == null) continue;
            notNullRules.add(rule);
        }
        if (notNullRules.isEmpty()) {
            return null;
        }
        return new SpanSamplingRules(notNullRules);
    }

    public SpanSamplingRules(List<Rule> rules) {
        this.rules = rules;
    }

    public List<Rule> getRules() {
        return Collections.unmodifiableList(this.rules);
    }

    public boolean isEmpty() {
        return this.rules.isEmpty();
    }

    private static final class RuleAdapter {
        private RuleAdapter() {
        }

        @FromJson
        Rule fromJson(JsonRule jsonRule) {
            return jsonRule.toRule();
        }
    }

    private static final class JsonRule {
        String service;
        String name;
        String sample_rate;
        String max_per_second;

        private JsonRule() {
        }

        private Rule toRule() {
            return Rule.create(this.service, this.name, this.sample_rate, this.max_per_second);
        }
    }

    public static final class Rule {
        private final String service;
        private final String name;
        private final double sampleRate;
        private final int maxPerSecond;

        public static Rule create(String service, String name, Double sampleRate, Integer maxPerSecond) {
            if (sampleRate == null) {
                sampleRate = 1.0;
            } else if (sampleRate < 0.0 || sampleRate > 1.0) {
                Rule.logError(service, name, Double.toString(sampleRate), maxPerSecond == null ? null : Double.toString(maxPerSecond.intValue()), "sample_rate must be between 0.0 and 1.0");
                return null;
            }
            if (maxPerSecond == null) {
                maxPerSecond = Integer.MAX_VALUE;
            } else if (maxPerSecond < 1) {
                Rule.logError(service, name, Double.toString(sampleRate), Double.toString(maxPerSecond.intValue()), "max_per_second must be greater than zero");
                return null;
            }
            return new Rule(service, name, sampleRate, maxPerSecond);
        }

        public static Rule create(String service, String name, String sampleRate, String maxPerSecond) {
            double sampleRateParsed = 1.0;
            if (sampleRate != null) {
                try {
                    sampleRateParsed = Double.parseDouble(sampleRate);
                }
                catch (NumberFormatException ex) {
                    Rule.logError(service, name, sampleRate, maxPerSecond, "sample_rate must be a number between 0.0 and 1.0");
                    return null;
                }
            }
            Integer maxPerSecondParsed = null;
            if (maxPerSecond != null) {
                try {
                    maxPerSecondParsed = Integer.parseInt(maxPerSecond);
                }
                catch (NumberFormatException ex) {
                    Rule.logError(service, name, sampleRate, maxPerSecond, "max_per_second must be greater than zero");
                    return null;
                }
            }
            return Rule.create(service, name, sampleRateParsed, maxPerSecondParsed);
        }

        private static void logError(String service, String name, String sampleRate, String maxPerSecond, String error) {
            log.error("Skipping invalid Trace Sampling Rule: { \"service\": \"" + service + "\", \"name\": \"" + name + "\", \"sample_rate\": " + sampleRate + "\", \"max_per_second\": " + maxPerSecond + " } - " + error);
        }

        private Rule(String service, String name, double sampleRate, int maxPerSecond) {
            this.service = service;
            this.name = name;
            this.sampleRate = sampleRate;
            this.maxPerSecond = maxPerSecond;
        }

        public String getService() {
            return this.service;
        }

        public String getName() {
            return this.name;
        }

        public double getSampleRate() {
            return this.sampleRate;
        }

        public int getMaxPerSecond() {
            return this.maxPerSecond;
        }
    }
}

