/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.http.RetryPolicy;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.RemoteResponseListener;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDEvpProxyApi
extends RemoteApi {
    private static final Logger log = LoggerFactory.getLogger(DDEvpProxyApi.class);
    private static final String DD_EVP_SUBDOMAIN_HEADER = "X-Datadog-EVP-Subdomain";
    private final OkHttpClient httpClient;
    private final HttpUrl proxiedApiUrl;
    private final String subdomain;
    private final RetryPolicy retryPolicy;

    public static DDEvpProxyApiBuilder builder() {
        return new DDEvpProxyApiBuilder();
    }

    private DDEvpProxyApi(OkHttpClient httpClient, HttpUrl proxiedApiUrl, String subdomain, RetryPolicy retryPolicy) {
        this.httpClient = httpClient;
        this.proxiedApiUrl = proxiedApiUrl;
        this.subdomain = subdomain;
        this.retryPolicy = retryPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        int sizeInBytes = payload.sizeInBytes();
        int retry = 1;
        try {
            Request request = new Request.Builder().url(this.proxiedApiUrl).addHeader(DD_EVP_SUBDOMAIN_HEADER, this.subdomain).post(payload.toRequest()).build();
            this.totalTraces += (long)payload.traceCount();
            this.receivedTraces += (long)payload.traceCount();
            while (true) {
                block26: {
                    try (Response response = this.httpClient.newCall(request).execute();){
                        boolean shouldRetry;
                        if (response.isSuccessful()) {
                            this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
                            RemoteApi.Response response2 = RemoteApi.Response.success(response.code());
                            return response2;
                        }
                        int httpCode = response.code();
                        boolean bl = shouldRetry = httpCode >= 500 && this.retryPolicy.shouldRetry(retry);
                        if (!shouldRetry) {
                            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, response, null);
                            RemoteApi.Response response3 = RemoteApi.Response.failed(httpCode);
                            return response3;
                        }
                    }
                    catch (ConnectException ex) {
                        boolean shouldRetry = this.retryPolicy.shouldRetry(retry);
                        if (shouldRetry) break block26;
                        this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, null);
                        return RemoteApi.Response.failed(ex);
                    }
                }
                long backoffMs = this.retryPolicy.backoff(retry);
                try {
                    Thread.sleep(backoffMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                ++retry;
            }
        }
        catch (IOException e) {
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
    }

    @Override
    public void addResponseListener(RemoteResponseListener listener) {
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public static class DDEvpProxyApiBuilder {
        private String apiVersion = "v2";
        private TrackType trackType = TrackType.NOOP;
        private long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        HttpUrl agentUrl = null;
        OkHttpClient httpClient = null;
        RetryPolicy retryPolicy = null;
        String evpProxyEndpoint;

        public DDEvpProxyApiBuilder trackType(TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDEvpProxyApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDEvpProxyApiBuilder evpProxyEndpoint(String evpProxyEndpoint) {
            this.evpProxyEndpoint = evpProxyEndpoint;
            return this;
        }

        public DDEvpProxyApiBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDEvpProxyApiBuilder agentUrl(HttpUrl agentUrl) {
            this.agentUrl = agentUrl;
            return this;
        }

        public DDEvpProxyApiBuilder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        DDEvpProxyApiBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DDEvpProxyApi build() {
            OkHttpClient client;
            String trackName = (this.trackType != null ? this.trackType.name() : TrackType.NOOP.name()).toLowerCase();
            String subdomain = String.format("%s-intake", trackName);
            HttpUrl evpProxyUrl = this.agentUrl.resolve(this.evpProxyEndpoint);
            HttpUrl proxiedApiUrl = evpProxyUrl.resolve(String.format("api/%s/%s", this.apiVersion, trackName));
            OkHttpClient okHttpClient = client = this.httpClient != null ? this.httpClient : OkHttpUtils.buildHttpClient(proxiedApiUrl, this.timeoutMillis);
            if (null == this.retryPolicy) {
                this.retryPolicy = RetryPolicy.builder().withMaxRetry(5).withBackoff(100L).build();
            }
            log.debug("proxiedApiUrl: " + proxiedApiUrl);
            return new DDEvpProxyApi(client, proxiedApiUrl, subdomain, this.retryPolicy);
        }
    }
}

