/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import datadog.trace.api.Config;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.http.RetryPolicy;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.RemoteResponseListener;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.net.ConnectException;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDIntakeApi
extends RemoteApi {
    private static final String DD_API_KEY_HEADER = "dd-api-key";
    private static final Logger log = LoggerFactory.getLogger(DDIntakeApi.class);
    private final OkHttpClient httpClient;
    private final HttpUrl intakeUrl;
    private final String apiKey;
    private final RetryPolicy retryPolicy;

    public static DDIntakeApiBuilder builder() {
        return new DDIntakeApiBuilder();
    }

    private DDIntakeApi(OkHttpClient httpClient, HttpUrl intakeUrl, String apiKey, RetryPolicy retryPolicy) {
        this.httpClient = httpClient;
        this.intakeUrl = intakeUrl;
        this.apiKey = apiKey;
        this.retryPolicy = retryPolicy;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        int sizeInBytes = payload.sizeInBytes();
        int retry = 1;
        try {
            Request request = new Request.Builder().url(this.intakeUrl).addHeader(DD_API_KEY_HEADER, this.apiKey).post(payload.toRequest()).build();
            this.totalTraces += (long)payload.traceCount();
            this.receivedTraces += (long)payload.traceCount();
            while (true) {
                block26: {
                    try (Response response = this.httpClient.newCall(request).execute();){
                        boolean shouldRetry;
                        if (response.isSuccessful()) {
                            this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
                            RemoteApi.Response response2 = RemoteApi.Response.success(response.code());
                            return response2;
                        }
                        int httpCode = response.code();
                        boolean bl = shouldRetry = httpCode >= 500 && this.retryPolicy.shouldRetry(retry);
                        if (!shouldRetry) {
                            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, response, null);
                            RemoteApi.Response response3 = RemoteApi.Response.failed(httpCode);
                            return response3;
                        }
                    }
                    catch (ConnectException ex) {
                        boolean shouldRetry = this.retryPolicy.shouldRetry(retry);
                        if (shouldRetry) break block26;
                        this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, null);
                        return RemoteApi.Response.failed(ex);
                    }
                }
                long backoffMs = this.retryPolicy.backoff(retry);
                try {
                    Thread.sleep(backoffMs);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
                ++retry;
            }
        }
        catch (IOException e) {
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
    }

    @Override
    public void addResponseListener(RemoteResponseListener listener) {
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public static class DDIntakeApiBuilder {
        private String site = Config.get().getSite();
        private String apiVersion = "v2";
        private TrackType trackType = TrackType.NOOP;
        private long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        HttpUrl hostUrl = null;
        OkHttpClient httpClient = null;
        RetryPolicy retryPolicy = null;
        private String apiKey;

        public DDIntakeApiBuilder trackType(TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDIntakeApiBuilder site(String site) {
            this.site = site;
            return this;
        }

        public DDIntakeApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDIntakeApiBuilder apiKey(String apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        public DDIntakeApiBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDIntakeApiBuilder hostUrl(HttpUrl hostUrl) {
            this.hostUrl = hostUrl;
            return this;
        }

        public DDIntakeApiBuilder retryPolicy(RetryPolicy retryPolicy) {
            this.retryPolicy = retryPolicy;
            return this;
        }

        DDIntakeApiBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DDIntakeApi build() {
            OkHttpClient client;
            assert (this.apiKey != null);
            String trackName = (this.trackType != null ? this.trackType.name() : TrackType.NOOP.name()).toLowerCase();
            if (null == this.hostUrl) {
                this.hostUrl = HttpUrl.get(String.format("https://%s-intake.%s", trackName, this.site));
            }
            HttpUrl intakeUrl = this.hostUrl.resolve(String.format("/api/%s/%s", this.apiVersion, trackName));
            OkHttpClient okHttpClient = client = this.httpClient != null ? this.httpClient : OkHttpUtils.buildHttpClient(intakeUrl, this.timeoutMillis);
            if (null == this.retryPolicy) {
                this.retryPolicy = RetryPolicy.builder().withMaxRetry(5).withBackoff(100L).build();
            }
            return new DDIntakeApi(client, intakeUrl, this.apiKey, this.retryPolicy);
        }
    }
}

