/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.Functions;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.bootstrap.ActiveSubsystems;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.propagation.DatadogTags;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public abstract class ContextInterpreter
implements AgentPropagation.KeyClassifier {
    protected final Map<String, String> taggedHeaders;
    protected final Map<String, String> baggageMapping;
    protected DDTraceId traceId;
    protected long spanId;
    protected int samplingPriority;
    protected Map<String, String> tags;
    protected Map<String, String> baggage;
    protected String origin;
    protected long endToEndStartTime;
    protected boolean valid;
    protected DatadogTags datadogTags;
    private TagContext.HttpHeaders httpHeaders;
    private final String customIpHeaderName;
    private final boolean clientIpResolutionEnabled;
    private final boolean clientIpWithoutAppSec;
    private boolean collectIpHeaders;
    protected static final boolean LOG_EXTRACT_HEADER_NAMES = Config.get().isLogExtractHeaderNames();
    private static final DDCache<String, String> CACHE = DDCaches.newFixedSizeCache(64);

    protected String toLowerCase(String key) {
        return CACHE.computeIfAbsent(key, Functions.LowerCase.INSTANCE);
    }

    protected ContextInterpreter(Map<String, String> taggedHeaders, Map<String, String> baggageMapping, Config config) {
        this.taggedHeaders = taggedHeaders;
        this.baggageMapping = baggageMapping;
        this.customIpHeaderName = config.getTraceClientIpHeader();
        this.clientIpResolutionEnabled = config.isTraceClientIpResolverEnabled();
        this.clientIpWithoutAppSec = config.isClientIpEnabled();
        this.reset();
    }

    protected final boolean handledForwarding(String key, String value) {
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        if ("forwarded".equalsIgnoreCase(key)) {
            this.getHeaders().forwarded = value;
            return true;
        }
        if ("forwarded-for".equalsIgnoreCase(key)) {
            this.getHeaders().forwardedFor = value;
            return true;
        }
        return false;
    }

    protected final boolean handledXForwarding(String key, String value) {
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        if ("x-forwarded-proto".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedProto = value;
            return true;
        }
        if ("x-forwarded-host".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedHost = value;
            return true;
        }
        if ("x-forwarded-for".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedFor = value;
            return true;
        }
        if ("x-forwarded-port".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedPort = value;
            return true;
        }
        if ("x-forwarded".equalsIgnoreCase(key)) {
            this.getHeaders().xForwarded = value;
            return true;
        }
        return false;
    }

    protected final boolean handledUserAgent(String key, String value) {
        if (value == null || !"user-agent".equalsIgnoreCase(key)) {
            return false;
        }
        this.getHeaders().userAgent = value;
        return true;
    }

    protected final boolean handledIpHeaders(String key, String value) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        if (null != value && this.customIpHeaderName != null && this.customIpHeaderName.equalsIgnoreCase(key)) {
            this.getHeaders().customIpHeader = value;
            return true;
        }
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        char last = Character.toLowerCase(key.charAt(key.length() - 1));
        if (last == 'p') {
            if ("x-cluster-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().xClusterClientIp = value;
                return true;
            }
            if ("x-real-ip".equalsIgnoreCase(key)) {
                this.getHeaders().xRealIp = value;
                return true;
            }
            if ("client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().clientIp = value;
                return true;
            }
            if ("true-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().trueClientIp = value;
                return true;
            }
        }
        if ("via".equalsIgnoreCase(key)) {
            this.getHeaders().via = value;
            return true;
        }
        return false;
    }

    public ContextInterpreter reset() {
        this.traceId = DDTraceId.ZERO;
        this.spanId = 0L;
        this.samplingPriority = this.defaultSamplingPriority();
        this.origin = null;
        this.endToEndStartTime = 0L;
        this.tags = Collections.emptyMap();
        this.baggage = Collections.emptyMap();
        this.valid = true;
        this.httpHeaders = null;
        this.collectIpHeaders = this.clientIpWithoutAppSec || this.clientIpResolutionEnabled && ActiveSubsystems.APPSEC_ACTIVE;
        return this;
    }

    TagContext build() {
        if (this.valid) {
            if (!DDTraceId.ZERO.equals(this.traceId)) {
                ExtractedContext context = new ExtractedContext(this.traceId, this.spanId, this.samplingPriority, this.origin, this.endToEndStartTime, this.baggage, this.tags, this.httpHeaders, this.datadogTags);
                return context;
            }
            if (this.origin != null || !this.tags.isEmpty() || this.httpHeaders != null) {
                return new TagContext(this.origin, this.tags, this.httpHeaders);
            }
        }
        return null;
    }

    protected void invalidateContext() {
        this.valid = false;
    }

    protected int defaultSamplingPriority() {
        return -128;
    }

    private final TagContext.HttpHeaders getHeaders() {
        if (this.httpHeaders == null) {
            this.httpHeaders = new TagContext.HttpHeaders();
        }
        return this.httpHeaders;
    }

    public static abstract class Factory {
        public ContextInterpreter create(Map<String, String> tagsMapping, Map<String, String> baggageMapping) {
            return this.construct(this.cleanMapping(tagsMapping), this.cleanMapping(baggageMapping));
        }

        protected abstract ContextInterpreter construct(Map<String, String> var1, Map<String, String> var2);

        protected Map<String, String> cleanMapping(Map<String, String> mapping) {
            HashMap<String, String> cleanedMapping = new HashMap<String, String>(mapping.size() * 4 / 3);
            for (Map.Entry<String, String> association : mapping.entrySet()) {
                cleanedMapping.put(association.getKey().trim().toLowerCase(), association.getValue().trim().toLowerCase());
            }
            return cleanedMapping;
        }
    }
}

