/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.PropagationStyle;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.DDSpanContext;
import ddtrot.dd.trace.core.propagation.B3HttpCodec;
import ddtrot.dd.trace.core.propagation.DatadogHttpCodec;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.HaystackHttpCodec;
import ddtrot.dd.trace.core.propagation.XRayHttpCodec;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpCodec {
    private static final Logger log = LoggerFactory.getLogger(HttpCodec.class);
    static final String FORWARDED_KEY = "forwarded";
    static final String FORWARDED_FOR_KEY = "forwarded-for";
    static final String X_FORWARDED_PROTO_KEY = "x-forwarded-proto";
    static final String X_FORWARDED_HOST_KEY = "x-forwarded-host";
    static final String X_FORWARDED_KEY = "x-forwarded";
    static final String X_FORWARDED_FOR_KEY = "x-forwarded-for";
    static final String X_FORWARDED_PORT_KEY = "x-forwarded-port";
    static final String CLIENT_IP_KEY = "client-ip";
    static final String TRUE_CLIENT_IP_KEY = "true-client-ip";
    static final String X_CLUSTER_CLIENT_IP_KEY = "x-cluster-client-ip";
    static final String X_REAL_IP_KEY = "x-real-ip";
    static final String USER_AGENT_KEY = "user-agent";
    static final String VIA_KEY = "via";

    public static <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter, Injector injector) {
        injector.inject(context, carrier, setter);
    }

    public static Injector createInjector(Set<PropagationStyle> styles, Map<String, String> invertedBaggageMapping) {
        ArrayList<Injector> injectors = new ArrayList<Injector>(HttpCodec.createInjectors(styles, invertedBaggageMapping).values());
        return new CompoundInjector(injectors);
    }

    public static Map<PropagationStyle, Injector> createInjectors(Set<PropagationStyle> propagationStyles, Map<String, String> reverseBaggageMapping) {
        EnumMap<PropagationStyle, Injector> result = new EnumMap<PropagationStyle, Injector>(PropagationStyle.class);
        block6: for (PropagationStyle style : propagationStyles) {
            switch (style) {
                case DATADOG: {
                    result.put(PropagationStyle.DATADOG, DatadogHttpCodec.newInjector(reverseBaggageMapping));
                    continue block6;
                }
                case B3: {
                    result.put(PropagationStyle.B3, B3HttpCodec.INJECTOR);
                    continue block6;
                }
                case HAYSTACK: {
                    result.put(PropagationStyle.HAYSTACK, HaystackHttpCodec.newInjector(reverseBaggageMapping));
                    continue block6;
                }
                case XRAY: {
                    result.put(PropagationStyle.XRAY, XRayHttpCodec.newInjector(reverseBaggageMapping));
                    continue block6;
                }
            }
            log.debug("No implementation found to inject propagation style: {}", (Object)style);
        }
        return result;
    }

    public static Extractor createExtractor(Config config, Map<String, String> taggedHeaders, Map<String, String> baggageMapping) {
        ArrayList<Extractor> extractors = new ArrayList<Extractor>();
        block6: for (PropagationStyle style : config.getPropagationStylesToExtract()) {
            switch (style) {
                case DATADOG: {
                    extractors.add(DatadogHttpCodec.newExtractor(taggedHeaders, baggageMapping, config));
                    continue block6;
                }
                case B3: {
                    extractors.add(B3HttpCodec.newExtractor(taggedHeaders, baggageMapping));
                    continue block6;
                }
                case HAYSTACK: {
                    extractors.add(HaystackHttpCodec.newExtractor(taggedHeaders, baggageMapping));
                    continue block6;
                }
                case XRAY: {
                    extractors.add(XRayHttpCodec.newExtractor(taggedHeaders, baggageMapping));
                    continue block6;
                }
            }
            log.debug("No implementation found to extract propagation style: {}", (Object)style);
        }
        return new CompoundExtractor(extractors);
    }

    static String encode(String value) {
        String encoded = value;
        try {
            encoded = URLEncoder.encode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to encode value - {}", (Object)value);
        }
        return encoded;
    }

    static String decode(String value) {
        String decoded = value;
        try {
            decoded = URLDecoder.decode(value, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            log.debug("Failed to decode value - {}", (Object)value);
        }
        return decoded;
    }

    static String firstHeaderValue(String value) {
        if (value == null) {
            return null;
        }
        int firstComma = value.indexOf(44);
        return firstComma == -1 ? value : value.substring(0, firstComma).trim();
    }

    public static class CompoundExtractor
    implements Extractor {
        private final List<Extractor> extractors;

        public CompoundExtractor(List<Extractor> extractors) {
            this.extractors = extractors;
        }

        @Override
        public <C> TagContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            TagContext context = null;
            for (Extractor extractor : this.extractors) {
                context = extractor.extract(carrier, getter);
                if (!(context instanceof ExtractedContext)) continue;
                return context;
            }
            return context;
        }
    }

    public static class CompoundInjector
    implements Injector {
        private final List<Injector> injectors;

        public CompoundInjector(List<Injector> injectors) {
            this.injectors = injectors;
        }

        @Override
        public <C> void inject(DDSpanContext context, C carrier, AgentPropagation.Setter<C> setter) {
            for (Injector injector : this.injectors) {
                injector.inject(context, carrier, setter);
            }
        }
    }

    public static interface Extractor {
        public <C> TagContext extract(C var1, AgentPropagation.ContextVisitor<C> var2);
    }

    public static interface Injector {
        public <C> void inject(DDSpanContext var1, C var2, AgentPropagation.Setter<C> var3);
    }
}

