/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.telemetry;

import ddtrot.dd.trace.api.civisibility.telemetry.CiVisibilityMetricData;
import ddtrot.dd.trace.api.civisibility.telemetry.TagValue;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.Command;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.CoverageEnabled;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.CoverageErrorType;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.Endpoint;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.ErrorType;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.EventType;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.ExitCode;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.HasCodeowner;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.IsBenchmark;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.IsHeadless;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.IsUnsupportedCI;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.ItrEnabled;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.ItrSkipEnabled;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.Library;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.RequireGit;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.TestFrameworkInstrumentation;
import java.util.Arrays;

public enum CiVisibilityCountMetric {
    EVENT_CREATED("event_created", TestFrameworkInstrumentation.class, EventType.class, IsHeadless.class, HasCodeowner.class, IsUnsupportedCI.class, IsBenchmark.class),
    EVENT_FINISHED("event_finished", TestFrameworkInstrumentation.class, EventType.class, IsHeadless.class, HasCodeowner.class, IsUnsupportedCI.class, IsBenchmark.class),
    CODE_COVERAGE_STARTED("code_coverage_started", TestFrameworkInstrumentation.class, Library.class),
    CODE_COVERAGE_FINISHED("code_coverage_finished", TestFrameworkInstrumentation.class, Library.class),
    CODE_COVERAGE_IS_EMPTY("code_coverage.is_empty", new Class[0]),
    CODE_COVERAGE_ERRORS("code_coverage.errors", CoverageErrorType.class),
    MANUAL_API_EVENTS("manual_api_events", EventType.class),
    EVENTS_ENQUEUED_FOR_SERIALIZATION("events_enqueued_for_serialization", new Class[0]),
    ENDPOINT_PAYLOAD_REQUESTS("endpoint_payload.requests", Endpoint.class),
    ENDPOINT_PAYLOAD_REQUESTS_ERRORS("endpoint_payload.requests_errors", Endpoint.class, ErrorType.class),
    ENDPOINT_PAYLOAD_DROPPED("endpoint_payload.dropped", Endpoint.class),
    GIT_COMMAND("git.command", Command.class),
    GIT_COMMAND_ERRORS("git.command_errors", Command.class, ExitCode.class),
    GIT_REQUESTS_SEARCH_COMMITS("git_requests.search_commits", new Class[0]),
    GIT_REQUESTS_SEARCH_COMMITS_ERRORS("git_requests.search_commits_errors", ErrorType.class),
    GIT_REQUESTS_OBJECTS_PACK("git_requests.objects_pack", new Class[0]),
    GIT_REQUESTS_OBJECTS_PACK_ERRORS("git_requests.objects_pack_errors", ErrorType.class),
    GIT_REQUESTS_SETTINGS("git_requests.settings", new Class[0]),
    GIT_REQUESTS_SETTINGS_ERRORS("git_requests.settings_errors", ErrorType.class),
    GIT_REQUESTS_SETTINGS_RESPONSE("git_requests.settings_response", ItrEnabled.class, ItrSkipEnabled.class, CoverageEnabled.class, RequireGit.class),
    ITR_SKIPPABLE_TESTS_REQUEST("itr_skippable_tests.request", new Class[0]),
    ITR_SKIPPABLE_TESTS_REQUEST_ERRORS("itr_skippable_tests.request_errors", ErrorType.class),
    ITR_SKIPPABLE_TESTS_RESPONSE_TESTS("itr_skippable_tests.response_tests", new Class[0]),
    ITR_SKIPPED("itr_skipped", EventType.class),
    ITR_UNSKIPPABLE("itr_unskippable", EventType.class),
    ITR_FORCED_RUN("itr_forced_run", EventType.class);

    private final String name;
    private final int index;
    private final Class<? extends TagValue>[] tags;
    private final TagValue[][] tagValues;
    private final int[] tagIdxMultipliers;

    @SafeVarargs
    private CiVisibilityCountMetric(String metricName, Class<? extends TagValue> ... metricTags) {
        int i;
        this.name = metricName;
        this.index = IndexHolder.INDEX;
        this.tags = metricTags;
        this.tagValues = new TagValue[this.tags.length][];
        for (i = 0; i < this.tags.length; ++i) {
            this.tagValues[i] = this.tags[i].getEnumConstants();
        }
        this.tagIdxMultipliers = new int[this.tags.length];
        if (this.tags.length != 0) {
            this.tagIdxMultipliers[0] = 1;
        }
        for (i = 1; i < this.tags.length; ++i) {
            this.tagIdxMultipliers[i] = this.tagIdxMultipliers[i - 1] * (this.tagValues[i - 1].length + 1);
        }
        IndexHolder.INDEX = this.getEndIndex();
    }

    public String getName() {
        return this.name;
    }

    public Class<? extends TagValue>[] getTags() {
        return this.tags;
    }

    public int getEndIndex() {
        int delta = this.tagValues.length > 0 ? this.tagIdxMultipliers[this.tagIdxMultipliers.length - 1] * (this.tagValues[this.tagValues.length - 1].length + 1) : 1;
        return this.index + delta;
    }

    public CiVisibilityMetricData createData(long value, TagValue ... tagValues) {
        return new CiVisibilityMetricData(this.name, value, tagValues);
    }

    public int getIndex(TagValue ... tagValues) {
        int index = this.index;
        for (TagValue tagValue : tagValues) {
            if (tagValue == null) continue;
            index += this.calculateIdxDelta(tagValue);
        }
        return index;
    }

    private int calculateIdxDelta(TagValue tagValue) {
        Class<? extends TagValue> tag = tagValue.getDeclaringClass();
        for (int i = 0; i < this.tags.length; ++i) {
            if (tag != this.tags[i]) continue;
            return this.tagIdxMultipliers[i] * (tagValue.ordinal() + 1);
        }
        throw new IllegalArgumentException("Metric " + this.name() + " cannot be tagged with " + tag.getSimpleName() + ", allowed tags are " + Arrays.toString(this.tags));
    }

    public TagValue[] getTagValues(int index) {
        int tagValueIdx = 0;
        TagValue[] values = new TagValue[this.tags.length];
        index -= this.index;
        for (int i = 0; i < this.tags.length; ++i) {
            TagValue[] possibleValues = this.tagValues[i];
            int tagCardinality = possibleValues.length + 1;
            int tagOrdinal = index % tagCardinality;
            if (tagOrdinal != 0) {
                values[tagValueIdx++] = possibleValues[--tagOrdinal];
            }
            index /= tagCardinality;
        }
        return tagValueIdx == values.length ? values : Arrays.copyOf(values, tagValueIdx);
    }

    public static int count() {
        return IndexHolder.INDEX;
    }

    static class IndexHolder {
        private static int INDEX = 0;

        IndexHolder() {
        }
    }
}

