/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.config;

import ddtrot.dd.trace.api.civisibility.config.TestIdentifier;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModuleExecutionSettings {
    public static final ModuleExecutionSettings EMPTY = new ModuleExecutionSettings(false, false, false, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyList(), Collections.emptyList());
    private final boolean codeCoverageEnabled;
    private final boolean itrEnabled;
    private final boolean flakyTestRetriesEnabled;
    private final Map<String, String> systemProperties;
    private final Map<String, Collection<TestIdentifier>> skippableTestsByModule;
    private final Collection<TestIdentifier> flakyTests;
    private final List<String> coverageEnabledPackages;

    public ModuleExecutionSettings(boolean codeCoverageEnabled, boolean itrEnabled, boolean flakyTestRetriesEnabled, Map<String, String> systemProperties, Map<String, Collection<TestIdentifier>> skippableTestsByModule, Collection<TestIdentifier> flakyTests, List<String> coverageEnabledPackages) {
        this.codeCoverageEnabled = codeCoverageEnabled;
        this.itrEnabled = itrEnabled;
        this.flakyTestRetriesEnabled = flakyTestRetriesEnabled;
        this.systemProperties = systemProperties;
        this.skippableTestsByModule = skippableTestsByModule;
        this.flakyTests = flakyTests;
        this.coverageEnabledPackages = coverageEnabledPackages;
    }

    public boolean isCodeCoverageEnabled() {
        return this.codeCoverageEnabled;
    }

    public boolean isItrEnabled() {
        return this.itrEnabled;
    }

    public boolean isFlakyTestRetriesEnabled() {
        return this.flakyTestRetriesEnabled;
    }

    public Map<String, String> getSystemProperties() {
        return this.systemProperties;
    }

    public Map<String, Collection<TestIdentifier>> getSkippableTestsByModule() {
        return this.skippableTestsByModule;
    }

    public Collection<TestIdentifier> getFlakyTests() {
        return this.flakyTests;
    }

    public Collection<TestIdentifier> getSkippableTests(String moduleName) {
        return this.skippableTestsByModule.getOrDefault(moduleName, Collections.emptyList());
    }

    public Collection<TestIdentifier> getFlakyTests(String moduleName) {
        return this.flakyTests;
    }

    public List<String> getCoverageEnabledPackages() {
        return this.coverageEnabledPackages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleExecutionSettings that = (ModuleExecutionSettings)o;
        return this.codeCoverageEnabled == that.codeCoverageEnabled && this.itrEnabled == that.itrEnabled && Objects.equals(this.systemProperties, that.systemProperties) && Objects.equals(this.skippableTestsByModule, that.skippableTestsByModule) && Objects.equals(this.flakyTests, that.flakyTests) && Objects.equals(this.coverageEnabledPackages, that.coverageEnabledPackages);
    }

    public int hashCode() {
        return Objects.hash(this.codeCoverageEnabled, this.itrEnabled, this.systemProperties, this.skippableTestsByModule, this.flakyTests, this.coverageEnabledPackages);
    }
}

