/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import datadog.trace.api.Config;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.WellKnownTags;
import datadog.trace.api.experimental.DataStreamsContextCarrier;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import ddtrot.dd.trace.bootstrap.instrumentation.api.Backlog;
import ddtrot.dd.trace.bootstrap.instrumentation.api.InboxItem;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.StatsPoint;
import ddtrot.dd.trace.common.metrics.EventListener;
import ddtrot.dd.trace.common.metrics.OkHttpSink;
import ddtrot.dd.trace.common.metrics.Sink;
import ddtrot.dd.trace.core.DDSpan;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.core.datastreams.DataStreamContextExtractor;
import ddtrot.dd.trace.core.datastreams.DataStreamContextInjector;
import ddtrot.dd.trace.core.datastreams.DataStreamsContextCarrierAdapter;
import ddtrot.dd.trace.core.datastreams.DataStreamsMonitoring;
import ddtrot.dd.trace.core.datastreams.DatastreamsPayloadWriter;
import ddtrot.dd.trace.core.datastreams.DefaultPathwayContext;
import ddtrot.dd.trace.core.datastreams.MsgPackDatastreamsPayloadWriter;
import ddtrot.dd.trace.core.datastreams.SchemaSampler;
import ddtrot.dd.trace.core.datastreams.StatsBucket;
import ddtrot.dd.trace.core.datastreams.TagsProcessor;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.org.jctools.queues.MpscBlockingConsumerArrayQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultDataStreamsMonitoring
implements DataStreamsMonitoring,
EventListener {
    private static final Logger log = LoggerFactory.getLogger(DefaultDataStreamsMonitoring.class);
    static final long FEATURE_CHECK_INTERVAL_NANOS = TimeUnit.MINUTES.toNanos(5L);
    private static final StatsPoint REPORT = new StatsPoint(Collections.emptyList(), 0L, 0L, 0L, 0L, 0L, 0L);
    private static final StatsPoint POISON_PILL = new StatsPoint(Collections.emptyList(), 0L, 0L, 0L, 0L, 0L, 0L);
    private final Map<Long, StatsBucket> timeToBucket = new HashMap<Long, StatsBucket>();
    private final BlockingQueue<InboxItem> inbox = new MpscBlockingConsumerArrayQueue<InboxItem>(1024);
    private final DatastreamsPayloadWriter payloadWriter;
    private final DDAgentFeaturesDiscovery features;
    private final TimeSource timeSource;
    private final WellKnownTags wellKnownTags;
    private final Supplier<TraceConfig> traceConfigSupplier;
    private final long bucketDurationNanos;
    private final DataStreamContextInjector injector;
    private final Thread thread;
    private AgentTaskScheduler.Scheduled<DefaultDataStreamsMonitoring> cancellation;
    private volatile long nextFeatureCheck;
    private volatile boolean supportsDataStreams = false;
    private volatile boolean agentSupportsDataStreams = false;
    private volatile boolean configSupportsDataStreams = false;
    private final ConcurrentHashMap<String, SchemaSampler> schemaSamplers;

    public DefaultDataStreamsMonitoring(Config config, SharedCommunicationObjects sharedCommunicationObjects, TimeSource timeSource, Supplier<TraceConfig> traceConfigSupplier) {
        this(new OkHttpSink(sharedCommunicationObjects.okHttpClient, sharedCommunicationObjects.agentUrl.toString(), "v0.1/pipeline_stats", false, true, Collections.emptyMap()), sharedCommunicationObjects.featuresDiscovery(config), timeSource, traceConfigSupplier, config);
    }

    public DefaultDataStreamsMonitoring(Sink sink, DDAgentFeaturesDiscovery features, TimeSource timeSource, Supplier<TraceConfig> traceConfigSupplier, Config config) {
        this(sink, features, timeSource, traceConfigSupplier, config.getWellKnownTags(), new MsgPackDatastreamsPayloadWriter(sink, config.getWellKnownTags(), DDTraceCoreInfo.VERSION, config.getPrimaryTag()), Config.get().getDataStreamsBucketDurationNanoseconds());
    }

    public DefaultDataStreamsMonitoring(Sink sink, DDAgentFeaturesDiscovery features, TimeSource timeSource, Supplier<TraceConfig> traceConfigSupplier, WellKnownTags wellKnownTags, DatastreamsPayloadWriter payloadWriter, long bucketDurationNanos) {
        this.features = features;
        this.timeSource = timeSource;
        this.traceConfigSupplier = traceConfigSupplier;
        this.wellKnownTags = wellKnownTags;
        this.payloadWriter = payloadWriter;
        this.bucketDurationNanos = bucketDurationNanos;
        this.injector = new DataStreamContextInjector(this);
        this.thread = AgentThreadFactory.newAgentThread(AgentThreadFactory.AgentThread.DATA_STREAMS_MONITORING, new InboxProcessor());
        sink.register(this);
        this.schemaSamplers = new ConcurrentHashMap();
    }

    @Override
    public void start() {
        if (this.features.getDataStreamsEndpoint() == null) {
            this.features.discoverIfOutdated();
        }
        this.agentSupportsDataStreams = this.features.supportsDataStreams();
        this.checkDynamicConfig();
        if (!this.configSupportsDataStreams) {
            log.debug("Data streams is disabled");
        } else if (!this.agentSupportsDataStreams) {
            log.debug("Data streams is disabled or not supported by agent");
        }
        this.nextFeatureCheck = this.timeSource.getCurrentTimeNanos() + FEATURE_CHECK_INTERVAL_NANOS;
        this.cancellation = AgentTaskScheduler.INSTANCE.scheduleAtFixedRate(new ReportTask(), this, this.bucketDurationNanos, this.bucketDurationNanos, TimeUnit.NANOSECONDS);
        this.thread.start();
    }

    @Override
    public void add(StatsPoint statsPoint) {
        if (this.thread.isAlive()) {
            this.inbox.offer(statsPoint);
        }
    }

    @Override
    public int shouldSampleSchema(String topic) {
        SchemaSampler sampler = this.schemaSamplers.computeIfAbsent(topic, t -> new SchemaSampler());
        return sampler.shouldSample(this.timeSource.getCurrentTimeMillis());
    }

    @Override
    public PathwayContext newPathwayContext() {
        if (this.configSupportsDataStreams) {
            return new DefaultPathwayContext(this.timeSource, this.wellKnownTags);
        }
        return AgentTracer.NoopPathwayContext.INSTANCE;
    }

    @Override
    public HttpCodec.Extractor extractor(HttpCodec.Extractor delegate) {
        return new DataStreamContextExtractor(delegate, this.timeSource, this.traceConfigSupplier, this.wellKnownTags);
    }

    @Override
    public DataStreamContextInjector injector() {
        return this.injector;
    }

    @Override
    public void mergePathwayContextIntoSpan(AgentSpan span, DataStreamsContextCarrier carrier) {
        if (span instanceof DDSpan) {
            DefaultPathwayContext pathwayContext = DefaultPathwayContext.extract(carrier, DataStreamsContextCarrierAdapter.INSTANCE, this.timeSource, this.wellKnownTags);
            ((DDSpan)span).context().mergePathwayContext(pathwayContext);
        }
    }

    @Override
    public void trackBacklog(LinkedHashMap<String, String> sortedTags, long value) {
        ArrayList<String> tags = new ArrayList<String>(sortedTags.size());
        for (Map.Entry<String, String> entry : sortedTags.entrySet()) {
            String tag = TagsProcessor.createTag(entry.getKey(), entry.getValue());
            if (tag == null) continue;
            tags.add(tag);
        }
        this.inbox.offer(new Backlog(tags, value, this.timeSource.getCurrentTimeNanos()));
    }

    @Override
    public void setCheckpoint(AgentSpan span, LinkedHashMap<String, String> sortedTags, long defaultTimestamp, long payloadSizeBytes) {
        PathwayContext pathwayContext = span.context().getPathwayContext();
        if (pathwayContext != null) {
            pathwayContext.setCheckpoint(sortedTags, this::add, defaultTimestamp, payloadSizeBytes);
            if (pathwayContext.getHash() != 0L) {
                span.setTag("pathway.hash", Long.toUnsignedString(pathwayContext.getHash()));
            }
        }
    }

    public void setConsumeCheckpoint(String type, String source, DataStreamsContextCarrier carrier) {
        if (type == null || type.isEmpty() || source == null || source.isEmpty()) {
            log.warn("setConsumeCheckpoint should be called with non-empty type and source");
            return;
        }
        AgentSpan span = AgentTracer.activeSpan();
        if (span == null) {
            log.warn("SetConsumeCheckpoint is called with no active span");
            return;
        }
        this.mergePathwayContextIntoSpan(span, carrier);
        LinkedHashMap<String, String> sortedTags = new LinkedHashMap<String, String>();
        sortedTags.put("direction", "in");
        sortedTags.put("topic", source);
        sortedTags.put("type", type);
        this.setCheckpoint(span, sortedTags, 0L, 0L);
    }

    public void setProduceCheckpoint(String type, String target, DataStreamsContextCarrier carrier) {
        if (type == null || type.isEmpty() || target == null || target.isEmpty()) {
            log.warn("SetProduceCheckpoint should be called with non-empty type and target");
            return;
        }
        AgentSpan span = AgentTracer.activeSpan();
        if (span == null) {
            log.warn("SetProduceCheckpoint is called with no active span");
            return;
        }
        LinkedHashMap<String, String> sortedTags = new LinkedHashMap<String, String>();
        sortedTags.put("direction", "out");
        sortedTags.put("topic", target);
        sortedTags.put("type", type);
        this.injector.injectPathwayContext(span, carrier, DataStreamsContextCarrierAdapter.INSTANCE, sortedTags);
    }

    @Override
    public void close() {
        if (null != this.cancellation) {
            this.cancellation.cancel();
        }
        this.inbox.offer(POISON_PILL);
        try {
            this.thread.join(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private long currentBucket(long timestampNanos) {
        return timestampNanos - timestampNanos % this.bucketDurationNanos;
    }

    private void flush(long timestampNanos) {
        long currentBucket = this.currentBucket(timestampNanos);
        ArrayList<StatsBucket> includedBuckets = new ArrayList<StatsBucket>();
        Iterator<Map.Entry<Long, StatsBucket>> mapIterator = this.timeToBucket.entrySet().iterator();
        while (mapIterator.hasNext()) {
            Map.Entry<Long, StatsBucket> entry = mapIterator.next();
            if (entry.getKey() >= currentBucket) continue;
            mapIterator.remove();
            includedBuckets.add(entry.getValue());
        }
        if (!includedBuckets.isEmpty()) {
            log.debug("Flushing {} buckets", (Object)includedBuckets.size());
            this.payloadWriter.writePayload(includedBuckets);
        }
    }

    @Override
    public void clear() {
        this.timeToBucket.clear();
    }

    void report() {
        this.inbox.offer(REPORT);
    }

    @Override
    public void onEvent(EventListener.EventType eventType, String message) {
        switch (eventType) {
            case DOWNGRADED: {
                log.debug("Agent downgrade was detected");
                this.checkFeatures();
                break;
            }
            case BAD_PAYLOAD: {
                log.debug("bad metrics payload sent to trace agent: {}", (Object)message);
                break;
            }
            case ERROR: {
                log.debug("trace agent errored receiving metrics payload: {}", (Object)message);
                break;
            }
        }
    }

    private void checkDynamicConfig() {
        this.configSupportsDataStreams = this.traceConfigSupplier.get().isDataStreamsEnabled();
        this.supportsDataStreams = this.agentSupportsDataStreams && this.configSupportsDataStreams;
    }

    private void checkFeatures() {
        boolean oldValue = this.agentSupportsDataStreams;
        this.features.discoverIfOutdated();
        this.agentSupportsDataStreams = this.features.supportsDataStreams();
        if (oldValue && !this.agentSupportsDataStreams && this.configSupportsDataStreams) {
            log.info("Disabling data streams reporting because it is not supported by the agent");
        } else if (!oldValue && this.agentSupportsDataStreams && this.configSupportsDataStreams) {
            log.info("Agent upgrade detected. Enabling data streams because it is now supported");
        } else if (!oldValue && this.agentSupportsDataStreams && !this.configSupportsDataStreams) {
            log.info("Agent upgrade detected. Not enabling data streams because it is disabled by config");
        }
        this.supportsDataStreams = this.agentSupportsDataStreams && this.configSupportsDataStreams;
        this.nextFeatureCheck = this.timeSource.getCurrentTimeNanos() + FEATURE_CHECK_INTERVAL_NANOS;
    }

    private static final class ReportTask
    implements AgentTaskScheduler.Task<DefaultDataStreamsMonitoring> {
        private ReportTask() {
        }

        @Override
        public void run(DefaultDataStreamsMonitoring target) {
            target.report();
        }
    }

    private class InboxProcessor
    implements Runnable {
        private InboxProcessor() {
        }

        @Override
        public void run() {
            Thread currentThread = Thread.currentThread();
            while (!currentThread.isInterrupted()) {
                try {
                    StatsBucket statsBucket;
                    Long bucket;
                    InboxItem payload = (InboxItem)DefaultDataStreamsMonitoring.this.inbox.take();
                    if (payload == REPORT) {
                        DefaultDataStreamsMonitoring.this.checkDynamicConfig();
                        if (DefaultDataStreamsMonitoring.this.supportsDataStreams) {
                            DefaultDataStreamsMonitoring.this.flush(DefaultDataStreamsMonitoring.this.timeSource.getCurrentTimeNanos());
                            continue;
                        }
                        if (DefaultDataStreamsMonitoring.this.timeSource.getCurrentTimeNanos() < DefaultDataStreamsMonitoring.this.nextFeatureCheck) continue;
                        DefaultDataStreamsMonitoring.this.checkFeatures();
                        continue;
                    }
                    if (payload == POISON_PILL) {
                        if (!DefaultDataStreamsMonitoring.this.supportsDataStreams) break;
                        DefaultDataStreamsMonitoring.this.flush(Long.MAX_VALUE);
                        break;
                    }
                    if (!DefaultDataStreamsMonitoring.this.supportsDataStreams) continue;
                    if (payload instanceof StatsPoint) {
                        StatsPoint statsPoint = (StatsPoint)payload;
                        bucket = DefaultDataStreamsMonitoring.this.currentBucket(statsPoint.getTimestampNanos());
                        statsBucket = DefaultDataStreamsMonitoring.this.timeToBucket.computeIfAbsent(bucket, startTime -> new StatsBucket((long)startTime, DefaultDataStreamsMonitoring.this.bucketDurationNanos));
                        statsBucket.addPoint(statsPoint);
                        continue;
                    }
                    if (!(payload instanceof Backlog)) continue;
                    Backlog backlog = (Backlog)payload;
                    bucket = DefaultDataStreamsMonitoring.this.currentBucket(backlog.getTimestampNanos());
                    statsBucket = DefaultDataStreamsMonitoring.this.timeToBucket.computeIfAbsent(bucket, startTime -> new StatsBucket((long)startTime, DefaultDataStreamsMonitoring.this.bucketDurationNanos));
                    statsBucket.addBacklog(backlog);
                }
                catch (InterruptedException e) {
                    currentThread.interrupt();
                }
                catch (Exception e) {
                    log.debug("Error monitoring data streams", (Throwable)e);
                }
            }
        }
    }
}

