/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.debugger.util;

import datadog.trace.api.Config;
import ddtrot.dd.trace.util.ClassNameTrie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class Redaction {
    public static final String REDACTED_VALUE = new String("redacted".toCharArray());
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final List<String> PREDEFINED_KEYWORDS = Arrays.asList("2fa", "accesstoken", "aiohttpsession", "apisecret", "apisignature", "apikey", "appkey", "applicationkey", "auth", "authtoken", "authorization", "ccnumber", "certificatepin", "cipher", "clientid", "clientsecret", "config", "connect.sid", "cookie", "credentials", "creditcard", "csrf", "csrftoken", "cvv", "databaseurl", "dburl", "encryptionkey", "encryptionkeyid", "env", "gpgkey", "jti", "jwt", "licensekey", "masterkey", "mysqlpwd", "nonce", "oauth", "oauth_token", "otp", "passhash", "passwd", "password", "passwordb", "pemfile", "pgpkey", "phpsessid", "pin", "pincode", "pkcs8", "privatekey", "publickey", "recaptchakey", "refreshtoken", "routingnumber", "salt", "secret", "secrettoken", "secretKey", "securityanswer", "securitycode", "securityquestion", "serviceaccountcredentials", "session", "sessionkey", "sessionid", "setcookie", "signature", "signaturekey", "sshkey", "ssn", "symfony", "token", "transactionid", "twiliotoken", "usersession", "voterid", "xapikey", "xcsrftoken", "xforwardedfor", "xrealip", "xauthtoken", "xsrftoken", "pwd");
    private static final Set<String> KEYWORDS = ConcurrentHashMap.newKeySet();
    private static ClassNameTrie typeTrie = ClassNameTrie.Builder.EMPTY_TRIE;
    private static List<String> redactedClasses;
    private static List<String> redactedPackages;

    public static void addUserDefinedKeywords(Config config) {
        String[] identifiers;
        String redactedIdentifiers = config.getDebuggerRedactedIdentifiers();
        if (redactedIdentifiers == null) {
            return;
        }
        for (String identifier : identifiers = COMMA_PATTERN.split(redactedIdentifiers)) {
            KEYWORDS.add(Redaction.normalize(identifier));
        }
    }

    public static void addUserDefinedTypes(Config config) {
        String[] types;
        String redactedTypes = config.getDebuggerRedactedTypes();
        if (redactedTypes == null) {
            return;
        }
        ArrayList<String> packages = null;
        ArrayList<String> classes = null;
        ClassNameTrie.Builder builder = new ClassNameTrie.Builder();
        for (String type : types = COMMA_PATTERN.split(redactedTypes)) {
            builder.put(type, 1);
            if (type.endsWith("*")) {
                if (packages == null) {
                    packages = new ArrayList<String>();
                }
                type = type.endsWith(".*") ? type.substring(0, type.length() - 2) : type.substring(0, type.length() - 1);
                packages.add(type);
                continue;
            }
            if (classes == null) {
                classes = new ArrayList<String>();
            }
            classes.add(type);
        }
        typeTrie = builder.buildTrie();
        redactedPackages = packages;
        redactedClasses = classes;
    }

    public static boolean isRedactedKeyword(String name) {
        if (name == null) {
            return false;
        }
        name = Redaction.normalize(name);
        return KEYWORDS.contains(name);
    }

    public static boolean isRedactedType(String className) {
        if (className == null) {
            return false;
        }
        return typeTrie.apply(className) > 0;
    }

    public static List<String> getRedactedPackages() {
        return redactedPackages != null ? redactedPackages : Collections.emptyList();
    }

    public static List<String> getRedactedClasses() {
        return redactedClasses != null ? redactedClasses : Collections.emptyList();
    }

    public static void clearUserDefinedTypes() {
        typeTrie = ClassNameTrie.Builder.EMPTY_TRIE;
    }

    public static void resetUserDefinedKeywords() {
        KEYWORDS.clear();
        KEYWORDS.addAll(PREDEFINED_KEYWORDS);
    }

    private static String normalize(String name) {
        StringBuilder sb = null;
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            boolean isUpper = Character.isUpperCase(c);
            boolean isRemovable = Redaction.isRemovableChar(c);
            if (!isUpper && !isRemovable && sb == null) continue;
            if (sb == null) {
                sb = new StringBuilder(name.substring(0, i));
            }
            if (isUpper) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            if (isRemovable) continue;
            sb.append(c);
        }
        return sb != null ? sb.toString() : name;
    }

    private static boolean isRemovableChar(char c) {
        return c == '_' || c == '-' || c == '$' || c == '@';
    }

    static {
        KEYWORDS.addAll(PREDEFINED_KEYWORDS);
    }
}

