/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import ddtrot.dd.communication.http.HttpRetryPolicy;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.trace.api.civisibility.InstrumentationBridge;
import ddtrot.dd.trace.api.civisibility.telemetry.CiVisibilityCountMetric;
import ddtrot.dd.trace.api.intake.TrackType;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteApi;
import ddtrot.dd.trace.common.writer.ddintake.TelemetryListener;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.Response;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.net.ConnectException;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DDEvpProxyApi
extends RemoteApi {
    private static final Logger log = LoggerFactory.getLogger(DDEvpProxyApi.class);
    private static final String DD_EVP_SUBDOMAIN_HEADER = "X-Datadog-EVP-Subdomain";
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String GZIP_CONTENT_TYPE = "gzip";
    private final TelemetryListener telemetryListener;
    private final TrackType trackType;
    private final OkHttpClient httpClient;
    private final HttpUrl proxiedApiUrl;
    private final String subdomain;
    private final HttpRetryPolicy.Factory retryPolicyFactory;

    public static DDEvpProxyApiBuilder builder() {
        return new DDEvpProxyApiBuilder();
    }

    private DDEvpProxyApi(TrackType trackType, OkHttpClient httpClient, HttpUrl proxiedApiUrl, String subdomain, HttpRetryPolicy.Factory retryPolicyFactory, boolean compressionEnabled) {
        super(compressionEnabled);
        this.telemetryListener = new TelemetryListener(trackType.endpoint);
        this.trackType = trackType;
        this.httpClient = httpClient;
        this.proxiedApiUrl = proxiedApiUrl;
        this.subdomain = subdomain;
        this.retryPolicyFactory = retryPolicyFactory;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public RemoteApi.Response sendSerializedTraces(Payload payload) {
        int sizeInBytes = payload.sizeInBytes();
        Request.Builder builder = new Request.Builder().url(this.proxiedApiUrl).addHeader(DD_EVP_SUBDOMAIN_HEADER, this.subdomain).tag(OkHttpUtils.CustomListener.class, this.telemetryListener);
        if (this.isCompressionEnabled()) {
            builder.addHeader(CONTENT_ENCODING_HEADER, GZIP_CONTENT_TYPE);
        }
        Request request = builder.post(payload.toRequest()).build();
        this.totalTraces += (long)payload.traceCount();
        this.receivedTraces += (long)payload.traceCount();
        HttpRetryPolicy retryPolicy = this.retryPolicyFactory.create();
        try (Response response2 = OkHttpUtils.sendWithRetries(this.httpClient, retryPolicy, request);){
            if (response2.isSuccessful()) {
                this.countAndLogSuccessfulSend(payload.traceCount(), sizeInBytes);
                RemoteApi.Response response3 = RemoteApi.Response.success(response2.code());
                return response3;
            }
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_DROPPED, 1L, this.trackType.endpoint);
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, response2, null);
            RemoteApi.Response response = RemoteApi.Response.failed(response2.code());
            return response;
        }
        catch (ConnectException e) {
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_DROPPED, 1L, this.trackType.endpoint);
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, null);
            return RemoteApi.Response.failed(e);
        }
        catch (IOException e) {
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_DROPPED, 1L, this.trackType.endpoint);
            this.countAndLogFailedSend(payload.traceCount(), sizeInBytes, null, e);
            return RemoteApi.Response.failed(e);
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    public static class DDEvpProxyApiBuilder {
        private String apiVersion = "v2";
        @NonNull
        private TrackType trackType = TrackType.NOOP;
        private long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        HttpUrl agentUrl = null;
        OkHttpClient httpClient = null;
        String evpProxyEndpoint;
        boolean compressionEnabled;

        public DDEvpProxyApiBuilder trackType(@NonNull TrackType trackType) {
            this.trackType = trackType;
            return this;
        }

        public DDEvpProxyApiBuilder apiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public DDEvpProxyApiBuilder evpProxyEndpoint(String evpProxyEndpoint) {
            this.evpProxyEndpoint = evpProxyEndpoint;
            return this;
        }

        public DDEvpProxyApiBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDEvpProxyApiBuilder agentUrl(HttpUrl agentUrl) {
            this.agentUrl = agentUrl;
            return this;
        }

        public DDEvpProxyApiBuilder httpClient(OkHttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public DDEvpProxyApiBuilder compressionEnabled(boolean compressionEnabled) {
            this.compressionEnabled = compressionEnabled;
            return this;
        }

        public DDEvpProxyApi build() {
            String trackName = this.trackType.name().toLowerCase(Locale.ROOT);
            String subdomain = String.format("%s-intake", trackName);
            HttpUrl evpProxyUrl = this.agentUrl.resolve(this.evpProxyEndpoint);
            HttpUrl proxiedApiUrl = evpProxyUrl.resolve(String.format("api/%s/%s", this.apiVersion, trackName));
            OkHttpClient client = this.httpClient != null ? this.httpClient : OkHttpUtils.buildHttpClient(proxiedApiUrl, this.timeoutMillis);
            HttpRetryPolicy.Factory retryPolicyFactory = new HttpRetryPolicy.Factory(5, 100, 2.0);
            log.debug("proxiedApiUrl: {}", (Object)proxiedApiUrl);
            return new DDEvpProxyApi(this.trackType, client, proxiedApiUrl, subdomain, retryPolicyFactory, this.compressionEnabled);
        }
    }
}

