/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.flare;

import datadog.trace.api.Config;
import datadog.trace.api.DynamicConfig;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.trace.api.flare.TracerFlare;
import ddtrot.dd.trace.core.CoreTracer;
import ddtrot.dd.trace.core.DDTraceCoreInfo;
import ddtrot.dd.trace.logging.GlobalLogLevelSwitcher;
import ddtrot.dd.trace.logging.LogLevel;
import ddtrot.dd.trace.util.AgentTaskScheduler;
import ddtrot.dd.trace.util.AgentThreadFactory;
import ddtrot.dd.trace.util.Strings;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.MediaType;
import ddtrot.okhttp3.MultipartBody;
import ddtrot.okhttp3.OkHttpClient;
import ddtrot.okhttp3.Request;
import ddtrot.okhttp3.RequestBody;
import ddtrot.okhttp3.Response;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TracerFlareService {
    private static final Logger log = LoggerFactory.getLogger(TracerFlareService.class);
    private static final String FLARE_ENDPOINT = "tracer_flare/v1";
    private static final String REPORT_PREFIX = "dd-java-flare-";
    private static final MediaType OCTET_STREAM = MediaType.get("application/octet-stream");
    private static final Pattern DELAY_TRIGGER = Pattern.compile("(\\d+)([HhMmSs]?)");
    private final AgentTaskScheduler scheduler = new AgentTaskScheduler(AgentThreadFactory.AgentThread.TRACER_FLARE);
    private final Config config;
    private final DynamicConfig<?> dynamicConfig;
    private final OkHttpClient okHttpClient;
    private final HttpUrl flareUrl;
    private final CoreTracer tracer;
    private boolean logLevelOverridden;
    private volatile long flareStartMillis;
    private AgentTaskScheduler.Scheduled<Runnable> scheduledCleanup;

    TracerFlareService(Config config, DynamicConfig<?> dynamicConfig, OkHttpClient okHttpClient, HttpUrl agentUrl, CoreTracer tracer) {
        this.config = config;
        this.dynamicConfig = dynamicConfig;
        this.okHttpClient = okHttpClient;
        this.flareUrl = agentUrl.newBuilder().addPathSegments(FLARE_ENDPOINT).build();
        this.tracer = tracer;
        this.applyTriageReportTrigger(config.getTriageReportTrigger());
    }

    private void applyTriageReportTrigger(String triageTrigger) {
        if (null != triageTrigger && !triageTrigger.isEmpty()) {
            Matcher delayMatcher = DELAY_TRIGGER.matcher(triageTrigger);
            if (delayMatcher.matches()) {
                long delay = Integer.parseInt(delayMatcher.group(1));
                String unit = delayMatcher.group(2);
                if ("H".equalsIgnoreCase(unit)) {
                    delay = TimeUnit.HOURS.toSeconds(delay);
                } else if ("M".equalsIgnoreCase(unit)) {
                    delay = TimeUnit.MINUTES.toSeconds(delay);
                }
                this.scheduleTriageReport(delay);
            } else {
                log.info("Unrecognized triage trigger {}", (Object)triageTrigger);
            }
        }
    }

    private void scheduleTriageReport(long delayInSeconds) {
        Path triagePath = Paths.get(this.config.getTriageReportDir(), new String[0]);
        this.scheduler.schedule(() -> this.prepareForFlare("triage"), delayInSeconds - 600L, TimeUnit.SECONDS);
        this.scheduler.schedule(() -> {
            try {
                if (!Files.isDirectory(triagePath, new LinkOption[0])) {
                    Files.createDirectories(triagePath, new FileAttribute[0]);
                }
                long flareEndMillis = System.currentTimeMillis();
                Path reportPath = triagePath.resolve(this.getFlareName(flareEndMillis));
                log.info("Writing triage report to {}", (Object)reportPath);
                Files.write(reportPath, this.buildFlareZip(this.flareStartMillis, flareEndMillis, true), new OpenOption[0]);
            }
            catch (Throwable e) {
                log.info("Problem writing triage report", e);
            }
            finally {
                this.cleanupAfterFlare();
            }
        }, delayInSeconds, TimeUnit.SECONDS);
    }

    public synchronized void prepareForFlare(String logLevel) {
        AgentTaskScheduler.Scheduled<Runnable> oldSchedule;
        if (!log.isDebugEnabled() && "debug".equalsIgnoreCase(logLevel)) {
            GlobalLogLevelSwitcher.get().switchLevel(LogLevel.DEBUG);
            this.logLevelOverridden = true;
        }
        if (null != (oldSchedule = this.scheduledCleanup)) {
            oldSchedule.cancel();
        } else {
            this.flareStartMillis = System.currentTimeMillis();
            log.debug("Preparing for tracer flare, logLevel={}", (Object)logLevel);
            TracerFlare.prepareForFlare();
        }
        this.scheduledCleanup = this.scheduler.schedule(new CleanupTask(), 20L, TimeUnit.MINUTES);
    }

    public void cleanupAfterFlare() {
        this.doCleanup(null);
    }

    synchronized void doCleanup(CleanupTask fromTask) {
        AgentTaskScheduler.Scheduled<Runnable> oldSchedule = this.scheduledCleanup;
        if (null != oldSchedule) {
            if (null == fromTask) {
                oldSchedule.cancel();
            } else if (oldSchedule.get() != fromTask) {
                return;
            }
            this.flareStartMillis = 0L;
            this.scheduledCleanup = null;
            log.debug("Cleaning up after tracer flare");
            TracerFlare.cleanupAfterFlare();
            if (this.logLevelOverridden) {
                GlobalLogLevelSwitcher.get().restore();
                this.logLevelOverridden = false;
            }
        }
    }

    public void sendFlare(String caseId, String email, String hostname) {
        boolean dumpThreads = this.config.isTriageEnabled() || log.isDebugEnabled();
        this.scheduler.execute(() -> this.doSend(caseId, email, hostname, dumpThreads));
    }

    void doSend(String caseId, String email, String hostname, boolean dumpThreads) {
        log.debug("Sending tracer flare");
        try {
            long flareEndMillis = System.currentTimeMillis();
            RequestBody report = RequestBody.create(OCTET_STREAM, this.buildFlareZip(this.flareStartMillis, flareEndMillis, dumpThreads));
            MultipartBody form = new MultipartBody.Builder().setType(MultipartBody.FORM).addFormDataPart("source", "tracer_java").addFormDataPart("case_id", caseId).addFormDataPart("email", email).addFormDataPart("hostname", hostname).addFormDataPart("flare_file", this.getFlareName(flareEndMillis), report).build();
            Request flareRequest = OkHttpUtils.prepareRequest(this.flareUrl, Collections.emptyMap()).post(form).build();
            try (Response response = this.okHttpClient.newCall(flareRequest).execute();){
                if (response.code() == 404) {
                    log.debug("Tracer flare endpoint is disabled, ignoring request");
                } else if (!response.isSuccessful()) {
                    log.warn("Tracer flare failed with: {} {}", (Object)response.code(), (Object)response.message());
                } else {
                    log.debug("Tracer flare sent successfully");
                }
            }
        }
        catch (IOException e) {
            log.warn("Tracer flare failed with exception: {}", (Object)e.toString());
        }
    }

    private String getFlareName(long endMillis) {
        return REPORT_PREFIX + this.config.getRuntimeId() + "-" + endMillis + ".zip";
    }

    /*
     * Exception decompiling
     */
    private byte[] buildFlareZip(long startMillis, long endMillis, boolean dumpThreads) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addPrelude(ZipOutputStream zip, long startMillis, long endMillis) throws IOException {
        TracerFlare.addText(zip, "flare_info.txt", this.flareInfo(startMillis, endMillis));
        TracerFlare.addText(zip, "tracer_version.txt", DDTraceCoreInfo.VERSION);
    }

    private void addConfig(ZipOutputStream zip) throws IOException {
        TracerFlare.addText(zip, "initial_config.txt", this.config.toString());
        TracerFlare.addText(zip, "dynamic_config.txt", this.dynamicConfig.toString());
    }

    private void addRuntime(ZipOutputStream zip) throws IOException {
        try {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            TracerFlare.addText(zip, "jvm_args.txt", Strings.join((CharSequence)" ", runtimeMXBean.getInputArguments()));
            TracerFlare.addText(zip, "classpath.txt", runtimeMXBean.getClassPath());
            TracerFlare.addText(zip, "library_path.txt", runtimeMXBean.getLibraryPath());
            if (runtimeMXBean.isBootClassPathSupported()) {
                TracerFlare.addText(zip, "boot_classpath.txt", runtimeMXBean.getBootClassPath());
            }
        }
        catch (RuntimeException e) {
            TracerFlare.addText(zip, "classpath.txt", System.getProperty("java.class.path"));
        }
    }

    private String flareInfo(long startMillis, long endMillis) {
        StringBuilder buf = new StringBuilder();
        if (startMillis > 0L) {
            buf.append("Requested: ").append(TracerFlareService.toDateTime(startMillis)).append('\n');
        }
        return buf.append("Completed: ").append(TracerFlareService.toDateTime(endMillis)).toString();
    }

    private static ZonedDateTime toDateTime(long millis) {
        return ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneOffset.UTC);
    }

    private void addThreadDump(ZipOutputStream zip) throws IOException {
        StringBuilder buf = new StringBuilder();
        try {
            ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
            for (ThreadInfo threadInfo : threadMXBean.dumpAllThreads(threadMXBean.isObjectMonitorUsageSupported(), threadMXBean.isSynchronizerUsageSupported())) {
                buf.append(threadInfo);
            }
        }
        catch (RuntimeException e) {
            buf.append("Problem collecting thread dump: ").append(e);
        }
        TracerFlare.addText(zip, "threads.txt", buf.toString());
    }

    final class CleanupTask
    implements Runnable {
        CleanupTask() {
        }

        @Override
        public void run() {
            TracerFlareService.this.doCleanup(this);
        }
    }
}

