/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.api;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class URIUtils {
    private static final byte[] REPLACEMENT = new byte[]{-17, -65, -67};
    private static final Logger LOGGER = LoggerFactory.getLogger(URIUtils.class);

    private URIUtils() {
    }

    public static String decode(String encoded) {
        return URIUtils.decode(encoded, false);
    }

    public static String decode(String encoded, boolean plusToSpace) {
        if (encoded == null) {
            return null;
        }
        int len = encoded.length();
        if (len == 0) {
            return encoded;
        }
        if (!(encoded.indexOf(37) >= 0 || plusToSpace && encoded.indexOf(43) >= 0)) {
            return encoded;
        }
        ByteBuffer bb = ByteBuffer.allocate(len + 2);
        for (int i = 0; i < len; ++i) {
            int c = encoded.charAt(i);
            if (c == 37) {
                if (i + 2 < len) {
                    int l;
                    int h = Character.digit(encoded.charAt(i + 1), 16);
                    if ((h | (l = Character.digit(encoded.charAt(i + 2), 16))) < 0) {
                        bb.put(REPLACEMENT[0]);
                        bb.put(REPLACEMENT[1]);
                        bb.put(REPLACEMENT[2]);
                    } else {
                        bb.put((byte)((h << 4) + l));
                    }
                    i += 2;
                    continue;
                }
                bb.put(REPLACEMENT[0]);
                bb.put(REPLACEMENT[1]);
                bb.put(REPLACEMENT[2]);
                i = len;
                continue;
            }
            if (plusToSpace && c == 43) {
                c = 32;
            }
            bb.put((byte)c);
        }
        bb.flip();
        return new String(bb.array(), 0, bb.limit(), StandardCharsets.UTF_8);
    }

    public static String buildURL(String scheme, String host, int port, String path) {
        int length = 0;
        length += null == scheme ? 0 : scheme.length() + 3;
        if (null != host) {
            length += host.length();
            if (port > 0 && port != 80 && port != 443) {
                length += 6;
            }
        }
        if (null == path || path.isEmpty()) {
            ++length;
        } else {
            if (path.charAt(0) != '/') {
                ++length;
            }
            length += path.length();
        }
        StringBuilder urlNoParams = new StringBuilder(length);
        if (scheme != null) {
            urlNoParams.append(scheme);
            urlNoParams.append("://");
        }
        if (host != null) {
            urlNoParams.append(host);
            if (!(port <= 0 || port == 80 && "http".equals(scheme) || port == 443 && "https".equals(scheme))) {
                urlNoParams.append(':');
                urlNoParams.append(port);
            }
        }
        if (null == path || path.isEmpty()) {
            urlNoParams.append('/');
        } else {
            if (path.charAt(0) != '/' && urlNoParams.length() > 0) {
                urlNoParams.append('/');
            }
            urlNoParams.append(path);
        }
        return urlNoParams.toString();
    }

    public static URI safeParse(String unparsed) {
        if (unparsed == null) {
            return null;
        }
        try {
            return URI.create(unparsed);
        }
        catch (IllegalArgumentException exception) {
            LOGGER.debug("Unable to parse request uri {}", (Object)unparsed, (Object)exception);
            return null;
        }
    }

    public static LazyUrl lazyValidURL(String scheme, String host, int port, String path) {
        return new ValidUrl(scheme, host, port, path);
    }

    public static LazyUrl lazyInvalidUrl(String raw) {
        return new InvalidUrl(raw);
    }

    public static String urlFileName(String raw) {
        try {
            int nameEnd;
            URL url = new URL(raw);
            String path = url.getPath();
            for (nameEnd = path.length() - 1; nameEnd >= 0 && path.charAt(nameEnd) == '/'; --nameEnd) {
            }
            if (nameEnd < 0) {
                return "";
            }
            String name = path.substring(path.lastIndexOf(47, nameEnd) + 1, nameEnd + 1);
            return name;
        }
        catch (MalformedURLException e) {
            return "";
        }
    }

    public static URI safeConcat(String schemeHostPort, String theRest) {
        String part2;
        if (schemeHostPort == null && theRest == null) {
            return null;
        }
        String part1 = schemeHostPort != null ? schemeHostPort : "";
        String string = part2 = theRest != null ? theRest : "";
        if (part2.startsWith(part1)) {
            return URIUtils.safeParse(part2);
        }
        boolean addSlash = !part2.startsWith("/") && !part1.endsWith("/");
        StringBuilder sb = new StringBuilder(part1.length() + part2.length() + (addSlash ? 1 : 0));
        sb.append(part1);
        if (addSlash) {
            sb.append("/");
        }
        sb.append(part2);
        return URIUtils.safeParse(sb.toString());
    }

    private static class InvalidUrl
    extends LazyUrl {
        public InvalidUrl(String raw) {
            super(String.valueOf(raw));
        }

        @Override
        public String path() {
            return null;
        }

        @Override
        public String get() {
            return this.lazy;
        }
    }

    private static class ValidUrl
    extends LazyUrl {
        private final String scheme;
        private final String host;
        private final int port;
        private final String path;

        private ValidUrl(String scheme, String host, int port, String path) {
            super(null);
            this.scheme = scheme;
            this.host = host;
            this.port = port;
            this.path = null == path || path.isEmpty() ? "" : path;
        }

        @Override
        public String path() {
            return this.path;
        }

        @Override
        public String get() {
            String res = this.lazy;
            return res != null ? res : URIUtils.buildURL(this.scheme, this.host, this.port, this.path);
        }
    }

    public static abstract class LazyUrl
    implements CharSequence,
    Supplier<String> {
        protected String lazy;

        protected LazyUrl(String lazy) {
            this.lazy = lazy;
        }

        public abstract String path();

        @Override
        public String toString() {
            String str = this.lazy;
            if (str == null) {
                str = this.lazy = (String)this.get();
            }
            return str;
        }

        @Override
        public int length() {
            return this.toString().length();
        }

        @Override
        public char charAt(int index) {
            return this.toString().charAt(index);
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return this.toString().subSequence(start, end);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }
    }
}

