/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.iast;

import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTracer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IastContext {
    @Nonnull
    public <TO> TO getTaintedObjects();

    public static abstract class Provider {
        private static Provider INSTANCE;

        public static void register(@Nonnull Provider instance) {
            INSTANCE = instance;
        }

        @Nullable
        public abstract IastContext resolve();

        public abstract IastContext buildRequestContext();

        public abstract void releaseRequestContext(@Nonnull IastContext var1);

        @Nullable
        public static IastContext get() {
            if (INSTANCE == null) {
                return Provider.get(AgentTracer.activeSpan());
            }
            return INSTANCE.resolve();
        }

        @Nullable
        public static IastContext get(@Nullable AgentSpan span) {
            if (span == null) {
                return null;
            }
            return Provider.get(span.getRequestContext());
        }

        @Nullable
        public static IastContext get(@Nullable RequestContext reqCtx) {
            if (reqCtx == null) {
                return null;
            }
            return (IastContext)reqCtx.getData(RequestContextSlot.IAST);
        }
    }

    public static enum Mode {
        GLOBAL,
        REQUEST;

    }
}

