/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import datadog.trace.api.Config;
import datadog.trace.api.DynamicConfig;
import ddtrot.com.squareup.moshi.Json;
import ddtrot.com.squareup.moshi.JsonAdapter;
import ddtrot.com.squareup.moshi.Moshi;
import ddtrot.dd.communication.ddagent.SharedCommunicationObjects;
import ddtrot.dd.remoteconfig.ConfigurationChangesListener;
import ddtrot.dd.remoteconfig.ConfigurationPoller;
import ddtrot.dd.remoteconfig.Product;
import ddtrot.dd.remoteconfig.state.ParsedConfigKey;
import ddtrot.dd.remoteconfig.state.ProductListener;
import ddtrot.dd.trace.logging.GlobalLogLevelSwitcher;
import ddtrot.dd.trace.logging.LogLevel;
import ddtrot.okio.Okio;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TracingConfigPoller {
    private static final Logger log = LoggerFactory.getLogger(TracingConfigPoller.class);
    private final DynamicConfig<?> dynamicConfig;
    private boolean startupLogsEnabled;
    private Runnable stopPolling;

    public TracingConfigPoller(DynamicConfig<?> dynamicConfig) {
        this.dynamicConfig = dynamicConfig;
    }

    public void start(Config config, SharedCommunicationObjects sco) {
        this.startupLogsEnabled = config.isStartupLogsEnabled();
        ConfigurationPoller configPoller = sco.configurationPoller(config);
        if (configPoller != null) {
            configPoller.addCapabilities(0x10F000L);
        }
        this.stopPolling = new Updater().register(config, configPoller);
    }

    public void stop() {
        if (null != this.stopPolling) {
            this.stopPolling.run();
        }
    }

    void applyConfigOverrides(LibConfig libConfig) {
        DynamicConfig.Builder builder = this.dynamicConfig.initial();
        if (libConfig.debugEnabled != null) {
            if (Boolean.TRUE.equals(libConfig.debugEnabled)) {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.DEBUG);
            } else if (this.startupLogsEnabled) {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.INFO);
            } else {
                GlobalLogLevelSwitcher.get().switchLevel(LogLevel.WARN);
            }
        } else {
            GlobalLogLevelSwitcher.get().restore();
        }
        this.maybeOverride(builder::setRuntimeMetricsEnabled, libConfig.runtimeMetricsEnabled);
        this.maybeOverride(builder::setLogsInjectionEnabled, libConfig.logsInjectionEnabled);
        this.maybeOverride(builder::setDataStreamsEnabled, libConfig.dataStreamsEnabled);
        this.maybeOverride(builder::setServiceMapping, libConfig.serviceMapping);
        this.maybeOverride(builder::setHeaderTags, libConfig.headerTags);
        this.maybeOverride(builder::setTraceSampleRate, libConfig.traceSampleRate);
        this.maybeOverride(builder::setTracingTags, this.parseTagListToMap(libConfig.tracingTags));
        builder.apply();
    }

    void removeConfigOverrides() {
        this.dynamicConfig.resetTraceConfig();
        GlobalLogLevelSwitcher.get().restore();
    }

    private <T> void maybeOverride(Consumer<T> setter, T override) {
        if (null != override) {
            setter.accept(override);
        }
    }

    private Map<String, String> parseTagListToMap(List<String> input) {
        Map<String, String> resultMap = Collections.emptyMap();
        if (null == input || input.isEmpty()) {
            return resultMap;
        }
        resultMap = new HashMap<String, String>(input.size());
        for (String s : input) {
            int colonIndex = s.indexOf(":");
            if (colonIndex <= -1 || colonIndex >= s.length() - 1) continue;
            String key = s.substring(0, colonIndex);
            String value = s.substring(colonIndex + 1);
            if (key.isEmpty() || value.isEmpty()) continue;
            resultMap.put(key, value);
        }
        return resultMap;
    }

    static final class HeaderTagEntry
    implements Map.Entry<String, String> {
        @Json(name="header")
        public String header;
        @Json(name="tag_name")
        public String tagName;

        HeaderTagEntry() {
        }

        @Override
        public String getKey() {
            return this.header;
        }

        @Override
        public String getValue() {
            return this.tagName;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class ServiceMappingEntry
    implements Map.Entry<String, String> {
        @Json(name="from_key")
        public String fromKey;
        @Json(name="to_name")
        public String toName;

        ServiceMappingEntry() {
        }

        @Override
        public String getKey() {
            return this.fromKey;
        }

        @Override
        public String getValue() {
            return this.toName;
        }

        @Override
        public String setValue(String value) {
            throw new UnsupportedOperationException();
        }
    }

    static final class LibConfig {
        @Json(name="tracing_debug")
        public Boolean debugEnabled;
        @Json(name="runtime_metrics_enabled")
        public Boolean runtimeMetricsEnabled;
        @Json(name="log_injection_enabled")
        public Boolean logsInjectionEnabled;
        @Json(name="data_streams_enabled")
        public Boolean dataStreamsEnabled;
        @Json(name="tracing_service_mapping")
        public List<ServiceMappingEntry> serviceMapping;
        @Json(name="tracing_header_tags")
        public List<HeaderTagEntry> headerTags;
        @Json(name="tracing_sampling_rate")
        public Double traceSampleRate;
        @Json(name="tracing_tags")
        public List<String> tracingTags;

        LibConfig() {
        }
    }

    static final class ServiceTarget {
        @Json(name="service")
        public String service;
        @Json(name="env")
        public String env;

        ServiceTarget() {
        }
    }

    static final class ConfigOverrides {
        @Json(name="service_target")
        public ServiceTarget serviceTarget;
        @Json(name="lib_config")
        public LibConfig libConfig;

        ConfigOverrides() {
        }
    }

    final class Updater
    implements ProductListener {
        private final JsonAdapter<ConfigOverrides> CONFIG_OVERRIDES_ADAPTER;
        private boolean receivedOverrides;

        Updater() {
            Moshi MOSHI = new Moshi.Builder().build();
            this.CONFIG_OVERRIDES_ADAPTER = MOSHI.adapter(ConfigOverrides.class);
            this.receivedOverrides = false;
        }

        public Runnable register(Config config, ConfigurationPoller poller) {
            if (null != poller) {
                poller.addListener(Product.APM_TRACING, (ProductListener)this);
                return () -> ((ConfigurationPoller)poller).stop();
            }
            return null;
        }

        public void accept(ParsedConfigKey configKey, byte[] content, ConfigurationChangesListener.PollingRateHinter hinter) throws IOException {
            ConfigOverrides overrides = this.CONFIG_OVERRIDES_ADAPTER.fromJson(Okio.buffer(Okio.source(new ByteArrayInputStream(content))));
            if (null != overrides && null != overrides.libConfig) {
                ServiceTarget serviceTarget = overrides.serviceTarget;
                if (serviceTarget != null) {
                    String targetService = serviceTarget.service;
                    String thisService = Config.get().getServiceName();
                    if (targetService != null && !targetService.equalsIgnoreCase(thisService)) {
                        log.debug("Skipping config for service {}. Current service is {}", (Object)targetService, (Object)thisService);
                        throw new IllegalArgumentException("service mismatch");
                    }
                    String targetEnv = serviceTarget.env;
                    String thisEnv = Config.get().getEnv();
                    if (targetEnv != null && !targetEnv.equalsIgnoreCase(thisEnv)) {
                        log.debug("Skipping config for env {}. Current env is {}", (Object)targetEnv, (Object)thisEnv);
                        throw new IllegalArgumentException("env mismatch");
                    }
                }
                this.receivedOverrides = true;
                TracingConfigPoller.this.applyConfigOverrides(overrides.libConfig);
                if (log.isDebugEnabled()) {
                    log.debug("Applied APM_TRACING overrides: {}", (Object)this.CONFIG_OVERRIDES_ADAPTER.toJson(overrides));
                }
            } else {
                log.debug("No APM_TRACING overrides");
            }
        }

        public void remove(ParsedConfigKey configKey, ConfigurationChangesListener.PollingRateHinter hinter) {
        }

        public void commit(ConfigurationChangesListener.PollingRateHinter hinter) {
            if (!this.receivedOverrides) {
                TracingConfigPoller.this.removeConfigOverrides();
                log.debug("Removed APM_TRACING overrides");
            } else {
                this.receivedOverrides = false;
            }
        }
    }
}

