/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer.ddintake;

import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.trace.api.civisibility.InstrumentationBridge;
import ddtrot.dd.trace.api.civisibility.telemetry.CiVisibilityCountMetric;
import ddtrot.dd.trace.api.civisibility.telemetry.CiVisibilityDistributionMetric;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.Endpoint;
import ddtrot.dd.trace.api.civisibility.telemetry.tag.ErrorType;
import ddtrot.okhttp3.Call;
import ddtrot.okhttp3.Response;
import java.io.IOException;

public class TelemetryListener
extends OkHttpUtils.CustomListener {
    private final Endpoint endpoint;
    private long callStartTimestamp;

    public TelemetryListener(Endpoint endpoint) {
        this.endpoint = endpoint;
    }

    @Override
    public void callStart(Call call) {
        this.callStartTimestamp = System.currentTimeMillis();
        InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_REQUESTS, 1L, this.endpoint);
    }

    @Override
    public void requestBodyEnd(Call call, long byteCount) {
        InstrumentationBridge.getMetricCollector().add(CiVisibilityDistributionMetric.ENDPOINT_PAYLOAD_BYTES, (int)byteCount, this.endpoint);
    }

    @Override
    public void responseHeadersEnd(Call call, Response response) {
        if (!response.isSuccessful()) {
            int responseCode = response.code();
            InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_REQUESTS_ERRORS, 1L, this.endpoint, ErrorType.from(responseCode));
        }
    }

    @Override
    public void callEnd(Call call) {
        int durationMillis = (int)(System.currentTimeMillis() - this.callStartTimestamp);
        InstrumentationBridge.getMetricCollector().add(CiVisibilityDistributionMetric.ENDPOINT_PAYLOAD_REQUESTS_MS, durationMillis, this.endpoint);
    }

    @Override
    public void callFailed(Call call, IOException ioe) {
        int durationMillis = (int)(System.currentTimeMillis() - this.callStartTimestamp);
        InstrumentationBridge.getMetricCollector().add(CiVisibilityDistributionMetric.ENDPOINT_PAYLOAD_REQUESTS_MS, durationMillis, this.endpoint);
        InstrumentationBridge.getMetricCollector().add(CiVisibilityCountMetric.ENDPOINT_PAYLOAD_REQUESTS_ERRORS, 1L, this.endpoint, ErrorType.NETWORK);
    }
}

