/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.com.timgroup.statsd;

import ddtrot.com.timgroup.statsd.Message;
import ddtrot.com.timgroup.statsd.StatsDClientErrorHandler;
import ddtrot.com.timgroup.statsd.StatsDProcessor;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class StatsDBlockingProcessor
extends StatsDProcessor {
    private final BlockingQueue<Message> messages;

    StatsDBlockingProcessor(int queueSize, StatsDClientErrorHandler handler, int maxPacketSizeBytes, int poolSize, int workers, int aggregatorFlushInterval, int aggregatorShards, ThreadFactory threadFactory, String containerID) throws Exception {
        super(queueSize, handler, maxPacketSizeBytes, poolSize, workers, aggregatorFlushInterval, aggregatorShards, threadFactory, containerID);
        this.messages = new ArrayBlockingQueue<Message>(queueSize);
    }

    @Override
    protected ProcessingTask createProcessingTask() {
        return new ProcessingTask();
    }

    @Override
    protected boolean send(Message message) {
        try {
            if (!this.shutdown) {
                this.messages.put(message);
                return true;
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return false;
    }

    private class ProcessingTask
    extends StatsDProcessor.ProcessingTask {
        private ProcessingTask() {
        }

        @Override
        protected Message getMessage() throws InterruptedException {
            return (Message)StatsDBlockingProcessor.this.messages.poll(10L, TimeUnit.MILLISECONDS);
        }

        @Override
        protected boolean haveMessages() {
            return !StatsDBlockingProcessor.this.messages.isEmpty();
        }
    }
}

