/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.civisibility.coverage;

import ddtrot.dd.trace.api.civisibility.InstrumentationTestBridge;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageDataSupplier;
import ddtrot.dd.trace.api.civisibility.coverage.CoverageProbeStore;
import ddtrot.dd.trace.api.civisibility.domain.TestContext;

public abstract class CoverageBridge {
    private static final ThreadLocal<CoverageProbeStore> COVERAGE_PROBE_STORE = new ThreadLocal();
    private static volatile CoverageProbeStore.Registry COVERAGE_PROBE_STORE_REGISTRY;
    private static volatile CoverageDataSupplier COVERAGE_DATA_SUPPLIER;

    public static void registerCoverageProbeStoreRegistry(CoverageProbeStore.Registry coverageProbeStoreRegistry) {
        COVERAGE_PROBE_STORE_REGISTRY = coverageProbeStoreRegistry;
    }

    public static CoverageProbeStore.Registry getCoverageProbeStoreRegistry() {
        return COVERAGE_PROBE_STORE_REGISTRY;
    }

    public static void registerCoverageDataSupplier(CoverageDataSupplier coverageDataSupplier) {
        COVERAGE_DATA_SUPPLIER = coverageDataSupplier;
    }

    public static byte[] getCoverageData() {
        return COVERAGE_DATA_SUPPLIER != null ? COVERAGE_DATA_SUPPLIER.get() : null;
    }

    public static void setThreadLocalCoverageProbeStore(CoverageProbeStore probes) {
        COVERAGE_PROBE_STORE.set(probes);
    }

    public static void removeThreadLocalCoverageProbeStore() {
        COVERAGE_PROBE_STORE.remove();
    }

    public static void currentCoverageProbeStoreRecord(Class<?> clazz, long classId, int probeId) {
        CoverageProbeStore probes = COVERAGE_PROBE_STORE.get();
        if (probes != null) {
            probes.record(clazz, classId, probeId);
        } else {
            probes = CoverageBridge.getCurrentCoverageProbeStore();
            if (probes != null) {
                probes.record(clazz, classId, probeId);
            }
        }
    }

    public static void currentCoverageProbeStoreRecord(Class<?> clazz) {
        CoverageProbeStore probes = COVERAGE_PROBE_STORE.get();
        if (probes != null) {
            probes.record(clazz);
        } else {
            probes = CoverageBridge.getCurrentCoverageProbeStore();
            if (probes != null) {
                probes.record(clazz);
            }
        }
    }

    public static void currentCoverageProbeStoreRecordNonCode(String absolutePath) {
        CoverageProbeStore probes = COVERAGE_PROBE_STORE.get();
        if (probes != null) {
            probes.recordNonCodeResource(absolutePath);
        } else {
            probes = CoverageBridge.getCurrentCoverageProbeStore();
            if (probes != null) {
                probes.recordNonCodeResource(absolutePath);
            }
        }
    }

    private static CoverageProbeStore getCurrentCoverageProbeStore() {
        TestContext currentTest = InstrumentationTestBridge.getCurrentTestContext();
        if (currentTest != null) {
            return currentTest.getCoverageProbeStore();
        }
        return null;
    }
}

