/*
 * Decompiled with CFR 0.152.
 */
package datadog.trace.api;

import datadog.trace.api.ConfigOrigin;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class ConfigSetting {
    public final String key;
    public final Object value;
    public final ConfigOrigin origin;
    private static final Set<String> CONFIG_FILTER_LIST = new HashSet<String>(Arrays.asList("DD_API_KEY", "dd.api-key", "dd.profiling.api-key", "dd.profiling.apikey"));

    public static ConfigSetting of(String key, Object value, ConfigOrigin origin) {
        return new ConfigSetting(key, value, origin);
    }

    private ConfigSetting(String key, Object value, ConfigOrigin origin) {
        this.key = key;
        this.value = CONFIG_FILTER_LIST.contains(key) ? "<hidden>" : value;
        this.origin = origin;
    }

    public String normalizedKey() {
        return this.key.toLowerCase().replace(".", "_");
    }

    public String stringValue() {
        if (this.value == null) {
            return null;
        }
        if (this.value instanceof BitSet) {
            return ConfigSetting.renderIntegerRange((BitSet)this.value);
        }
        if (this.value instanceof Map) {
            return ConfigSetting.renderMap((Map)this.value);
        }
        if (this.value instanceof Iterable) {
            return ConfigSetting.renderIterable((Iterable)this.value);
        }
        return this.value.toString();
    }

    private static String renderIntegerRange(BitSet bitset) {
        StringBuilder sb = new StringBuilder();
        int start = 0;
        while ((start = bitset.nextSetBit(start)) >= 0) {
            int end = bitset.nextClearBit(start);
            if (sb.length() > 0) {
                sb.append(',');
            }
            if (start < end - 1) {
                sb.append(start);
                sb.append('-');
                sb.append(end);
            } else {
                sb.append(start);
            }
            start = end;
        }
        return sb.toString();
    }

    private static String renderMap(Map<Object, Object> merged) {
        StringBuilder result = new StringBuilder();
        for (Map.Entry<Object, Object> entry : merged.entrySet()) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(entry.getKey());
            result.append(':');
            result.append(entry.getValue());
        }
        return result.toString();
    }

    private static String renderIterable(Iterable iterable) {
        StringBuilder result = new StringBuilder();
        for (Object entry : iterable) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(entry);
        }
        return result.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigSetting that = (ConfigSetting)o;
        return this.key.equals(that.key) && Objects.equals(this.value, that.value) && this.origin == that.origin;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.key, this.value, this.origin});
    }

    public String toString() {
        return "ConfigSetting{key='" + this.normalizedKey() + '\'' + ", value=" + this.stringValue() + ", origin=" + (Object)((Object)this.origin) + '}';
    }
}

