/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.metrics;

import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;

public final class MetricKey {
    private final UTF8BytesString resource;
    private final UTF8BytesString service;
    private final UTF8BytesString operationName;
    private final UTF8BytesString type;
    private final int httpStatusCode;
    private final boolean synthetics;
    private final int hash;

    public MetricKey(CharSequence resource, CharSequence service, CharSequence operationName, CharSequence type, int httpStatusCode, boolean synthetics) {
        this.resource = null == resource ? UTF8BytesString.EMPTY : UTF8BytesString.create(resource);
        this.service = null == service ? UTF8BytesString.EMPTY : UTF8BytesString.create(service);
        this.operationName = null == operationName ? UTF8BytesString.EMPTY : UTF8BytesString.create(operationName);
        this.type = null == type ? UTF8BytesString.EMPTY : UTF8BytesString.create(type);
        this.httpStatusCode = httpStatusCode;
        this.synthetics = synthetics;
        this.hash = 28629151 * this.resource.hashCode() + 923521 * this.service.hashCode() + 29791 * this.operationName.hashCode() + 961 * this.type.hashCode() + 31 * httpStatusCode + (this.synthetics ? 1 : 0);
    }

    public UTF8BytesString getResource() {
        return this.resource;
    }

    public UTF8BytesString getService() {
        return this.service;
    }

    public UTF8BytesString getOperationName() {
        return this.operationName;
    }

    public UTF8BytesString getType() {
        return this.type;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public boolean isSynthetics() {
        return this.synthetics;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof MetricKey) {
            MetricKey metricKey = (MetricKey)o;
            return this.hash == metricKey.hash && this.synthetics == metricKey.synthetics && this.httpStatusCode == metricKey.httpStatusCode && this.resource.equals(metricKey.resource) && this.service.equals(metricKey.service) && this.operationName.equals(metricKey.operationName) && this.type.equals(metricKey.type);
        }
        return false;
    }

    public int hashCode() {
        return this.hash;
    }
}

