/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import java.util.concurrent.atomic.AtomicInteger;

public class SchemaSampler {
    private static final int SAMPLE_INTERVAL_MILLIS = 30000;
    private final AtomicInteger weight = new AtomicInteger(0);
    private volatile long lastSampleMillis = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int trySample(long currentTimeMillis) {
        this.weight.incrementAndGet();
        if (currentTimeMillis >= this.lastSampleMillis + 30000L) {
            SchemaSampler schemaSampler = this;
            synchronized (schemaSampler) {
                if (currentTimeMillis >= this.lastSampleMillis + 30000L) {
                    this.lastSampleMillis = currentTimeMillis;
                    int currentWeight = this.weight.get();
                    this.weight.set(0);
                    return currentWeight;
                }
            }
        }
        return 0;
    }

    public boolean canSample(long currentTimeMillis) {
        return currentTimeMillis >= this.lastSampleMillis + 30000L;
    }
}

