/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.propagation;

import datadog.trace.api.Config;
import datadog.trace.api.DDTraceId;
import datadog.trace.api.TraceConfig;
import datadog.trace.api.TracePropagationStyle;
import ddtrot.dd.trace.api.Functions;
import ddtrot.dd.trace.api.cache.DDCache;
import ddtrot.dd.trace.api.cache.DDCaches;
import ddtrot.dd.trace.bootstrap.ActiveSubsystems;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.TagContext;
import ddtrot.dd.trace.core.propagation.ExtractedContext;
import ddtrot.dd.trace.core.propagation.HttpCodec;
import ddtrot.dd.trace.core.propagation.PropagationTags;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;

public abstract class ContextInterpreter
implements AgentPropagation.KeyClassifier {
    private TraceConfig traceConfig;
    protected Map<String, String> headerTags;
    protected Map<String, String> baggageMapping;
    protected DDTraceId traceId;
    protected long spanId;
    protected int samplingPriority;
    protected Map<String, String> tags;
    protected Map<String, String> baggage;
    protected CharSequence lastParentId;
    protected CharSequence origin;
    protected long endToEndStartTime;
    protected boolean valid;
    protected boolean fullContext;
    protected final PropagationTags.Factory propagationTagsFactory;
    protected PropagationTags propagationTags;
    private TagContext.HttpHeaders httpHeaders;
    private final String customIpHeaderName;
    private final boolean clientIpResolutionEnabled;
    private final boolean clientIpWithoutAppSec;
    private boolean collectIpHeaders;
    private final boolean requestHeaderTagsCommaAllowed;
    protected static final boolean LOG_EXTRACT_HEADER_NAMES = Config.get().isLogExtractHeaderNames();
    private static final DDCache<String, String> CACHE = DDCaches.newFixedSizeCache(64);

    protected static String toLowerCase(String key) {
        return CACHE.computeIfAbsent(key, Functions.LowerCase.INSTANCE);
    }

    protected ContextInterpreter(Config config) {
        this.customIpHeaderName = config.getTraceClientIpHeader();
        this.clientIpResolutionEnabled = config.isTraceClientIpResolverEnabled();
        this.clientIpWithoutAppSec = config.isClientIpEnabled();
        this.propagationTagsFactory = PropagationTags.factory(config);
        this.requestHeaderTagsCommaAllowed = config.isRequestHeaderTagsCommaAllowed();
    }

    public abstract TracePropagationStyle style();

    protected final boolean handledForwarding(String key, String value) {
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        if ("forwarded".equalsIgnoreCase(key)) {
            this.getHeaders().forwarded = value;
            return true;
        }
        if ("forwarded-for".equalsIgnoreCase(key)) {
            this.getHeaders().forwardedFor = value;
            return true;
        }
        return false;
    }

    protected final boolean handledXForwarding(String key, String value) {
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        if ("x-forwarded-proto".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedProto = value;
            return true;
        }
        if ("x-forwarded-host".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedHost = value;
            return true;
        }
        if ("x-forwarded-for".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedFor = value;
            return true;
        }
        if ("x-forwarded-port".equalsIgnoreCase(key)) {
            this.getHeaders().xForwardedPort = value;
            return true;
        }
        if ("x-forwarded".equalsIgnoreCase(key)) {
            this.getHeaders().xForwarded = value;
            return true;
        }
        return false;
    }

    protected final boolean handledUserAgent(String key, String value) {
        if (value == null || !"user-agent".equalsIgnoreCase(key)) {
            return false;
        }
        this.getHeaders().userAgent = value;
        return true;
    }

    protected final boolean handledIpHeaders(String key, String value) {
        if (key == null || key.isEmpty()) {
            return false;
        }
        if (null != value && this.customIpHeaderName != null && this.customIpHeaderName.equalsIgnoreCase(key)) {
            this.getHeaders().customIpHeader = value;
            return true;
        }
        if (value == null || !this.collectIpHeaders) {
            return false;
        }
        char last = Character.toLowerCase(key.charAt(key.length() - 1));
        if (last == 'p') {
            if ("x-cluster-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().xClusterClientIp = value;
                return true;
            }
            if ("x-real-ip".equalsIgnoreCase(key)) {
                this.getHeaders().xRealIp = value;
                return true;
            }
            if ("x-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().xClientIp = value;
                return true;
            }
            if ("true-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().trueClientIp = value;
                return true;
            }
            if ("fastly-client-ip".equalsIgnoreCase(key)) {
                this.getHeaders().fastlyClientIp = value;
                return true;
            }
            if ("cf-connecting-ip".equalsIgnoreCase(key)) {
                this.getHeaders().cfConnectingIp = value;
                return true;
            }
        } else if ("cf-connecting-ipv6".equalsIgnoreCase(key)) {
            this.getHeaders().cfConnectingIpv6 = value;
            return true;
        }
        return false;
    }

    protected final boolean handleTags(String key, String value) {
        if (this.headerTags.isEmpty() || value == null) {
            return false;
        }
        String lowerCaseKey = ContextInterpreter.toLowerCase(key);
        String mappedKey = this.headerTags.get(lowerCaseKey);
        if (null != mappedKey) {
            if (this.tags.isEmpty()) {
                this.tags = new TreeMap<String, String>();
            }
            this.tags.put(mappedKey, HttpCodec.decode(this.requestHeaderTagsCommaAllowed ? value : HttpCodec.firstHeaderValue(value)));
            return true;
        }
        return false;
    }

    protected final boolean handleMappedBaggage(String key, String value) {
        if (this.baggageMapping.isEmpty() || value == null) {
            return false;
        }
        String lowerCaseKey = ContextInterpreter.toLowerCase(key);
        String mappedKey = this.baggageMapping.get(lowerCaseKey);
        if (null != mappedKey) {
            if (this.baggage.isEmpty()) {
                this.baggage = new TreeMap<String, String>();
            }
            this.baggage.put(mappedKey, HttpCodec.decode(value));
            return true;
        }
        return false;
    }

    public ContextInterpreter reset(TraceConfig traceConfig) {
        this.traceConfig = traceConfig;
        this.traceId = DDTraceId.ZERO;
        this.spanId = 0L;
        this.samplingPriority = -128;
        this.origin = null;
        this.endToEndStartTime = 0L;
        this.tags = Collections.emptyMap();
        this.baggage = Collections.emptyMap();
        this.valid = true;
        this.fullContext = true;
        this.httpHeaders = null;
        this.collectIpHeaders = this.clientIpWithoutAppSec || this.clientIpResolutionEnabled && ActiveSubsystems.APPSEC_ACTIVE;
        this.headerTags = traceConfig.getRequestHeaderTags();
        this.baggageMapping = traceConfig.getBaggageMapping();
        return this;
    }

    protected TagContext build() {
        if (this.valid) {
            if (this.fullContext && !DDTraceId.ZERO.equals(this.traceId)) {
                if (this.propagationTags == null) {
                    this.propagationTags = this.propagationTagsFactory.empty();
                }
                return new ExtractedContext(this.traceId, this.spanId, this.samplingPriorityOrDefault(this.traceId, this.samplingPriority), this.origin, this.endToEndStartTime, this.baggage, this.tags, this.httpHeaders, this.propagationTags, this.traceConfig, this.style());
            }
            if (this.origin != null || !this.tags.isEmpty() || this.httpHeaders != null || !this.baggage.isEmpty() || this.samplingPriority != -128) {
                return new TagContext(this.origin, this.tags, this.httpHeaders, this.baggage, this.samplingPriorityOrDefault(this.traceId, this.samplingPriority), this.traceConfig, this.style());
            }
        }
        return null;
    }

    protected void invalidateContext() {
        this.valid = false;
    }

    protected void onlyTagContext() {
        this.fullContext = false;
    }

    protected int defaultSamplingPriority() {
        return -128;
    }

    private TagContext.HttpHeaders getHeaders() {
        if (this.httpHeaders == null) {
            this.httpHeaders = new TagContext.HttpHeaders();
        }
        return this.httpHeaders;
    }

    private int samplingPriorityOrDefault(DDTraceId traceId, int samplingPriority) {
        return samplingPriority == -128 || DDTraceId.ZERO.equals(traceId) ? this.defaultSamplingPriority() : samplingPriority;
    }

    public static interface Factory {
        public ContextInterpreter create();
    }
}

