/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.common.writer;

import datadog.trace.api.Config;
import ddtrot.dd.communication.ddagent.DDAgentFeaturesDiscovery;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.monitor.Monitoring;
import ddtrot.dd.trace.common.sampling.SingleSpanSampler;
import ddtrot.dd.trace.common.writer.PayloadDispatcher;
import ddtrot.dd.trace.common.writer.PayloadDispatcherImpl;
import ddtrot.dd.trace.common.writer.RemoteWriter;
import ddtrot.dd.trace.common.writer.TraceProcessingWorker;
import ddtrot.dd.trace.common.writer.ddagent.DDAgentApi;
import ddtrot.dd.trace.common.writer.ddagent.DDAgentMapperDiscovery;
import ddtrot.dd.trace.common.writer.ddagent.Prioritization;
import ddtrot.dd.trace.core.monitor.HealthMetrics;
import ddtrot.okhttp3.HttpUrl;
import ddtrot.okhttp3.OkHttpClient;
import java.util.concurrent.TimeUnit;

public class DDAgentWriter
extends RemoteWriter {
    private static final int BUFFER_SIZE = 1024;

    public static DDAgentWriterBuilder builder() {
        return new DDAgentWriterBuilder();
    }

    DDAgentWriter(TraceProcessingWorker worker, PayloadDispatcher dispatcher, HealthMetrics healthMetrics, boolean alwaysFlush) {
        super(worker, dispatcher, healthMetrics, alwaysFlush);
    }

    public static class DDAgentWriterBuilder {
        String agentHost = "localhost";
        int traceAgentPort = 8126;
        String unixDomainSocket = null;
        String namedPipe = null;
        long timeoutMillis = TimeUnit.SECONDS.toMillis(10L);
        int traceBufferSize = 1024;
        HealthMetrics healthMetrics = HealthMetrics.NO_OP;
        int flushIntervalMilliseconds = 1000;
        Monitoring monitoring = Monitoring.DISABLED;
        boolean traceAgentV05Enabled = Config.get().isTraceAgentV05Enabled();
        boolean metricsReportingEnabled = Config.get().isTracerMetricsEnabled();
        boolean alwaysFlush = false;
        private DDAgentApi agentApi;
        private Prioritization prioritization;
        private DDAgentFeaturesDiscovery featureDiscovery;
        private SingleSpanSampler singleSpanSampler;

        public DDAgentWriterBuilder agentApi(DDAgentApi agentApi) {
            this.agentApi = agentApi;
            return this;
        }

        public DDAgentWriterBuilder agentHost(String agentHost) {
            this.agentHost = agentHost;
            return this;
        }

        public DDAgentWriterBuilder traceAgentPort(int traceAgentPort) {
            this.traceAgentPort = traceAgentPort;
            return this;
        }

        public DDAgentWriterBuilder unixDomainSocket(String unixDomainSocket) {
            this.unixDomainSocket = unixDomainSocket;
            return this;
        }

        public DDAgentWriterBuilder namedPipe(String namedPipe) {
            this.namedPipe = namedPipe;
            return this;
        }

        public DDAgentWriterBuilder timeoutMillis(long timeoutMillis) {
            this.timeoutMillis = timeoutMillis;
            return this;
        }

        public DDAgentWriterBuilder traceBufferSize(int traceBufferSize) {
            this.traceBufferSize = traceBufferSize;
            return this;
        }

        public DDAgentWriterBuilder healthMetrics(HealthMetrics healthMetrics) {
            this.healthMetrics = healthMetrics;
            return this;
        }

        public DDAgentWriterBuilder flushIntervalMilliseconds(int flushIntervalMilliseconds) {
            this.flushIntervalMilliseconds = flushIntervalMilliseconds;
            return this;
        }

        public DDAgentWriterBuilder prioritization(Prioritization prioritization) {
            this.prioritization = prioritization;
            return this;
        }

        public DDAgentWriterBuilder monitoring(Monitoring monitoring) {
            this.monitoring = monitoring;
            return this;
        }

        public DDAgentWriterBuilder traceAgentV05Enabled(boolean traceAgentV05Enabled) {
            this.traceAgentV05Enabled = traceAgentV05Enabled;
            return this;
        }

        public DDAgentWriterBuilder metricsReportingEnabled(boolean metricsReportingEnabled) {
            this.metricsReportingEnabled = metricsReportingEnabled;
            return this;
        }

        public DDAgentWriterBuilder featureDiscovery(DDAgentFeaturesDiscovery featureDiscovery) {
            this.featureDiscovery = featureDiscovery;
            return this;
        }

        public DDAgentWriterBuilder alwaysFlush(boolean alwaysFlush) {
            this.alwaysFlush = alwaysFlush;
            return this;
        }

        public DDAgentWriterBuilder spanSamplingRules(SingleSpanSampler singleSpanSampler) {
            this.singleSpanSampler = singleSpanSampler;
            return this;
        }

        public DDAgentWriter build() {
            OkHttpClient client;
            HttpUrl agentUrl = HttpUrl.get("http://" + this.agentHost + ":" + this.traceAgentPort);
            OkHttpClient okHttpClient = client = null == this.featureDiscovery || null == this.agentApi ? OkHttpUtils.buildHttpClient(agentUrl, this.unixDomainSocket, this.namedPipe, this.timeoutMillis) : null;
            if (null == this.featureDiscovery) {
                this.featureDiscovery = new DDAgentFeaturesDiscovery(client, this.monitoring, agentUrl, this.traceAgentV05Enabled, this.metricsReportingEnabled);
            }
            if (null == this.agentApi) {
                this.agentApi = new DDAgentApi(client, agentUrl, this.featureDiscovery, this.monitoring, this.metricsReportingEnabled);
            }
            DDAgentMapperDiscovery mapperDiscovery = new DDAgentMapperDiscovery(this.featureDiscovery);
            PayloadDispatcherImpl dispatcher = new PayloadDispatcherImpl(mapperDiscovery, this.agentApi, this.healthMetrics, this.monitoring);
            TraceProcessingWorker traceProcessingWorker = new TraceProcessingWorker(this.traceBufferSize, this.healthMetrics, dispatcher, this.featureDiscovery, null == this.prioritization ? Prioritization.FAST_LANE : this.prioritization, this.flushIntervalMilliseconds, TimeUnit.MILLISECONDS, this.singleSpanSampler, null);
            return new DDAgentWriter(traceProcessingWorker, dispatcher, this.healthMetrics, this.alwaysFlush);
        }
    }
}

