/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core;

import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.Baggage;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopedContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopedContextKey;
import ddtrot.dd.trace.core.DDBaggage;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;

public final class DDScopedContext
implements ScopedContext {
    private static final ScopedContext EMPTY = new DDScopedContext(null, DDBaggage.empty(), new Object[0]);
    private static final int SPAN_KEY_INDEX = 0;
    private static final int BAGGAGE_KEY_INDEX = 1;
    @Nullable
    private final AgentSpan span;
    private final Baggage baggage;
    private final Object[] store;

    private DDScopedContext(@Nullable AgentSpan span, Baggage baggage, Object[] store) {
        this.span = span;
        this.baggage = baggage;
        this.store = store;
    }

    public static ScopedContext empty() {
        return EMPTY;
    }

    @Override
    public AgentSpan span() {
        return this.span;
    }

    @Override
    public Baggage baggage() {
        return this.baggage;
    }

    @Override
    public <T> T get(ScopedContextKey<T> key) {
        switch (key.index()) {
            case 0: {
                return (T)this.span;
            }
            case 1: {
                return (T)this.baggage;
            }
        }
        int storeIndex = key.index() - 2;
        return (T)(storeIndex < this.store.length ? this.store[storeIndex] : null);
    }

    @Override
    public <T> ScopedContext with(ScopedContextKey<T> key, T value) {
        switch (key.index()) {
            case 0: {
                return new DDScopedContext((AgentSpan)value, this.baggage, this.store);
            }
            case 1: {
                return new DDScopedContext(this.span, (Baggage)value, this.store);
            }
        }
        int storeIndex = key.index() - 2;
        Object[] newStore = Arrays.copyOfRange(this.store, 0, Math.max(this.store.length, storeIndex + 1));
        newStore[storeIndex] = value;
        return new DDScopedContext(this.span, this.baggage, newStore);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DDScopedContext that = (DDScopedContext)o;
        return Objects.equals(this.span, that.span) && this.baggage.equals(that.baggage) && Arrays.equals(this.store, that.store);
    }

    public int hashCode() {
        int result = 31;
        if (this.span != null) {
            result += this.span.hashCode();
        }
        result = 31 * result + this.baggage.hashCode();
        result = 31 * result + Arrays.hashCode(this.store);
        return result;
    }
}

