/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.api.gateway;

import ddtrot.dd.trace.api.function.TriConsumer;
import ddtrot.dd.trace.api.function.TriFunction;
import ddtrot.dd.trace.api.gateway.CallbackProvider;
import ddtrot.dd.trace.api.gateway.EventType;
import ddtrot.dd.trace.api.gateway.Events;
import ddtrot.dd.trace.api.gateway.Flow;
import ddtrot.dd.trace.api.gateway.IGSpanInfo;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.gateway.Subscription;
import ddtrot.dd.trace.api.gateway.SubscriptionService;
import ddtrot.dd.trace.api.http.StoredBodySupplier;
import ddtrot.dd.trace.bootstrap.instrumentation.api.URIDataAdapter;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentationGateway {
    private static final Logger log = LoggerFactory.getLogger(InstrumentationGateway.class);
    private final IGCallbackRegistry callbackRegistryAppSec = new IGCallbackRegistry();
    private final IGCallbackRegistry callbackRegistryIast = new IGCallbackRegistry();
    private final UniversalCallbackProvider universalCallbackProvider = new UniversalCallbackProvider();

    public SubscriptionService getSubscriptionService(RequestContextSlot slot) {
        if (slot == RequestContextSlot.APPSEC) {
            return this.callbackRegistryAppSec;
        }
        if (slot == RequestContextSlot.IAST) {
            return this.callbackRegistryIast;
        }
        return SubscriptionService.SubscriptionServiceNoop.INSTANCE;
    }

    public CallbackProvider getCallbackProvider(RequestContextSlot slot) {
        if (slot == RequestContextSlot.APPSEC) {
            return this.callbackRegistryAppSec;
        }
        if (slot == RequestContextSlot.IAST) {
            return this.callbackRegistryIast;
        }
        return CallbackProvider.CallbackProviderNoop.INSTANCE;
    }

    void reset() {
        this.callbackRegistryAppSec.reset();
        this.callbackRegistryIast.reset();
        this.universalCallbackProvider.reset();
    }

    public CallbackProvider getUniversalCallbackProvider() {
        return this.universalCallbackProvider;
    }

    public static <C> C wrap(final EventType<C> eventType, final C callback) {
        switch (eventType.getId()) {
            case 0: {
                return (C)new Supplier<Flow<Object>>(){

                    @Override
                    public Flow<Object> get() {
                        try {
                            return (Flow)((Supplier)callback).get();
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 1: {
                return (C)new BiFunction<RequestContext, IGSpanInfo, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, IGSpanInfo agentSpan) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, agentSpan);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 3: 
            case 13: {
                return (C)new Function<RequestContext, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx) {
                        try {
                            return (Flow)((Function)callback).apply(ctx);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 2: 
            case 12: {
                return (C)new TriConsumer<RequestContext, String, String>(){

                    @Override
                    public void accept(RequestContext ctx, String key, String value) {
                        try {
                            ((TriConsumer)callback).accept(ctx, key, value);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 4: {
                return (C)new TriFunction<RequestContext, String, URIDataAdapter, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, String method, URIDataAdapter adapter) {
                        try {
                            return (Flow)((TriFunction)callback).apply(ctx, method, adapter);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 5: {
                return (C)new BiFunction<RequestContext, Map<String, Object>, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, Map<String, Object> map) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, map);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 6: {
                return (C)new TriFunction<RequestContext, String, Integer, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, String ip, Integer port) {
                        try {
                            return (Flow)((TriFunction)callback).apply(ctx, ip, port);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 7: 
            case 18: {
                return (C)new BiFunction<RequestContext, String, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, String ip) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, ip);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }

                    public boolean equals(Object obj) {
                        return callback.equals(obj);
                    }
                };
            }
            case 8: {
                return (C)new BiFunction<RequestContext, StoredBodySupplier, Void>(){

                    @Override
                    public Void apply(RequestContext ctx, StoredBodySupplier storedBodySupplier) {
                        try {
                            return (Void)((BiFunction)callback).apply(ctx, storedBodySupplier);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return null;
                        }
                    }
                };
            }
            case 9: {
                return (C)new BiFunction<RequestContext, StoredBodySupplier, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, StoredBodySupplier storedBodySupplier) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, storedBodySupplier);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }
                };
            }
            case 10: 
            case 14: 
            case 15: {
                return (C)new BiFunction<RequestContext, Object, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, Object obj) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, obj);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }
                };
            }
            case 11: {
                return (C)new BiFunction<RequestContext, Integer, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, Integer status) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, status);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }
                };
            }
            case 16: {
                return (C)new BiConsumer<RequestContext, String>(){

                    @Override
                    public void accept(RequestContext ctx, String arg) {
                        try {
                            ((BiConsumer)callback).accept(ctx, arg);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                        }
                    }
                };
            }
            case 17: {
                return (C)new BiFunction<RequestContext, String, Flow<Void>>(){

                    @Override
                    public Flow<Void> apply(RequestContext ctx, String arg) {
                        try {
                            return (Flow)((BiFunction)callback).apply(ctx, arg);
                        }
                        catch (Throwable t) {
                            log.warn("Callback for {} threw.", (Object)eventType, (Object)t);
                            return Flow.ResultFlow.empty();
                        }
                    }
                };
            }
        }
        log.warn("Unwrapped callback for {}", eventType);
        return callback;
    }

    private <C> C universalCallback(EventType<C> eventType) {
        Object callbackAppSec = this.callbackRegistryAppSec.getCallback(eventType);
        Object callbackIast = this.callbackRegistryIast.getCallback(eventType);
        if (callbackAppSec == null && callbackIast == null) {
            return null;
        }
        if (callbackAppSec != null && callbackIast == null) {
            return callbackAppSec;
        }
        if (callbackAppSec == null && callbackIast != null) {
            return callbackIast;
        }
        switch (eventType.getId()) {
            case 1: {
                return (C)((BiFunction<RequestContext, IGSpanInfo, Flow>)(ctx, agentSpan) -> {
                    Flow flowAppSec = (Flow)((BiFunction)callbackAppSec).apply(ctx, agentSpan);
                    Flow flowIast = (Flow)((BiFunction)callbackIast).apply(ctx, agentSpan);
                    return InstrumentationGateway.mergeFlows(flowAppSec, flowIast);
                });
            }
            case 2: {
                return (C)((TriConsumer<RequestContext, String, String>)(requestContext, s, s2) -> {
                    ((TriConsumer)callbackAppSec).accept(requestContext, s, s2);
                    ((TriConsumer)callbackIast).accept(requestContext, s, s2);
                });
            }
            case 3: {
                return (C)((Function<RequestContext, Flow>)requestContext -> {
                    Flow flowAppSec = (Flow)((Function)callbackAppSec).apply(requestContext);
                    Flow flowIast = (Flow)((Function)callbackIast).apply(requestContext);
                    return InstrumentationGateway.mergeFlows(flowAppSec, flowIast);
                });
            }
        }
        return null;
    }

    public static <T> Flow<T> mergeFlows(final Flow<T> flow1, final Flow<T> flow2) {
        if (flow1 == flow2) {
            return flow1;
        }
        return new Flow<T>(){

            @Override
            public Flow.Action getAction() {
                return flow1.getAction().isBlocking() ? flow1.getAction() : flow2.getAction();
            }

            @Override
            public T getResult() {
                if (flow2.getResult() != null) {
                    return flow2.getResult();
                }
                return flow1.getResult();
            }
        };
    }

    private class IGCallbackRegistry
    implements CallbackProvider,
    SubscriptionService {
        private final AtomicReferenceArray<Object> callbacks = new AtomicReferenceArray(Events.MAX_EVENTS);

        private IGCallbackRegistry() {
        }

        @Override
        public void reset() {
            for (int i = 0; i < this.callbacks.length(); ++i) {
                this.callbacks.set(i, null);
            }
        }

        void reset(EventType<?> et) {
            this.callbacks.set(et.getId(), null);
        }

        @Override
        public <C> C getCallback(EventType<C> eventType) {
            return (C)this.callbacks.get(eventType.getId());
        }

        @Override
        public <C> Subscription registerCallback(final EventType<C> eventType, final C callback) {
            final C wrapped = InstrumentationGateway.wrap(eventType, callback);
            final int id = eventType.getId();
            if (!this.callbacks.compareAndSet(id, null, wrapped)) {
                Object existing = this.callbacks.get(id);
                String message = "Trying to overwrite existing callback " + existing + " for event type " + eventType;
                log.warn(message);
                throw new IllegalStateException(message);
            }
            ((InstrumentationGateway)InstrumentationGateway.this).universalCallbackProvider.callbacks.set(id, null);
            return new Subscription(){

                @Override
                public void cancel() {
                    if (!IGCallbackRegistry.this.callbacks.compareAndSet(id, wrapped, null) && log.isDebugEnabled()) {
                        log.debug("Failed to unregister callback {} for event type {}", callback, (Object)eventType);
                    }
                }
            };
        }
    }

    private class UniversalCallbackProvider
    implements CallbackProvider {
        final AtomicReferenceArray<Object> callbacks = new AtomicReferenceArray(Events.MAX_EVENTS);

        private UniversalCallbackProvider() {
        }

        @Override
        public <C> C getCallback(EventType<C> eventType) {
            int id = eventType.getId();
            Object cb = this.callbacks.get(id);
            if (cb != null) {
                return (C)cb;
            }
            cb = InstrumentationGateway.this.universalCallback(eventType);
            if (!this.callbacks.compareAndSet(id, null, cb)) {
                return this.getCallback(eventType);
            }
            return (C)cb;
        }

        void reset() {
            for (int i = 0; i < this.callbacks.length(); ++i) {
                this.callbacks.set(i, null);
            }
        }
    }
}

