/*
 * Decompiled with CFR 0.152.
 */
package datadog.opentracing;

import datadog.opentracing.LogHandler;
import datadog.opentracing.TypeConverter;
import datadog.trace.api.interceptor.MutableSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.tag.Tag;
import java.util.Map;

class OTSpan
implements Span,
MutableSpan {
    private final AgentSpan delegate;
    private final TypeConverter converter;
    private final LogHandler logHandler;

    OTSpan(AgentSpan delegate, TypeConverter converter, LogHandler logHandler) {
        this.delegate = delegate;
        this.converter = converter;
        this.logHandler = logHandler;
    }

    public SpanContext context() {
        return this.converter.toSpanContext(this.delegate.context());
    }

    @Override
    public OTSpan setTag(String key, String value) {
        this.delegate.setTag(key, value);
        return this;
    }

    @Override
    public OTSpan setTag(String key, boolean value) {
        this.delegate.setTag(key, value);
        return this;
    }

    @Override
    public OTSpan setTag(String key, Number value) {
        this.delegate.setTag(key, value);
        return this;
    }

    @Override
    public OTSpan setMetric(CharSequence metric, int value) {
        this.delegate.setMetric(metric, value);
        return this;
    }

    @Override
    public OTSpan setMetric(CharSequence metric, long value) {
        this.delegate.setMetric(metric, value);
        return this;
    }

    @Override
    public OTSpan setMetric(CharSequence metric, double value) {
        this.delegate.setMetric(metric, value);
        return this;
    }

    @Override
    public boolean isError() {
        return this.delegate.isError();
    }

    @Override
    public OTSpan setError(boolean value) {
        this.delegate.setError(value);
        return this;
    }

    @Override
    public OTSpan getRootSpan() {
        return this.getLocalRootSpan();
    }

    @Override
    public OTSpan getLocalRootSpan() {
        return this.converter.toSpan(this.delegate.getLocalRootSpan());
    }

    public <T> Span setTag(Tag<T> tag, T value) {
        this.delegate.setTag(tag.getKey(), value);
        return this;
    }

    public OTSpan log(Map<String, ?> fields) {
        this.logHandler.log(fields, this.delegate);
        return this;
    }

    public OTSpan log(long timestampMicroseconds, Map<String, ?> fields) {
        this.logHandler.log(timestampMicroseconds, fields, this.delegate);
        return this;
    }

    public OTSpan log(String event) {
        this.logHandler.log(event, this.delegate);
        return this;
    }

    public OTSpan log(long timestampMicroseconds, String event) {
        this.logHandler.log(timestampMicroseconds, event, this.delegate);
        return this;
    }

    public OTSpan setBaggageItem(String key, String value) {
        this.delegate.setBaggageItem(key, value);
        return this;
    }

    public String getBaggageItem(String key) {
        return this.delegate.getBaggageItem(key);
    }

    @Override
    public long getStartTime() {
        return this.delegate.getStartTime();
    }

    @Override
    public long getDurationNano() {
        return this.delegate.getDurationNano();
    }

    @Override
    public CharSequence getOperationName() {
        return this.delegate.getOperationName();
    }

    @Override
    public OTSpan setOperationName(CharSequence operationName) {
        this.delegate.setOperationName(operationName);
        return this;
    }

    public OTSpan setOperationName(String operationName) {
        this.delegate.setOperationName(UTF8BytesString.create(operationName));
        return this;
    }

    @Override
    public String getServiceName() {
        return this.delegate.getServiceName();
    }

    @Override
    public OTSpan setServiceName(String serviceName) {
        this.delegate.setServiceName(serviceName);
        return this;
    }

    @Override
    public CharSequence getResourceName() {
        return this.delegate.getResourceName();
    }

    @Override
    public OTSpan setResourceName(CharSequence resourceName) {
        this.delegate.setResourceName(resourceName, (byte)5);
        return this;
    }

    @Override
    public Integer getSamplingPriority() {
        return this.delegate.getSamplingPriority();
    }

    @Override
    public OTSpan setSamplingPriority(int newPriority) {
        this.delegate.setSamplingPriority(newPriority);
        return this;
    }

    @Override
    public String getSpanType() {
        return this.delegate.getSpanType();
    }

    @Override
    public OTSpan setSpanType(CharSequence type) {
        this.delegate.setSpanType(type);
        return this;
    }

    @Override
    public Map<String, Object> getTags() {
        return this.delegate.getTags();
    }

    @Override
    public Object getTag(String key) {
        return this.delegate.getTag(key);
    }

    public void finish() {
        this.delegate.finish();
    }

    public void finish(long finishMicros) {
        this.delegate.finish(finishMicros);
    }

    public AgentSpan getDelegate() {
        return this.delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OTSpan otSpan = (OTSpan)o;
        return this.delegate.equals(otSpan.delegate);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }
}

