/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.config.provider;

import ddtrot.dd.trace.util.Strings;
import de.thetaphi.forbiddenapis.SuppressForbidden;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ConfigConverter {
    private static final Logger log = LoggerFactory.getLogger(ConfigConverter.class);
    private static final ValueOfLookup LOOKUP = new ValueOfLookup();

    ConfigConverter() {
    }

    static <T> T valueOf(String value, @Nonnull Class<T> tClass) {
        Objects.requireNonNull(tClass, "tClass is marked non-null but is null");
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        try {
            return (T)((MethodHandle)LOOKUP.get(tClass)).invoke(value);
        }
        catch (NumberFormatException e) {
            throw e;
        }
        catch (Throwable e) {
            log.debug("Can't parse: ", e);
            throw new NumberFormatException(e.toString());
        }
    }

    @Nonnull
    static List<String> parseList(String str) {
        return ConfigConverter.parseList(str, ",");
    }

    @Nonnull
    @SuppressForbidden
    static List<String> parseList(String str, String separator) {
        String trimmed = Strings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyList();
        }
        String[] tokens = trimmed.split(separator, -1);
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return Collections.unmodifiableList(Arrays.asList(tokens));
    }

    @Nonnull
    static Map<String, String> parseMap(String str, String settingName) {
        String trimmed = Strings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigConverter.loadMap(map, trimmed, settingName);
        return map;
    }

    @Nonnull
    static Map<String, String> parseMapWithOptionalMappings(String str, String settingName, String defaultPrefix, boolean lowercaseKeys) {
        String trimmed = Strings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        ConfigConverter.loadMapWithOptionalMapping(map, trimmed, settingName, defaultPrefix, lowercaseKeys);
        return map;
    }

    @Nonnull
    static Map<String, String> parseOrderedMap(String str, String settingName) {
        String trimmed = Strings.trim(str);
        if (trimmed.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        ConfigConverter.loadMap(map, trimmed, settingName);
        return map;
    }

    private static void loadMap(Map<String, String> map, String str, String settingName) {
        boolean badFormat = false;
        int start = 0;
        int splitter = str.indexOf(58, start);
        while (splitter != -1 && !badFormat) {
            String key;
            int end;
            int nextSplitter = str.indexOf(58, splitter + 1);
            int nextComma = str.indexOf(44, splitter + 1);
            nextComma = nextComma == -1 ? str.length() : nextComma;
            int nextSpace = str.indexOf(32, splitter + 1);
            int n = nextSpace = nextSpace == -1 ? str.length() : nextSpace;
            while (nextSplitter != -1 && nextSplitter < nextComma && nextSplitter < nextSpace) {
                nextSplitter = str.indexOf(58, nextSplitter + 1);
            }
            if (nextSplitter == -1) {
                end = nextComma;
                if (nextComma < str.length() - 1) {
                    badFormat = true;
                }
            } else if (nextComma < str.length()) {
                end = nextComma;
            } else if (nextSpace < str.length()) {
                end = nextSpace;
            } else {
                end = str.length();
                badFormat = true;
            }
            if (badFormat || (badFormat = (key = str.substring(start, splitter).trim()).indexOf(44) != -1)) continue;
            String value = str.substring(splitter + 1, end).trim();
            if (!key.isEmpty() && !value.isEmpty()) {
                map.put(key, value);
            }
            splitter = nextSplitter;
            start = end + 1;
        }
        if (badFormat) {
            log.warn("Invalid config for {}: '{}'. Must match 'key1:value1,key2:value2' or 'key1:value1 key2:value2'.", (Object)settingName, (Object)str);
            map.clear();
        }
    }

    private static void loadMapWithOptionalMapping(Map<String, String> map, String str, String settingName, String defaultPrefix, boolean lowercaseKeys) {
        int listChar;
        boolean badFormat = false;
        String string = defaultPrefix = null == defaultPrefix ? "" : defaultPrefix;
        if (!defaultPrefix.isEmpty() && !defaultPrefix.endsWith(".")) {
            defaultPrefix = defaultPrefix + ".";
        }
        int start = 0;
        int len = str.length();
        int n = listChar = str.indexOf(44) == -1 ? 32 : 44;
        while (!badFormat && start < len) {
            String key;
            int delimiter;
            int end = len;
            int listPos = str.indexOf(listChar, start);
            int mapPos = str.indexOf(58, start);
            int n2 = listPos == -1 ? mapPos : (delimiter = mapPos == -1 ? listPos : Math.min(listPos, mapPos));
            if (delimiter == -1) {
                delimiter = end;
            } else if (delimiter == mapPos) {
                int nextList = str.indexOf(listChar, delimiter + 1);
                if (mapPos == start) {
                    badFormat = true;
                } else if (nextList != -1) {
                    end = nextList;
                }
            } else {
                end = delimiter;
            }
            if (!badFormat && start != end && !(key = ConfigConverter.trimmedHeader(str, start, delimiter, lowercaseKeys)).isEmpty()) {
                String value;
                if (delimiter == mapPos) {
                    value = ConfigConverter.trimmedHeader(str, delimiter + 1, end, false);
                    if (!value.isEmpty() && !Character.isLetter(value.charAt(0))) {
                        value = "";
                        badFormat = true;
                    }
                } else if (Character.isLetter(key.charAt(0))) {
                    value = defaultPrefix + ConfigConverter.normalizedHeaderTag(key);
                } else {
                    value = "";
                    badFormat = true;
                }
                if (!value.isEmpty()) {
                    map.put(key, value);
                }
            }
            start = end + 1;
        }
        if (badFormat) {
            log.warn("Invalid config for {}: '{}'. Must match '(key:value|key)([ ,](key:value|key))*'.", (Object)settingName, (Object)str);
            map.clear();
        }
    }

    @Nonnull
    private static String trimmedHeader(String str, int start, int end, boolean lowercase) {
        if (start >= end) {
            return "";
        }
        StringBuilder builder = new StringBuilder(end - start);
        int firstNonWhiteSpace = -1;
        int lastNonWhitespace = -1;
        for (int i = start; i < end; ++i) {
            char c;
            char c2 = c = lowercase ? Character.toLowerCase(str.charAt(i)) : str.charAt(i);
            if (Character.isWhitespace(c)) {
                builder.append(' ');
                continue;
            }
            firstNonWhiteSpace = firstNonWhiteSpace == -1 ? i : firstNonWhiteSpace;
            lastNonWhitespace = i;
            builder.append(c);
        }
        if (firstNonWhiteSpace == -1) {
            return "";
        }
        str = builder.substring(firstNonWhiteSpace - start, lastNonWhitespace - start + 1);
        return str;
    }

    @Nonnull
    private static String normalizedHeaderTag(String str) {
        if (str.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(str.length());
        int firstNonWhiteSpace = -1;
        int lastNonWhitespace = -1;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (Character.isWhitespace(c)) {
                builder.append('_');
                continue;
            }
            firstNonWhiteSpace = firstNonWhiteSpace == -1 ? i : firstNonWhiteSpace;
            lastNonWhitespace = i;
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-' || c == '/') {
                builder.append(Character.toLowerCase(c));
                continue;
            }
            builder.append('_');
        }
        if (firstNonWhiteSpace == -1) {
            return "";
        }
        str = builder.substring(firstNonWhiteSpace, lastNonWhitespace + 1);
        return str;
    }

    @Nonnull
    @SuppressForbidden
    static BitSet parseIntegerRangeSet(@Nonnull String str, String settingName) throws NumberFormatException {
        String[] tokens;
        if (!(str = str.replaceAll("\\s", "")).matches("\\d{3}(?:-\\d{3})?(?:,\\d{3}(?:-\\d{3})?)*")) {
            log.warn("Invalid config for {}: '{}'. Must be formatted like '400-403,405,410-499'.", (Object)settingName, (Object)str);
            throw new NumberFormatException();
        }
        int lastSeparator = Math.max(str.lastIndexOf(44), str.lastIndexOf(45));
        int maxValue = Integer.parseInt(str.substring(lastSeparator + 1));
        BitSet set = new BitSet(maxValue);
        for (String token : tokens = str.split(",", -1)) {
            int separator = token.indexOf(45);
            if (separator == -1) {
                set.set(Integer.parseInt(token));
                continue;
            }
            if (separator <= 0) continue;
            int left = Integer.parseInt(token.substring(0, separator));
            int right = Integer.parseInt(token.substring(separator + 1));
            int min = Math.min(left, right);
            int max = Math.max(left, right);
            set.set(min, max + 1);
        }
        return set;
    }

    public static Boolean booleanValueOf(String value) {
        if ("1".equals(value)) {
            return Boolean.TRUE;
        }
        return Boolean.valueOf(value);
    }

    private static class ValueOfLookup
    extends ClassValue<MethodHandle> {
        private static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();

        private ValueOfLookup() {
        }

        @Override
        protected MethodHandle computeValue(Class<?> type) {
            try {
                if (Boolean.class.equals(type)) {
                    return MethodHandles.lookup().findStatic(ConfigConverter.class, "booleanValueOf", MethodType.methodType(Boolean.class, String.class));
                }
                return PUBLIC_LOOKUP.findStatic(type, "valueOf", MethodType.methodType(type, String.class));
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                log.debug("Can't invoke or access 'valueOf': ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

