/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.api;

import datadog.trace.api.DDTraceId;
import datadog.trace.api.EndpointCheckpointer;
import datadog.trace.api.EndpointTracker;
import datadog.trace.api.TracePropagationStyle;
import datadog.trace.api.Tracer;
import datadog.trace.api.interceptor.TraceInterceptor;
import datadog.trace.api.internal.InternalTracer;
import ddtrot.dd.trace.api.gateway.CallbackProvider;
import ddtrot.dd.trace.api.gateway.Flow;
import ddtrot.dd.trace.api.gateway.RequestContext;
import ddtrot.dd.trace.api.gateway.RequestContextSlot;
import ddtrot.dd.trace.api.gateway.SubscriptionService;
import ddtrot.dd.trace.api.scopemanager.ScopeListener;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentScope;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentSpan;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentTrace;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.ScopeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.StatsPoint;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;

public class AgentTracer {
    public static final TracerAPI NOOP_TRACER;
    private static volatile TracerAPI provider;

    public static AgentSpan startSpan(CharSequence spanName) {
        return AgentTracer.get().startSpan(spanName);
    }

    public static AgentSpan startSpan(CharSequence spanName, long startTimeMicros) {
        return AgentTracer.get().startSpan(spanName, startTimeMicros);
    }

    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent) {
        return AgentTracer.get().startSpan(spanName, parent);
    }

    public static AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
        return AgentTracer.get().startSpan(spanName, parent, startTimeMicros);
    }

    public static AgentScope activateSpan(AgentSpan span) {
        return AgentTracer.get().activateSpan(span, ScopeSource.INSTRUMENTATION, true);
    }

    public static AgentScope activateSpan(AgentSpan span, boolean isAsyncPropagating) {
        return AgentTracer.get().activateSpan(span, ScopeSource.INSTRUMENTATION, isAsyncPropagating);
    }

    public static AgentScope.Continuation captureSpan(AgentSpan span) {
        return AgentTracer.get().captureSpan(span, ScopeSource.INSTRUMENTATION);
    }

    public static void closePrevious(boolean finishSpan) {
        AgentTracer.get().closePrevious(finishSpan);
    }

    public static AgentScope activateNext(AgentSpan span) {
        return AgentTracer.get().activateNext(span);
    }

    public static AgentSpan activeSpan() {
        return AgentTracer.get().activeSpan();
    }

    public static AgentScope activeScope() {
        return AgentTracer.get().activeScope();
    }

    public static AgentPropagation propagate() {
        return AgentTracer.get().propagate();
    }

    public static AgentSpan noopSpan() {
        return AgentTracer.get().noopSpan();
    }

    public static boolean isRegistered() {
        return provider != NOOP_TRACER;
    }

    public static synchronized void registerIfAbsent(TracerAPI tracer) {
        if (tracer != null && tracer != NOOP_TRACER) {
            provider = tracer;
        }
    }

    public static synchronized void forceRegister(TracerAPI tracer) {
        provider = tracer;
    }

    public static TracerAPI get() {
        return provider;
    }

    private AgentTracer() {
    }

    static {
        provider = NOOP_TRACER = new NoopTracerAPI();
    }

    public static class NoopPathwayContext
    implements PathwayContext {
        public static final NoopPathwayContext INSTANCE = new NoopPathwayContext();

        @Override
        public boolean isStarted() {
            return false;
        }

        @Override
        public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer) {
        }

        @Override
        public byte[] encode() throws IOException {
            return null;
        }

        @Override
        public String strEncode() throws IOException {
            return null;
        }
    }

    public static class NoopAgentTrace
    implements AgentTrace {
        public static final NoopAgentTrace INSTANCE = new NoopAgentTrace();

        @Override
        public void registerContinuation(AgentScope.Continuation continuation) {
        }

        @Override
        public void cancelContinuation(AgentScope.Continuation continuation) {
        }
    }

    public static final class NoopContext
    implements AgentSpan.Context.Extracted {
        public static final NoopContext INSTANCE = new NoopContext();

        private NoopContext() {
        }

        @Override
        public DDTraceId getTraceId() {
            return DDTraceId.ZERO;
        }

        @Override
        public long getSpanId() {
            return 0L;
        }

        @Override
        public AgentTrace getTrace() {
            return NoopAgentTrace.INSTANCE;
        }

        @Override
        public Iterable<Map.Entry<String, String>> baggageItems() {
            return Collections.emptyList();
        }

        @Override
        public PathwayContext getPathwayContext() {
            return NoopPathwayContext.INSTANCE;
        }

        @Override
        public String getForwarded() {
            return null;
        }

        @Override
        public String getXForwardedProto() {
            return null;
        }

        @Override
        public String getXForwardedHost() {
            return null;
        }

        @Override
        public String getXForwardedPort() {
            return null;
        }

        @Override
        public String getForwardedFor() {
            return null;
        }

        @Override
        public String getXForwarded() {
            return null;
        }

        @Override
        public String getXForwardedFor() {
            return null;
        }

        @Override
        public String getXClusterClientIp() {
            return null;
        }

        @Override
        public String getXRealIp() {
            return null;
        }

        @Override
        public String getClientIp() {
            return null;
        }

        @Override
        public String getUserAgent() {
            return null;
        }

        @Override
        public String getVia() {
            return null;
        }

        @Override
        public String getTrueClientIp() {
            return null;
        }

        @Override
        public String getCustomIpHeader() {
            return null;
        }
    }

    static class NoopContinuation
    implements AgentScope.Continuation {
        static final NoopContinuation INSTANCE = new NoopContinuation();

        NoopContinuation() {
        }

        @Override
        public AgentScope activate() {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public void cancel() {
        }

        @Override
        public AgentSpan getSpan() {
            return NoopAgentSpan.INSTANCE;
        }
    }

    static class NoopAgentPropagation
    implements AgentPropagation {
        static final NoopAgentPropagation INSTANCE = new NoopAgentPropagation();

        NoopAgentPropagation() {
        }

        @Override
        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        }

        @Override
        public <C> void injectBinaryPathwayContext(AgentSpan span, C carrier, AgentPropagation.BinarySetter<C> setter, LinkedHashMap<String, String> sortedTags) {
        }

        @Override
        public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        }

        @Override
        public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return NoopContext.INSTANCE;
        }

        @Override
        public <C> PathwayContext extractBinaryPathwayContext(C carrier, AgentPropagation.BinaryContextVisitor<C> getter) {
            return null;
        }

        @Override
        public <C> PathwayContext extractPathwayContext(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return null;
        }
    }

    public static final class NoopAgentScope
    implements AgentScope {
        public static final NoopAgentScope INSTANCE = new NoopAgentScope();

        private NoopAgentScope() {
        }

        @Override
        public AgentSpan span() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public byte source() {
            return 0;
        }

        @Override
        public void setAsyncPropagation(boolean value) {
        }

        @Override
        public AgentScope.Continuation capture() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public AgentScope.Continuation captureConcurrent() {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean isAsyncPropagating() {
            return false;
        }
    }

    public static final class NoopAgentSpan
    implements AgentSpan {
        public static final NoopAgentSpan INSTANCE = new NoopAgentSpan();

        private NoopAgentSpan() {
        }

        @Override
        public DDTraceId getTraceId() {
            return DDTraceId.ZERO;
        }

        @Override
        public long getSpanId() {
            return 0L;
        }

        @Override
        public AgentSpan setTag(String key, boolean value) {
            return this;
        }

        @Override
        public void setRequestBlockingAction(Flow.Action.RequestBlockingAction rba) {
        }

        @Override
        public Flow.Action.RequestBlockingAction getRequestBlockingAction() {
            return null;
        }

        @Override
        public AgentSpan setTag(String tag, Number value) {
            return this;
        }

        @Override
        public boolean isError() {
            return false;
        }

        @Override
        public AgentSpan setTag(String key, int value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, long value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, double value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, Object value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, int value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, long value) {
            return this;
        }

        @Override
        public AgentSpan setMetric(CharSequence key, double value) {
            return this;
        }

        @Override
        public Object getTag(String key) {
            return null;
        }

        @Override
        public long getStartTime() {
            return 0L;
        }

        @Override
        public long getDurationNano() {
            return 0L;
        }

        @Override
        public String getOperationName() {
            return null;
        }

        @Override
        public AgentSpan setOperationName(CharSequence serviceName) {
            return this;
        }

        @Override
        public String getServiceName() {
            return null;
        }

        @Override
        public AgentSpan setServiceName(String serviceName) {
            return this;
        }

        @Override
        public CharSequence getResourceName() {
            return null;
        }

        @Override
        public AgentSpan setResourceName(CharSequence resourceName) {
            return this;
        }

        @Override
        public AgentSpan setResourceName(CharSequence resourceName, byte priority) {
            return this;
        }

        @Override
        public boolean eligibleForDropping() {
            return true;
        }

        @Override
        public void startWork() {
        }

        @Override
        public void finishWork() {
        }

        @Override
        public RequestContext getRequestContext() {
            return null;
        }

        @Override
        public void mergePathwayContext(PathwayContext pathwayContext) {
        }

        @Override
        public Integer getSamplingPriority() {
            return -128;
        }

        @Override
        public AgentSpan setSamplingPriority(int newPriority) {
            return this;
        }

        @Override
        public String getSpanType() {
            return null;
        }

        @Override
        public AgentSpan setSpanType(CharSequence type) {
            return this;
        }

        @Override
        public Map<String, Object> getTags() {
            return Collections.emptyMap();
        }

        @Override
        public AgentSpan setTag(String key, String value) {
            return this;
        }

        @Override
        public AgentSpan setTag(String key, CharSequence value) {
            return this;
        }

        @Override
        public AgentSpan setError(boolean error) {
            return this;
        }

        @Override
        public AgentSpan setMeasured(boolean measured) {
            return this;
        }

        @Override
        public AgentSpan getRootSpan() {
            return this;
        }

        @Override
        public AgentSpan setErrorMessage(String errorMessage) {
            return this;
        }

        @Override
        public AgentSpan addThrowable(Throwable throwable) {
            return this;
        }

        @Override
        public AgentSpan setHttpStatusCode(int statusCode) {
            return this;
        }

        @Override
        public short getHttpStatusCode() {
            return 0;
        }

        @Override
        public AgentSpan getLocalRootSpan() {
            return this;
        }

        @Override
        public boolean isSameTrace(AgentSpan otherSpan) {
            return otherSpan == INSTANCE;
        }

        @Override
        public AgentSpan.Context context() {
            return NoopContext.INSTANCE;
        }

        @Override
        public String getBaggageItem(String key) {
            return null;
        }

        @Override
        public AgentSpan setBaggageItem(String key, String value) {
            return this;
        }

        @Override
        public void finish() {
        }

        @Override
        public void finish(long finishMicros) {
        }

        @Override
        public void finishWithDuration(long durationNanos) {
        }

        @Override
        public void beginEndToEnd() {
        }

        @Override
        public void finishWithEndToEnd() {
        }

        @Override
        public boolean phasedFinish() {
            return false;
        }

        @Override
        public void publish() {
        }

        @Override
        public String getSpanName() {
            return "";
        }

        @Override
        public void setSpanName(CharSequence spanName) {
        }

        @Override
        public boolean hasResourceName() {
            return false;
        }

        @Override
        public byte getResourceNamePriority() {
            return 127;
        }
    }

    static class NoopTracerAPI
    implements TracerAPI {
        protected NoopTracerAPI() {
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentSpan startSpan(CharSequence spanName, AgentSpan.Context parent, long startTimeMicros) {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span, ScopeSource source) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentScope activateSpan(AgentSpan span, ScopeSource source, boolean isAsyncPropagating) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentScope.Continuation captureSpan(AgentSpan span, ScopeSource source) {
            return NoopContinuation.INSTANCE;
        }

        @Override
        public void closePrevious(boolean finishSpan) {
        }

        @Override
        public AgentScope activateNext(AgentSpan span) {
            return NoopAgentScope.INSTANCE;
        }

        @Override
        public AgentSpan activeSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public AgentScope activeScope() {
            return null;
        }

        @Override
        public AgentPropagation propagate() {
            return NoopAgentPropagation.INSTANCE;
        }

        @Override
        public AgentSpan noopSpan() {
            return NoopAgentSpan.INSTANCE;
        }

        @Override
        public SpanBuilder buildSpan(CharSequence spanName) {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public void addScopeListener(Runnable afterScopeActivatedCallback, Runnable afterScopeClosedCallback) {
        }

        @Override
        public void flush() {
        }

        @Override
        public void flushMetrics() {
        }

        @Override
        public String getTraceId() {
            return null;
        }

        @Override
        public String getSpanId() {
            return null;
        }

        @Override
        public boolean addTraceInterceptor(TraceInterceptor traceInterceptor) {
            return false;
        }

        @Override
        public void addScopeListener(ScopeListener listener) {
        }

        @Override
        public void registerCheckpointer(EndpointCheckpointer checkpointer) {
        }

        @Override
        public SubscriptionService getSubscriptionService(RequestContextSlot slot) {
            return SubscriptionService.SubscriptionServiceNoop.INSTANCE;
        }

        @Override
        public CallbackProvider getCallbackProvider(RequestContextSlot slot) {
            return CallbackProvider.CallbackProviderNoop.INSTANCE;
        }

        @Override
        public CallbackProvider getUniversalCallbackProvider() {
            return CallbackProvider.CallbackProviderNoop.INSTANCE;
        }

        @Override
        public AgentScope.Continuation capture() {
            return null;
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan.Context context, C carrier, AgentPropagation.Setter<C> setter) {
        }

        @Override
        public <C> void inject(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, TracePropagationStyle style) {
        }

        @Override
        public <C> void injectBinaryPathwayContext(AgentSpan span, C carrier, AgentPropagation.BinarySetter<C> setter, LinkedHashMap<String, String> sortedTags) {
        }

        @Override
        public <C> void injectPathwayContext(AgentSpan span, C carrier, AgentPropagation.Setter<C> setter, LinkedHashMap<String, String> sortedTags) {
        }

        @Override
        public <C> AgentSpan.Context.Extracted extract(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return null;
        }

        @Override
        public <C> PathwayContext extractBinaryPathwayContext(C carrier, AgentPropagation.BinaryContextVisitor<C> getter) {
            return null;
        }

        @Override
        public <C> PathwayContext extractPathwayContext(C carrier, AgentPropagation.ContextVisitor<C> getter) {
            return null;
        }

        @Override
        public void onRootSpanFinished(AgentSpan root, EndpointTracker tracker) {
        }

        @Override
        public EndpointTracker onRootSpanStarted(AgentSpan root) {
            return EndpointTracker.NO_OP;
        }

        @Override
        public void setDataStreamCheckpoint(AgentSpan span, LinkedHashMap<String, String> sortedTags) {
        }

        @Override
        public AgentSpan.Context notifyExtensionStart(Object event) {
            return null;
        }

        @Override
        public void notifyExtensionEnd(AgentSpan span, Object result, boolean isError) {
        }
    }

    public static interface SpanBuilder {
        public AgentSpan start();

        public SpanBuilder asChildOf(AgentSpan.Context var1);

        public SpanBuilder ignoreActiveSpan();

        public SpanBuilder withTag(String var1, String var2);

        public SpanBuilder withTag(String var1, boolean var2);

        public SpanBuilder withTag(String var1, Number var2);

        public SpanBuilder withTag(String var1, Object var2);

        public SpanBuilder withStartTimestamp(long var1);

        public SpanBuilder withServiceName(String var1);

        public SpanBuilder withResourceName(String var1);

        public SpanBuilder withErrorFlag();

        public SpanBuilder withSpanType(CharSequence var1);
    }

    public static interface TracerAPI
    extends Tracer,
    InternalTracer,
    AgentPropagation,
    EndpointCheckpointer {
        public AgentSpan startSpan(CharSequence var1);

        public AgentSpan startSpan(CharSequence var1, long var2);

        public AgentSpan startSpan(CharSequence var1, AgentSpan.Context var2);

        public AgentSpan startSpan(CharSequence var1, AgentSpan.Context var2, long var3);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2);

        public AgentScope activateSpan(AgentSpan var1, ScopeSource var2, boolean var3);

        public AgentScope.Continuation captureSpan(AgentSpan var1, ScopeSource var2);

        public void closePrevious(boolean var1);

        public AgentScope activateNext(AgentSpan var1);

        public AgentSpan activeSpan();

        public AgentScope activeScope();

        public AgentPropagation propagate();

        public AgentSpan noopSpan();

        public SpanBuilder buildSpan(CharSequence var1);

        public void close();

        public void addScopeListener(ScopeListener var1);

        public void registerCheckpointer(EndpointCheckpointer var1);

        public SubscriptionService getSubscriptionService(RequestContextSlot var1);

        public CallbackProvider getCallbackProvider(RequestContextSlot var1);

        public CallbackProvider getUniversalCallbackProvider();

        public void setDataStreamCheckpoint(AgentSpan var1, LinkedHashMap<String, String> var2);

        public AgentSpan.Context notifyExtensionStart(Object var1);

        public void notifyExtensionEnd(AgentSpan var1, Object var2, boolean var3);
    }
}

