/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.bootstrap.instrumentation.ci.git.pack;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

public final class GitPackUtils {
    private static final short V1_VERSION = 1;
    protected static final byte[] HEADER = new byte[]{-1, 116, 79, 99};

    private GitPackUtils() {
    }

    public static short extractGitPackVersion(File idxFile) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(idxFile, "r");){
            byte[] header = GitPackUtils.readBytes(raf, 4);
            if (!Arrays.equals(header, HEADER)) {
                short s = 1;
                return s;
            }
            int version = raf.readInt();
            short s = (short)version;
            return s;
        }
    }

    public static byte[] readBytes(RandomAccessFile file, int numBytes) throws IOException {
        byte[] buff = new byte[numBytes];
        file.readFully(buff);
        return buff;
    }

    public static byte[] hexToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    public static File getPackFile(File idxFile) {
        int i = idxFile.getName().lastIndexOf(46);
        String name = idxFile.getName().substring(0, i);
        return new File(idxFile.getParent(), name + ".pack");
    }
}

