/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.civisibility.writer.ddintake;

import datadog.trace.api.WellKnownTags;
import ddtrot.dd.communication.http.OkHttpUtils;
import ddtrot.dd.communication.serialization.GrowableBuffer;
import ddtrot.dd.communication.serialization.Writable;
import ddtrot.dd.communication.serialization.msgpack.MsgPackWriter;
import ddtrot.dd.trace.bootstrap.instrumentation.api.UTF8BytesString;
import ddtrot.dd.trace.common.writer.Payload;
import ddtrot.dd.trace.common.writer.RemoteMapper;
import ddtrot.dd.trace.core.CoreSpan;
import ddtrot.dd.trace.core.Metadata;
import ddtrot.dd.trace.core.MetadataConsumer;
import ddtrot.okhttp3.RequestBody;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class CiTestCycleMapperV1
implements RemoteMapper {
    public static final byte[] VERSION = "version".getBytes(StandardCharsets.UTF_8);
    public static final byte[] METADATA = "metadata".getBytes(StandardCharsets.UTF_8);
    public static final byte[] METADATA_ASTERISK = "*".getBytes(StandardCharsets.UTF_8);
    public static final byte[] EVENTS = "events".getBytes(StandardCharsets.UTF_8);
    public static final byte[] ENV = "env".getBytes(StandardCharsets.UTF_8);
    public static final byte[] TYPE = "type".getBytes(StandardCharsets.UTF_8);
    public static final byte[] CONTENT = "content".getBytes(StandardCharsets.UTF_8);
    public static final UTF8BytesString TEST_TYPE = UTF8BytesString.create("test");
    public static final UTF8BytesString SPAN_TYPE = UTF8BytesString.create("span");
    private final WellKnownTags wellKnownTags;
    private final int size;
    private final GrowableBuffer headerBuffer;
    private final MsgPackWriter headerWriter;
    private int eventCount = 0;
    private final MetaWriter metaWriter = new MetaWriter();

    public CiTestCycleMapperV1(WellKnownTags wellKnownTags, int size) {
        this.wellKnownTags = wellKnownTags;
        this.size = size;
        this.headerBuffer = new GrowableBuffer(16);
        this.headerWriter = new MsgPackWriter(this.headerBuffer);
    }

    public CiTestCycleMapperV1(WellKnownTags wellKnownTags) {
        this(wellKnownTags, 0x500000);
    }

    @Override
    public void map(List<? extends CoreSpan<?>> trace, Writable writable) {
        for (int i = 0; i < trace.size(); ++i) {
            CoreSpan<?> span = trace.get(i);
            writable.startMap(3);
            writable.writeUTF8(TYPE);
            if (TEST_TYPE.equals(span.getType())) {
                writable.writeUTF8(TEST_TYPE);
            } else {
                writable.writeUTF8(SPAN_TYPE);
            }
            writable.writeUTF8(VERSION);
            writable.writeInt(1);
            writable.writeUTF8(CONTENT);
            writable.startMap(11);
            writable.writeUTF8(SERVICE);
            writable.writeString(span.getServiceName(), null);
            writable.writeUTF8(NAME);
            writable.writeObject(span.getOperationName(), null);
            writable.writeUTF8(RESOURCE);
            writable.writeObject(span.getResourceName(), null);
            writable.writeUTF8(TRACE_ID);
            writable.writeLong(span.getTraceId().toLong());
            writable.writeUTF8(SPAN_ID);
            writable.writeLong(span.getSpanId());
            writable.writeUTF8(PARENT_ID);
            writable.writeLong(span.getParentId());
            writable.writeUTF8(START);
            writable.writeLong(span.getStartTime());
            writable.writeUTF8(DURATION);
            writable.writeLong(span.getDurationNano());
            writable.writeUTF8(ERROR);
            writable.writeInt(span.getError());
            span.processTagsAndBaggage(this.metaWriter.withWritable(writable));
        }
        this.eventCount += trace.size();
    }

    private void writeHeader() {
        this.headerWriter.startMap(3);
        this.headerWriter.writeUTF8(VERSION);
        this.headerWriter.writeInt(1);
        this.headerWriter.writeUTF8(METADATA);
        this.headerWriter.startMap(1);
        this.headerWriter.writeUTF8(METADATA_ASTERISK);
        this.headerWriter.startMap(3);
        this.headerWriter.writeUTF8(ENV);
        this.headerWriter.writeUTF8(this.wellKnownTags.getEnv());
        this.headerWriter.writeUTF8(RUNTIME_ID);
        this.headerWriter.writeUTF8(this.wellKnownTags.getRuntimeId());
        this.headerWriter.writeUTF8(LANGUAGE);
        this.headerWriter.writeUTF8(this.wellKnownTags.getLanguage());
        this.headerWriter.writeUTF8(EVENTS);
        this.headerWriter.startArray(this.eventCount);
    }

    @Override
    public Payload newPayload() {
        this.writeHeader();
        return new PayloadV1().withHeader(this.headerBuffer.slice());
    }

    @Override
    public int messageBufferSize() {
        return this.size;
    }

    @Override
    public void reset() {
        this.eventCount = 0;
    }

    @Override
    public String endpoint() {
        return "citestcycle/v1";
    }

    private static class PayloadV1
    extends Payload {
        ByteBuffer header = null;

        private PayloadV1() {
        }

        PayloadV1 withHeader(ByteBuffer header) {
            this.header = header;
            return this;
        }

        @Override
        public int sizeInBytes() {
            if (this.traceCount() == 0) {
                return this.msgpackMapHeaderSize(0);
            }
            int size = this.body.remaining();
            if (this.header != null) {
                size += this.header.remaining();
            }
            return size;
        }

        @Override
        public void writeTo(WritableByteChannel channel) throws IOException {
            if (this.traceCount() == 0) {
                ByteBuffer emptyDict = this.msgpackMapHeader(0);
                while (emptyDict.hasRemaining()) {
                    channel.write(emptyDict);
                }
            } else {
                if (this.header != null) {
                    while (this.header.hasRemaining()) {
                        channel.write(this.header);
                    }
                }
                while (this.body.hasRemaining()) {
                    channel.write(this.body);
                }
            }
        }

        @Override
        public RequestBody toRequest() {
            if (this.traceCount() == 0) {
                return OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.msgpackMapHeader(0)));
            }
            if (this.header != null) {
                return OkHttpUtils.msgpackRequestBodyOf(Arrays.asList(this.header, this.body));
            }
            return OkHttpUtils.msgpackRequestBodyOf(Collections.singletonList(this.body));
        }
    }

    private static final class MetaWriter
    extends MetadataConsumer {
        private Writable writable;

        private MetaWriter() {
        }

        MetaWriter withWritable(Writable writable) {
            this.writable = writable;
            return this;
        }

        @Override
        public void accept(Metadata metadata) {
            int metaSize = metadata.getBaggage().size() + metadata.getTags().size() + (null == metadata.getHttpStatusCode() ? 0 : 1);
            int metricsSize = 0;
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                ++metricsSize;
                --metaSize;
            }
            this.writable.writeUTF8(RemoteMapper.METRICS);
            this.writable.startMap(metricsSize);
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (!(entry.getValue() instanceof Number)) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObject(entry.getValue(), null);
            }
            this.writable.writeUTF8(RemoteMapper.META);
            this.writable.startMap(metaSize);
            for (Map.Entry<String, Object> entry : metadata.getBaggage().entrySet()) {
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeString((CharSequence)entry.getValue(), null);
            }
            if (null != metadata.getHttpStatusCode()) {
                this.writable.writeUTF8(RemoteMapper.HTTP_STATUS);
                this.writable.writeUTF8(metadata.getHttpStatusCode());
            }
            for (Map.Entry<String, Object> entry : metadata.getTags().entrySet()) {
                if (entry.getValue() instanceof Number) continue;
                this.writable.writeString(entry.getKey(), null);
                this.writable.writeObjectString(entry.getValue(), null);
            }
        }
    }
}

