/*
 * Decompiled with CFR 0.152.
 */
package ddtrot.dd.trace.core.datastreams;

import datadog.trace.api.Config;
import datadog.trace.api.WellKnownTags;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.ByteArrayInput;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.GrowingByteArrayOutput;
import ddtrot.com.datadoghq.sketch.ddsketch.encoding.VarEncodingHelper;
import ddtrot.dd.trace.api.time.TimeSource;
import ddtrot.dd.trace.bootstrap.instrumentation.api.AgentPropagation;
import ddtrot.dd.trace.bootstrap.instrumentation.api.PathwayContext;
import ddtrot.dd.trace.bootstrap.instrumentation.api.StatsPoint;
import ddtrot.dd.trace.core.Base64Decoder;
import ddtrot.dd.trace.core.Base64Encoder;
import ddtrot.dd.trace.core.datastreams.TagsProcessor;
import ddtrot.dd.trace.core.util.LRUCache;
import ddtrot.dd.trace.util.FNV64Hash;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPathwayContext
implements PathwayContext {
    private static final Logger log = LoggerFactory.getLogger(DefaultPathwayContext.class);
    private final Lock lock = new ReentrantLock();
    private final WellKnownTags wellKnownTags;
    private final TimeSource timeSource;
    private final GrowingByteArrayOutput outputBuffer = GrowingByteArrayOutput.withInitialCapacity(20);
    private long pathwayStartNanos;
    private long pathwayStartNanoTicks;
    private long edgeStartNanoTicks;
    private long hash;
    private boolean started;
    private final LRUCache<Long, Long> history = new LRUCache(10000);
    private static final Set<String> hashableTagKeys = new HashSet<String>(Arrays.asList("group", "type", "direction", "topic", "exchange"));

    public DefaultPathwayContext(TimeSource timeSource, WellKnownTags wellKnownTags) {
        this.timeSource = timeSource;
        this.wellKnownTags = wellKnownTags;
    }

    private DefaultPathwayContext(TimeSource timeSource, WellKnownTags wellKnownTags, long pathwayStartNanos, long pathwayStartNanoTicks, long edgeStartNanoTicks, long hash) {
        this.timeSource = timeSource;
        this.wellKnownTags = wellKnownTags;
        this.pathwayStartNanos = pathwayStartNanos;
        this.pathwayStartNanoTicks = pathwayStartNanoTicks;
        this.edgeStartNanoTicks = edgeStartNanoTicks;
        this.hash = hash;
        this.started = true;
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCheckpoint(LinkedHashMap<String, String> sortedTags, Consumer<StatsPoint> pointConsumer) {
        long startNanos = this.timeSource.getCurrentTimeNanos();
        long nanoTicks = this.timeSource.getNanoTicks();
        this.lock.lock();
        try {
            ArrayList<String> allTags = new ArrayList<String>(sortedTags.size());
            PathwayHashBuilder pathwayHashBuilder = new PathwayHashBuilder(this.wellKnownTags);
            if (!this.started) {
                this.pathwayStartNanos = startNanos;
                this.pathwayStartNanoTicks = nanoTicks;
                this.edgeStartNanoTicks = nanoTicks;
                this.hash = 0L;
                this.started = true;
                log.debug("Started {}", (Object)this);
            }
            for (Map.Entry<String, String> entry : sortedTags.entrySet()) {
                String tag = TagsProcessor.createTag(entry.getKey(), entry.getValue());
                if (tag == null) continue;
                if (hashableTagKeys.contains(entry.getKey())) {
                    pathwayHashBuilder.addTag(tag);
                }
                allTags.add(tag);
            }
            long nodeHash = this.generateNodeHash(pathwayHashBuilder);
            if (this.hash != 0L && this.history.containsKey(nodeHash)) {
                this.hash = (Long)this.history.get(nodeHash);
            } else {
                this.history.put(nodeHash, this.hash);
            }
            long newHash = this.generatePathwayHash(nodeHash, this.hash);
            long pathwayLatencyNano = nanoTicks - this.pathwayStartNanoTicks;
            long edgeLatencyNano = nanoTicks - this.edgeStartNanoTicks;
            StatsPoint point = new StatsPoint(allTags, newHash, this.hash, this.timeSource.getCurrentTimeNanos(), pathwayLatencyNano, edgeLatencyNano);
            this.edgeStartNanoTicks = nanoTicks;
            this.hash = newHash;
            pointConsumer.accept(point);
            log.debug("Checkpoint set {}", (Object)this);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] encode() throws IOException {
        this.lock.lock();
        try {
            if (!this.started) {
                throw new IllegalStateException("Context must be started to encode");
            }
            this.outputBuffer.clear();
            this.outputBuffer.writeLongLE(this.hash);
            long pathwayStartMillis = TimeUnit.NANOSECONDS.toMillis(this.pathwayStartNanos);
            VarEncodingHelper.encodeSignedVarLong(this.outputBuffer, pathwayStartMillis);
            long edgeStartMillis = pathwayStartMillis + TimeUnit.NANOSECONDS.toMillis(this.edgeStartNanoTicks - this.pathwayStartNanoTicks);
            VarEncodingHelper.encodeSignedVarLong(this.outputBuffer, edgeStartMillis);
            byte[] byArray = this.outputBuffer.trimmedCopy();
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String strEncode() throws IOException {
        byte[] bytes = this.encode();
        if (bytes == null) {
            return null;
        }
        return new String(Base64Encoder.INSTANCE.encode(bytes), StandardCharsets.UTF_8);
    }

    public String toString() {
        this.lock.lock();
        try {
            if (this.started) {
                String string = "PathwayContext[ Hash " + Long.toUnsignedString(this.hash) + ", Start: " + this.pathwayStartNanos + ", StartTicks: " + this.pathwayStartNanoTicks + ", Edge Start Ticks: " + this.edgeStartNanoTicks + ", objectHashcode:" + this.hashCode() + "]";
                return string;
            }
            String string = "PathwayContext [Not Started]";
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    public static <C> DefaultPathwayContext extract(C carrier, AgentPropagation.ContextVisitor<C> getter, TimeSource timeSource, WellKnownTags wellKnownTags) {
        PathwayContextExtractor pathwayContextExtractor = new PathwayContextExtractor(timeSource, wellKnownTags);
        getter.forEachKey(carrier, pathwayContextExtractor);
        if (pathwayContextExtractor.extractedContext == null) {
            log.debug("No context extracted");
        } else {
            log.debug("Extracted context: {} ", (Object)pathwayContextExtractor.extractedContext);
        }
        return pathwayContextExtractor.extractedContext;
    }

    public static <C> DefaultPathwayContext extractBinary(C carrier, AgentPropagation.BinaryContextVisitor<C> getter, TimeSource timeSource, WellKnownTags wellKnownTags) {
        BinaryPathwayContextExtractor pathwayContextExtractor = new BinaryPathwayContextExtractor(timeSource, wellKnownTags);
        getter.forEachKey(carrier, pathwayContextExtractor);
        if (pathwayContextExtractor.extractedContext == null) {
            log.debug("No context extracted");
        } else {
            log.debug("Extracted context: {} ", (Object)pathwayContextExtractor.extractedContext);
        }
        return pathwayContextExtractor.extractedContext;
    }

    public static DefaultPathwayContext strDecode(TimeSource timeSource, WellKnownTags wellKnownTags, String data) throws IOException {
        byte[] byteValue = Base64Decoder.INSTANCE.decode(data.getBytes(StandardCharsets.UTF_8));
        return DefaultPathwayContext.decode(timeSource, wellKnownTags, byteValue);
    }

    public static DefaultPathwayContext decode(TimeSource timeSource, WellKnownTags wellKnownTags, byte[] data) throws IOException {
        ByteArrayInput input = ByteArrayInput.wrap(data);
        long hash = input.readLongLE();
        long pathwayStartMillis = VarEncodingHelper.decodeSignedVarLong(input);
        long pathwayStartNanos = TimeUnit.MILLISECONDS.toNanos(pathwayStartMillis);
        long nowNanos = timeSource.getCurrentTimeNanos();
        long nanosSinceStart = nowNanos - pathwayStartNanos;
        long nowNanoTicks = timeSource.getNanoTicks();
        long pathwayStartNanoTicks = nowNanoTicks - nanosSinceStart;
        long edgeStartMillis = VarEncodingHelper.decodeSignedVarLong(input);
        long edgeStartNanoTicks = pathwayStartNanoTicks + TimeUnit.MILLISECONDS.toNanos(edgeStartMillis - pathwayStartMillis);
        return new DefaultPathwayContext(timeSource, wellKnownTags, pathwayStartNanos, pathwayStartNanoTicks, edgeStartNanoTicks, hash);
    }

    private long generateNodeHash(PathwayHashBuilder pathwayHashBuilder) {
        return pathwayHashBuilder.generateHash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generatePathwayHash(long nodeHash, long parentHash) {
        this.lock.lock();
        try {
            this.outputBuffer.clear();
            this.outputBuffer.writeLongLE(nodeHash);
            this.outputBuffer.writeLongLE(parentHash);
            long l = FNV64Hash.generateHash(this.outputBuffer.backingArray(), 0, 16, FNV64Hash.Version.v1);
            return l;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static class PathwayHashBuilder {
        private final StringBuilder builder = new StringBuilder();

        public PathwayHashBuilder(WellKnownTags wellKnownTags) {
            this.builder.append(wellKnownTags.getService());
            this.builder.append(wellKnownTags.getEnv());
            String primaryTag = Config.get().getPrimaryTag();
            if (primaryTag != null) {
                this.builder.append(primaryTag);
            }
        }

        public void addTag(String tag) {
            this.builder.append(tag);
        }

        public long generateHash() {
            return FNV64Hash.generateHash(this.builder.toString(), FNV64Hash.Version.v1);
        }
    }

    private static class BinaryPathwayContextExtractor
    implements AgentPropagation.BinaryKeyClassifier {
        private final TimeSource timeSource;
        private final WellKnownTags wellKnownTags;
        private DefaultPathwayContext extractedContext;

        BinaryPathwayContextExtractor(TimeSource timeSource, WellKnownTags wellKnownTags) {
            this.timeSource = timeSource;
            this.wellKnownTags = wellKnownTags;
        }

        @Override
        public boolean accept(String key, byte[] value) {
            if ("dd-pathway-ctx".equalsIgnoreCase(key)) {
                try {
                    this.extractedContext = DefaultPathwayContext.decode(this.timeSource, this.wellKnownTags, value);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        }
    }

    private static class PathwayContextExtractor
    implements AgentPropagation.KeyClassifier {
        private final TimeSource timeSource;
        private final WellKnownTags wellKnownTags;
        private DefaultPathwayContext extractedContext;

        PathwayContextExtractor(TimeSource timeSource, WellKnownTags wellKnownTags) {
            this.timeSource = timeSource;
            this.wellKnownTags = wellKnownTags;
        }

        @Override
        public boolean accept(String key, String value) {
            if ("dd-pathway-ctx-base64".equalsIgnoreCase(key)) {
                try {
                    this.extractedContext = DefaultPathwayContext.strDecode(this.timeSource, this.wellKnownTags, value);
                }
                catch (IOException e) {
                    return false;
                }
            }
            return true;
        }
    }
}

